/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.console;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.BooleanFunction;
import com.intellij.ws.http.request.run.console.HttpClientMessagePrinter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpResponsePresentation {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.console.HttpResponsePresentation");

    public abstract boolean canBeReformatted();

    public abstract void print(@NotNull Project var1, @NotNull HttpClientMessagePrinter var2, @Nullable String var3, @NotNull FileType var4, @NotNull BooleanFunction<? super FileType> var5);

    @NotNull
    public static HttpResponsePresentation createErrorResponse(@NotNull String text) {
        if (text == null) {
            HttpResponsePresentation.$$$reportNull$$$0(0);
        }
        HttpErrorResponsePresentation httpErrorResponsePresentation = new HttpErrorResponsePresentation(text);
        if (httpErrorResponsePresentation == null) {
            HttpResponsePresentation.$$$reportNull$$$0(1);
        }
        return httpErrorResponsePresentation;
    }

    @NotNull
    public static HttpResponsePresentation createResponse(@Nullable String header, @NotNull String response, @NotNull String status, boolean inplace) {
        if (response == null) {
            HttpResponsePresentation.$$$reportNull$$$0(2);
        }
        if (status == null) {
            HttpResponsePresentation.$$$reportNull$$$0(3);
        }
        HttpSucceedResponsePresentation httpSucceedResponsePresentation = inplace ? new HttpInplaceSucceedResponsePresentation(header, response, status) : new HttpSucceedResponsePresentation(header, status);
        if (httpSucceedResponsePresentation == null) {
            HttpResponsePresentation.$$$reportNull$$$0(4);
        }
        return httpSucceedResponsePresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/console/HttpResponsePresentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/console/HttpResponsePresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorResponse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createResponse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createErrorResponse";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createResponse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HttpErrorResponsePresentation
    extends HttpResponsePresentation {
        private final String myText;

        private HttpErrorResponsePresentation(@NotNull String text) {
            if (text == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Override
        public boolean canBeReformatted() {
            return false;
        }

        @Override
        public void print(@NotNull Project project, @NotNull HttpClientMessagePrinter printer, @Nullable String pathToResponse, @NotNull FileType fileType, @NotNull BooleanFunction<? super FileType> isValid) {
            if (project == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(1);
            }
            if (printer == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(2);
            }
            if (fileType == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(3);
            }
            if (isValid == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(4);
            }
            printer.print(this.myText, ConsoleViewContentType.ERROR_OUTPUT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isValid";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/run/console/HttpResponsePresentation$HttpErrorResponsePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpInplaceSucceedResponsePresentation
    extends HttpSucceedResponsePresentation {
        private final String myResponse;

        private HttpInplaceSucceedResponsePresentation(String header, String response, String status) {
            super(header, status);
            this.myResponse = response;
        }

        @Override
        public boolean canBeReformatted() {
            return true;
        }

        @Override
        public void print(@NotNull Project project, @NotNull HttpClientMessagePrinter printer, @Nullable String pathToResponse, @NotNull FileType fileType, @NotNull BooleanFunction<? super FileType> isValid) {
            if (project == null) {
                HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(0);
            }
            if (printer == null) {
                HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(1);
            }
            if (fileType == null) {
                HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(2);
            }
            if (isValid == null) {
                HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(3);
            }
            this.printHeader(printer);
            if (fileType != PlainTextFileType.INSTANCE && StringUtil.isNotEmpty((String)this.myResponse)) {
                String fileName = "DUMMY__." + fileType.getDefaultExtension();
                PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, fileType, (CharSequence)this.myResponse, System.currentTimeMillis(), true);
                ReformatCodeProcessor processor = new ReformatCodeProcessor(file, false);
                processor.setPostRunnable(() -> {
                    if (isValid == null) {
                        HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(4);
                    }
                    if (fileType == null) {
                        HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(5);
                    }
                    if (printer == null) {
                        HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(6);
                    }
                    if (isValid.fun((Object)fileType)) {
                        printer.printAsFileType(file.getText(), fileType);
                        printer.print("\n\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                        this.printStatus(printer);
                    } else {
                        LOG.info("File formatted as " + fileType.getName() + " but another type is active");
                    }
                });
                processor.run();
            } else {
                printer.print(this.myResponse, ConsoleViewContentType.NORMAL_OUTPUT);
                printer.print("\n\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                this.printStatus(printer);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isValid";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/run/console/HttpResponsePresentation$HttpInplaceSucceedResponsePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$print$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpSucceedResponsePresentation
    extends HttpResponsePresentation {
        private static final String EMPTY_BODY = "<Response body is empty>\n\n";
        private final String myHeader;
        private final String myStatus;

        private HttpSucceedResponsePresentation(String header, String status) {
            this.myHeader = header;
            this.myStatus = status;
        }

        @Override
        public boolean canBeReformatted() {
            return false;
        }

        @Override
        public void print(@NotNull Project project, @NotNull HttpClientMessagePrinter printer, @Nullable String pathToResponse, @NotNull FileType fileType, @NotNull BooleanFunction<? super FileType> isValid) {
            if (project == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(0);
            }
            if (printer == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(1);
            }
            if (fileType == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(2);
            }
            if (isValid == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(3);
            }
            this.printHeader(printer);
            printer.print(StringUtil.isNotEmpty((String)pathToResponse) ? "> " + pathToResponse + "\n\n" : EMPTY_BODY, ConsoleViewContentType.NORMAL_OUTPUT);
            this.printStatus(printer);
        }

        protected void printHeader(@NotNull HttpClientMessagePrinter printer) {
            if (printer == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(4);
            }
            if (StringUtil.isNotEmpty((String)this.myHeader)) {
                printer.print(this.myHeader, ConsoleViewContentType.SYSTEM_OUTPUT);
                printer.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        }

        protected void printStatus(@NotNull HttpClientMessagePrinter printer) {
            if (printer == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(5);
            }
            printer.print(this.myStatus + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isValid";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/run/console/HttpResponsePresentation$HttpSucceedResponsePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printHeader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printStatus";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

