/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaTestExecutionPolicy {
    private static IdeaTestExecutionPolicy ourCurrent = null;

    public abstract void setUp(Project var1, Disposable var2, String var3);

    public abstract TempDirTestFixture createTempDirTestFixture();

    public abstract boolean runInDispatchThread();

    public void testFileConfigured(@NotNull PsiFile file) {
        if (file == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(0);
        }
    }

    public void beforeCheckResult(@NotNull PsiFile file) {
        if (file == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(1);
        }
    }

    public String getHomePath() {
        return null;
    }

    public String getPerTestTempDirName() {
        return null;
    }

    @Nullable
    public static IdeaTestExecutionPolicy current() {
        if (ourCurrent != null) {
            return ourCurrent;
        }
        String policyClassName = System.getProperty("idea.test.execution.policy");
        if (policyClassName == null) {
            return null;
        }
        try {
            Class<?> policyClass = Class.forName(policyClassName);
            ourCurrent = (IdeaTestExecutionPolicy)policyClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return ourCurrent;
    }

    public static String getHomePathWithPolicy() {
        String policyHomePath;
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null && (policyHomePath = policy.getHomePath()) != null) {
            return policyHomePath;
        }
        return PathManager.getHomePath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/testFramework/fixtures/IdeaTestExecutionPolicy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "testFileConfigured";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCheckResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

