/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.ide.ui.ProductIcons;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.createproject.ActionTypeDescription;
import com.jetbrains.plugins.webDeployment.actions.createproject.FileChooserStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.SpecifyLocalPathStep;
import com.jetbrains.plugins.webDeployment.ui.UiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeploymentFileChooserDialog
extends FileChooserDialogImpl {
    private final EventDispatcher<StateChangeListener> myEventDispatcher;
    private VirtualFile myProjectRoot;
    private final MultiMap<String, VirtualFile> myActionPaths;
    private final VirtualFile myToSelect;

    DeploymentFileChooserDialog(@NotNull FileChooserDescriptor descriptor, @Nullable Project project) {
        if (descriptor == null) {
            DeploymentFileChooserDialog.$$$reportNull$$$0(0);
        }
        super(descriptor, project);
        this.myEventDispatcher = EventDispatcher.create(StateChangeListener.class);
        this.myActionPaths = new MultiMap();
        String baseDir = SpecifyLocalPathStep.getDefaultBaseDir();
        this.myToSelect = baseDir == null ? null : LocalFileSystem.getInstance().findFileByPath(baseDir);
    }

    public JComponent getTitlePane() {
        return this.createTitlePane();
    }

    public JComponent createCenterPanel() {
        JComponent panel = super.createCenterPanel();
        this.restoreSelection(this.myToSelect);
        return panel;
    }

    @Nullable
    public VirtualFile getProjectRoot() {
        if (this.myProjectRoot != null) {
            return this.myProjectRoot;
        }
        VirtualFile[] path = this.myFileSystemTree.getSelectedFiles();
        if (path.length != 1) {
            return this.myProjectRoot;
        }
        return path[0];
    }

    @Nullable
    protected JPanel createExtraToolbarPanel() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        JTree tree = this.myFileSystemTree.getTree();
        SetRootFolderAction setRootFolderAction = new SetRootFolderAction();
        actionGroup.add((AnAction)setRootFolderAction);
        setRootFolderAction.registerCustomShortcutSet(setRootFolderAction.getShortcutSet(), tree, this.myDisposable);
        for (ActionTypeDescription.Local description : FileChooserStep.LOCAL_ACTION_TYPE_DESCRIPTIONS) {
            ParametrizedAction action = new ParametrizedAction(description);
            actionGroup.add((AnAction)action);
            action.registerCustomShortcutSet(action.getShortcutSet(), tree, this.myDisposable);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("WebDeploymentFileChooser", (ActionGroup)actionGroup, true);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)toolbar.getComponent(), "Center");
        return toolbarPanel;
    }

    protected JTree createTree() {
        super.createTree();
        NodeRenderer renderer = new NodeRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                VirtualFile file;
                Object userObject;
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof FileNodeDescriptor && (file = ((FileNodeDescriptor)userObject).getElement().getFile()) != null) {
                    for (ActionTypeDescription.Local desc : FileChooserStep.LOCAL_ACTION_TYPE_DESCRIPTIONS) {
                        if (!DeploymentFileChooserDialog.this.isActionApplied(desc, new VirtualFile[]{file})) continue;
                        this.setIcon(desc.closedIcon);
                        return;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$1", "customizeCellRenderer"));
            }
        };
        this.myFileSystemTree.addListener(new FileSystemTree.Listener(){

            public void selectionChanged(@NotNull List<? extends VirtualFile> selection) {
                if (selection == null) {
                    2.$$$reportNull$$$0(0);
                }
                ((StateChangeListener)DeploymentFileChooserDialog.this.myEventDispatcher.getMulticaster()).stateChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$2", "selectionChanged"));
            }
        }, this.myDisposable);
        JTree tree = this.myFileSystemTree.getTree();
        tree.setCellRenderer((TreeCellRenderer)renderer);
        tree.setOpaque(false);
        return tree;
    }

    @NotNull
    protected Tree createInternalTree() {
        Tree tree = new Tree(){

            @Nullable
            public Color getFileColorFor(Object object) {
                if (object instanceof FileNodeDescriptor && DeploymentFileChooserDialog.this.isMapped(((FileNodeDescriptor)object).getElement().getFile())) {
                    return UiConstants.NodeAttributes.MAPPED_BACKGROUND;
                }
                return super.getFileColorFor(object);
            }

            public boolean isFileColorsEnabled() {
                return true;
            }
        };
        if (tree == null) {
            DeploymentFileChooserDialog.$$$reportNull$$$0(1);
        }
        return tree;
    }

    protected void createDefaultActions() {
        DialogWrapper.DialogWrapperAction disabledAction = new DialogWrapper.DialogWrapperAction(""){

            public boolean isEnabled() {
                return false;
            }

            protected void doAction(ActionEvent e) {
            }
        };
        this.myOKAction = disabledAction;
        this.myCancelAction = disabledAction;
        this.myHelpAction = disabledAction;
    }

    private boolean isMapped(VirtualFile file) {
        if (!this.isUnderRoot(file)) {
            return false;
        }
        for (VirtualFile excluded : this.myActionPaths.get((Object)ActionTypeDescription.LOCAL_EXCLUDE_FOLDERS_ACTION_DESCRIPTION.key)) {
            if (!VfsUtilCore.isAncestor((VirtualFile)excluded, (VirtualFile)file, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    public MultiMap<String, VirtualFile> getActionPaths() {
        return this.myActionPaths;
    }

    public void addListener(StateChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    private boolean isUnderRoot(VirtualFile ... files) {
        if (this.myProjectRoot == null) {
            return false;
        }
        for (VirtualFile file : files) {
            if (file != null && VfsUtilCore.isAncestor((VirtualFile)this.myProjectRoot, (VirtualFile)file, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private boolean isActionApplied(ActionTypeDescription.Local desc, VirtualFile ... paths) {
        if (desc.isRecursive) {
            for (VirtualFile path : paths) {
                boolean found = false;
                for (VirtualFile remotePath : this.myActionPaths.get((Object)desc.key)) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)remotePath, (VirtualFile)path, (boolean)false)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        } else {
            for (VirtualFile path : paths) {
                if (this.myActionPaths.get((Object)desc.key).contains(path)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createInternalTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ParametrizedAction
    extends ToggleAction
    implements DumbAware {
        private final ActionTypeDescription.Local myDescription;

        private ParametrizedAction(ActionTypeDescription.Local description) {
            super(description.title, description.description, description.closedIcon);
            this.myDescription = description;
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(description.keystroke, 512), null)}));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ParametrizedAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            boolean underRoot = DeploymentFileChooserDialog.this.isUnderRoot(DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles());
            e.getPresentation().setEnabled(underRoot);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            VirtualFile[] paths;
            if (e == null) {
                ParametrizedAction.$$$reportNull$$$0(1);
            }
            if (!DeploymentFileChooserDialog.this.isUnderRoot(paths = DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles())) {
                return false;
            }
            return DeploymentFileChooserDialog.this.isActionApplied(this.myDescription, paths);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ParametrizedAction.$$$reportNull$$$0(2);
            }
            VirtualFile[] selectedPaths = DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles();
            if (state) {
                Collection paths = DeploymentFileChooserDialog.this.myActionPaths.get((Object)this.myDescription.key);
                VirtualFile[] virtualFileArray = selectedPaths;
                int n = virtualFileArray.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile path = virtualFileArray[i];
                    if (paths.contains(path)) continue;
                    DeploymentFileChooserDialog.this.myActionPaths.putValue((Object)this.myDescription.key, (Object)path);
                }
            } else {
                for (VirtualFile path : selectedPaths) {
                    DeploymentFileChooserDialog.this.myActionPaths.remove((Object)this.myDescription.key, (Object)path);
                }
            }
            for (VirtualFile path : selectedPaths) {
                DeploymentFileChooserDialog.this.myFileSystemTree.getTreeBuilder().queueUpdateFrom((Object)path, false, false);
            }
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$ParametrizedAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SetRootFolderAction
    extends ToggleAction
    implements DumbAware {
        private SetRootFolderAction() {
            super(WDBundle.message("project.root.action.text", new Object[0]), WDBundle.message("project.root.action.description", new Object[0]), ProductIcons.getInstance().getProjectIcon());
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(74, 512), null)}));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SetRootFolderAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabled(DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles().length == 1);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            VirtualFile[] path;
            if (e == null) {
                SetRootFolderAction.$$$reportNull$$$0(1);
            }
            if ((path = DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles()).length != 1) {
                return false;
            }
            return path[0].equals(DeploymentFileChooserDialog.this.myProjectRoot);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            VirtualFile[] path;
            if (e == null) {
                SetRootFolderAction.$$$reportNull$$$0(2);
            }
            if ((path = DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles()).length != 1) {
                return;
            }
            VirtualFile oldRoot = DeploymentFileChooserDialog.this.myProjectRoot;
            if (state) {
                DeploymentFileChooserDialog.this.myProjectRoot = path[0];
            } else {
                DeploymentFileChooserDialog.this.myProjectRoot = null;
            }
            if (oldRoot != null) {
                DeploymentFileChooserDialog.this.myFileSystemTree.getTreeBuilder().queueUpdateFrom((Object)oldRoot, false);
            }
            if (DeploymentFileChooserDialog.this.myProjectRoot != null) {
                DeploymentFileChooserDialog.this.myFileSystemTree.getTreeBuilder().queueUpdateFrom((Object)DeploymentFileChooserDialog.this.myProjectRoot, false);
            }
            ((StateChangeListener)DeploymentFileChooserDialog.this.myEventDispatcher.getMulticaster()).stateChanged();
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$SetRootFolderAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface StateChangeListener
    extends EventListener {
        public void stateChanged();
    }
}

