/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.BasePackConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.GitProtocolConstants;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.SideBandInputStream;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.util.TemporaryBuffer;

public abstract class BasePackFetchConnection
extends BasePackConnection
implements FetchConnection {
    private static final int MAX_HAVES = 256;
    protected static final int MIN_CLIENT_BUFFER = 2952;
    public static final String OPTION_INCLUDE_TAG = "include-tag";
    public static final String OPTION_MULTI_ACK = "multi_ack";
    public static final String OPTION_MULTI_ACK_DETAILED = "multi_ack_detailed";
    public static final String OPTION_THIN_PACK = "thin-pack";
    public static final String OPTION_SIDE_BAND = "side-band";
    public static final String OPTION_SIDE_BAND_64K = "side-band-64k";
    public static final String OPTION_OFS_DELTA = "ofs-delta";
    public static final String OPTION_SHALLOW = "shallow";
    public static final String OPTION_NO_PROGRESS = "no-progress";
    public static final String OPTION_NO_DONE = "no-done";
    public static final String OPTION_ALLOW_TIP_SHA1_IN_WANT = "allow-tip-sha1-in-want";
    public static final String OPTION_ALLOW_REACHABLE_SHA1_IN_WANT = "allow-reachable-sha1-in-want";
    public static final String OPTION_FILTER = "filter";
    private final RevWalk walk;
    private RevCommitList<RevCommit> reachableCommits;
    final RevFlag REACHABLE;
    final RevFlag COMMON;
    private final RevFlag STATE;
    final RevFlag ADVERTISED;
    private GitProtocolConstants.MultiAck multiAck = GitProtocolConstants.MultiAck.OFF;
    private boolean thinPack;
    private boolean sideband;
    private boolean includeTags;
    private boolean allowOfsDelta;
    private boolean noDone;
    private boolean noProgress;
    private Set<AnyObjectId> minimalNegotiationSet;
    private String lockMessage;
    private PackLock packLock;
    private TemporaryBuffer.Heap state;
    private PacketLineOut pckState;
    private final long filterBlobLimit;

    public BasePackFetchConnection(PackTransport packTransport) {
        super(packTransport);
        if (this.local != null) {
            FetchConfig cfg = this.getFetchConfig();
            this.allowOfsDelta = cfg.allowOfsDelta;
            if (cfg.minimalNegotiation) {
                this.minimalNegotiationSet = new HashSet<AnyObjectId>();
            }
        } else {
            this.allowOfsDelta = true;
        }
        this.includeTags = this.transport.getTagOpt() != TagOpt.NO_TAGS;
        this.thinPack = this.transport.isFetchThin();
        this.filterBlobLimit = this.transport.getFilterBlobLimit();
        if (this.local != null) {
            this.walk = new RevWalk(this.local);
            this.reachableCommits = new RevCommitList();
            this.REACHABLE = this.walk.newFlag("REACHABLE");
            this.COMMON = this.walk.newFlag("COMMON");
            this.STATE = this.walk.newFlag("STATE");
            this.ADVERTISED = this.walk.newFlag("ADVERTISED");
            this.walk.carry(this.COMMON);
            this.walk.carry(this.REACHABLE);
            this.walk.carry(this.ADVERTISED);
        } else {
            this.walk = null;
            this.REACHABLE = null;
            this.COMMON = null;
            this.STATE = null;
            this.ADVERTISED = null;
        }
    }

    @Override
    public final void fetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        this.fetch(monitor, want, have, null);
    }

    @Override
    public final void fetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have, OutputStream outputStream) throws TransportException {
        this.markStartedOperation();
        this.doFetch(monitor, want, have, outputStream);
    }

    @Override
    public boolean didFetchIncludeTags() {
        return false;
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return false;
    }

    @Override
    public void setPackLockMessage(String message) {
        this.lockMessage = message;
    }

    @Override
    public Collection<PackLock> getPackLocks() {
        if (this.packLock != null) {
            return Collections.singleton(this.packLock);
        }
        return Collections.emptyList();
    }

    protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have, OutputStream outputStream) throws TransportException {
        try {
            this.noProgress = monitor == NullProgressMonitor.INSTANCE;
            this.markRefsAdvertised();
            this.markReachable(have, this.maxTimeWanted(want));
            if (this.statelessRPC) {
                this.state = new TemporaryBuffer.Heap(Integer.MAX_VALUE);
                this.pckState = new PacketLineOut(this.state);
            }
            if (this.sendWants(want)) {
                this.negotiate(monitor);
                this.walk.dispose();
                this.reachableCommits = null;
                this.state = null;
                this.pckState = null;
                this.receivePack(monitor, outputStream);
            }
        }
        catch (CancelledException ce) {
            this.close();
            return;
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
    }

    @Override
    public void close() {
        if (this.walk != null) {
            this.walk.close();
        }
        super.close();
    }

    FetchConfig getFetchConfig() {
        return this.local.getConfig().get(FetchConfig::new);
    }

    private int maxTimeWanted(Collection<Ref> wants) {
        int maxTime = 0;
        for (Ref r : wants) {
            try {
                int cTime;
                RevObject obj = this.walk.parseAny(r.getObjectId());
                if (!(obj instanceof RevCommit) || maxTime >= (cTime = ((RevCommit)obj).getCommitTime())) continue;
                maxTime = cTime;
            }
            catch (IOException iOException) {}
        }
        return maxTime;
    }

    private void markReachable(Set<ObjectId> have, int maxTime) throws IOException {
        for (Ref r : this.local.getRefDatabase().getRefs()) {
            ObjectId id = r.getPeeledObjectId();
            if (id == null) {
                id = r.getObjectId();
            }
            if (id == null) continue;
            this.parseReachable(id);
        }
        for (ObjectId id : this.local.getAdditionalHaves()) {
            this.parseReachable(id);
        }
        for (ObjectId id : have) {
            this.parseReachable(id);
        }
        if (maxTime > 0) {
            RevCommit c;
            Date maxWhen = new Date((long)maxTime * 1000L);
            this.walk.sort(RevSort.COMMIT_TIME_DESC);
            this.walk.markStart(this.reachableCommits);
            this.walk.setRevFilter(CommitTimeRevFilter.after(maxWhen));
            while ((c = this.walk.next()) != null) {
                if (!c.has(this.ADVERTISED) || c.has(this.COMMON)) continue;
                c.add(this.COMMON);
                c.carry(this.COMMON);
                this.reachableCommits.add(c);
            }
        }
    }

    private void parseReachable(ObjectId id) {
        try {
            RevCommit o = this.walk.parseCommit(id);
            if (!o.has(this.REACHABLE)) {
                o.add(this.REACHABLE);
                this.reachableCommits.add(o);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean sendWants(Collection<Ref> want) throws IOException {
        PacketLineOut p = this.statelessRPC ? this.pckState : this.pckOut;
        boolean first = true;
        for (Ref r : want) {
            ObjectId o;
            Ref current;
            ObjectId objectId = r.getObjectId();
            if (objectId == null) continue;
            try {
                if (this.walk.parseAny(objectId).has(this.REACHABLE)) {
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            StringBuilder line = new StringBuilder(46);
            line.append("want ");
            line.append(objectId.name());
            if (first) {
                line.append(this.enableCapabilities());
                first = false;
            }
            line.append('\n');
            p.writeString(line.toString());
            if (this.minimalNegotiationSet == null || (current = this.local.exactRef(r.getName())) == null || (o = current.getObjectId()) == null || o.equals(ObjectId.zeroId())) continue;
            this.minimalNegotiationSet.add(o);
        }
        if (first) {
            return false;
        }
        if (this.filterBlobLimit == 0L) {
            p.writeString("filter blob:none");
        } else if (this.filterBlobLimit > 0L) {
            p.writeString("filter blob:limit=" + this.filterBlobLimit);
        }
        p.end();
        this.outNeedsEnd = false;
        return true;
    }

    private String enableCapabilities() throws TransportException {
        StringBuilder line = new StringBuilder();
        if (this.noProgress) {
            this.wantCapability(line, OPTION_NO_PROGRESS);
        }
        if (this.includeTags) {
            this.includeTags = this.wantCapability(line, OPTION_INCLUDE_TAG);
        }
        if (this.allowOfsDelta) {
            this.wantCapability(line, OPTION_OFS_DELTA);
        }
        if (this.wantCapability(line, OPTION_MULTI_ACK_DETAILED)) {
            this.multiAck = GitProtocolConstants.MultiAck.DETAILED;
            if (this.statelessRPC) {
                this.noDone = this.wantCapability(line, OPTION_NO_DONE);
            }
        } else {
            this.multiAck = this.wantCapability(line, OPTION_MULTI_ACK) ? GitProtocolConstants.MultiAck.CONTINUE : GitProtocolConstants.MultiAck.OFF;
        }
        if (this.thinPack) {
            this.thinPack = this.wantCapability(line, OPTION_THIN_PACK);
        }
        if (this.wantCapability(line, OPTION_SIDE_BAND_64K)) {
            this.sideband = true;
        } else if (this.wantCapability(line, OPTION_SIDE_BAND)) {
            this.sideband = true;
        }
        if (this.statelessRPC && this.multiAck != GitProtocolConstants.MultiAck.DETAILED) {
            throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().statelessRPCRequiresOptionToBeEnabled, OPTION_MULTI_ACK_DETAILED));
        }
        if (this.filterBlobLimit >= 0L && !this.wantCapability(line, OPTION_FILTER)) {
            throw new PackProtocolException(this.uri, JGitText.get().filterRequiresCapability);
        }
        this.addUserAgentCapability(line);
        return line.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void negotiate(ProgressMonitor monitor) throws IOException, CancelledException {
        RevCommit c;
        MutableObjectId ackId = new MutableObjectId();
        int resultsPending = 0;
        int havesSent = 0;
        int havesSinceLastContinue = 0;
        boolean receivedContinue = false;
        boolean receivedAck = false;
        boolean receivedReady = false;
        if (this.statelessRPC) {
            this.state.writeTo(this.out, null);
        }
        this.negotiateBegin();
        block10: while ((c = this.walk.next()) != null) {
            ObjectId o = c.getId();
            this.pckOut.writeString("have " + o.name() + "\n");
            ++havesSent;
            ++havesSinceLastContinue;
            if (this.minimalNegotiationSet != null) {
                this.minimalNegotiationSet.remove(o);
            }
            if ((0x1F & havesSent) != 0) continue;
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.pckOut.end();
            ++resultsPending;
            if (havesSent == 32 && !this.statelessRPC) continue;
            block11: while (true) {
                PacketLineIn.AckNackResult anr = this.pckIn.readACK(ackId);
                switch (anr) {
                    case NAK: {
                        --resultsPending;
                        if (this.minimalNegotiationSet == null || !this.minimalNegotiationSet.isEmpty()) break block11;
                        if (!this.statelessRPC) break block10;
                        this.state.writeTo(this.out, null);
                        break block10;
                    }
                    case ACK: {
                        this.multiAck = GitProtocolConstants.MultiAck.OFF;
                        resultsPending = 0;
                        receivedAck = true;
                        if (!this.statelessRPC) break block10;
                        this.state.writeTo(this.out, null);
                        break block10;
                    }
                    case ACK_CONTINUE: 
                    case ACK_COMMON: 
                    case ACK_READY: {
                        this.markCommon(this.walk.parseAny(ackId), anr);
                        receivedAck = true;
                        receivedContinue = true;
                        havesSinceLastContinue = 0;
                        if (anr == PacketLineIn.AckNackResult.ACK_READY) {
                            receivedReady = true;
                        }
                        if (this.minimalNegotiationSet != null && this.minimalNegotiationSet.isEmpty()) {
                            if (!this.statelessRPC) break block10;
                            this.state.writeTo(this.out, null);
                            break block10;
                        }
                    }
                    default: {
                        if (!monitor.isCancelled()) continue block11;
                        throw new CancelledException();
                    }
                }
                break;
            }
            if (this.noDone & receivedReady) break;
            if (this.statelessRPC) {
                this.state.writeTo(this.out, null);
            }
            if (!receivedContinue || havesSinceLastContinue <= 256) continue;
        }
        if (monitor.isCancelled()) {
            throw new CancelledException();
        }
        if (!receivedReady || !this.noDone) {
            this.pckOut.writeString("done\n");
            this.pckOut.flush();
        }
        if (!receivedAck) {
            this.multiAck = GitProtocolConstants.MultiAck.OFF;
            ++resultsPending;
        }
        do {
            if (resultsPending <= 0) {
                if (this.multiAck == GitProtocolConstants.MultiAck.OFF) return;
            }
            PacketLineIn.AckNackResult anr = this.pckIn.readACK(ackId);
            --resultsPending;
            switch (anr) {
                case NAK: {
                    break;
                }
                case ACK: {
                    return;
                }
                case ACK_CONTINUE: 
                case ACK_COMMON: 
                case ACK_READY: {
                    this.multiAck = GitProtocolConstants.MultiAck.CONTINUE;
                }
            }
        } while (!monitor.isCancelled());
        throw new CancelledException();
    }

    private void negotiateBegin() throws IOException {
        this.walk.resetRetain(this.REACHABLE, this.ADVERTISED);
        this.walk.markStart(this.reachableCommits);
        this.walk.sort(RevSort.COMMIT_TIME_DESC);
        this.walk.setRevFilter(new RevFilter(){

            @Override
            public RevFilter clone() {
                return this;
            }

            @Override
            public boolean include(RevWalk walker, RevCommit c) {
                boolean remoteKnowsIsCommon = c.has(BasePackFetchConnection.this.COMMON);
                if (c.has(BasePackFetchConnection.this.ADVERTISED)) {
                    c.add(BasePackFetchConnection.this.COMMON);
                }
                return !remoteKnowsIsCommon;
            }

            @Override
            public boolean requiresCommitBody() {
                return false;
            }
        });
    }

    private void markRefsAdvertised() {
        for (Ref r : this.getRefs()) {
            this.markAdvertised(r.getObjectId());
            if (r.getPeeledObjectId() == null) continue;
            this.markAdvertised(r.getPeeledObjectId());
        }
    }

    private void markAdvertised(AnyObjectId id) {
        try {
            this.walk.parseAny(id).add(this.ADVERTISED);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void markCommon(RevObject obj, PacketLineIn.AckNackResult anr) throws IOException {
        if (this.statelessRPC && anr == PacketLineIn.AckNackResult.ACK_COMMON && !obj.has(this.STATE)) {
            StringBuilder s = new StringBuilder(46);
            s.append("have ");
            s.append(obj.name());
            s.append('\n');
            this.pckState.writeString(s.toString());
            obj.add(this.STATE);
        }
        obj.add(this.COMMON);
        if (obj instanceof RevCommit) {
            ((RevCommit)obj).carry(this.COMMON);
        }
    }

    private void receivePack(ProgressMonitor monitor, OutputStream outputStream) throws IOException {
        this.onReceivePack();
        InputStream input = this.in;
        if (this.sideband) {
            input = new SideBandInputStream(input, monitor, this.getMessageWriter(), outputStream);
        }
        try (ObjectInserter ins = this.local.newObjectInserter();){
            PackParser parser = ins.newPackParser(input);
            parser.setAllowThin(this.thinPack);
            parser.setObjectChecker(this.transport.getObjectChecker());
            parser.setLockMessage(this.lockMessage);
            this.packLock = parser.parse(monitor);
            ins.flush();
        }
    }

    protected void onReceivePack() {
    }

    private static class CancelledException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private CancelledException() {
        }
    }

    static class FetchConfig {
        final boolean allowOfsDelta;
        final boolean minimalNegotiation;

        FetchConfig(Config c) {
            this.allowOfsDelta = c.getBoolean("repack", "usedeltabaseoffset", true);
            this.minimalNegotiation = c.getBoolean("fetch", "useminimalnegotiation", false);
        }

        FetchConfig(boolean allowOfsDelta, boolean minimalNegotiation) {
            this.allowOfsDelta = allowOfsDelta;
            this.minimalNegotiation = minimalNegotiation;
        }
    }
}

