/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildFileParsedData;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.actions.PhingRunTargetAction;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingActionIdUtils {
    @NonNls
    public static final String ACTION_ID_PREFIX = "Phing_";
    private static final Object LOCK = new Object();

    private PhingActionIdUtils() {
    }

    @NotNull
    public static String getActionIdPrefix(@Nullable Project project) {
        String string = project == null ? ACTION_ID_PREFIX : ACTION_ID_PREFIX + project.getLocationHash();
        if (string == null) {
            PhingActionIdUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static PhingBuildFile findBuildFileByActionId(String id, Project project) {
        PhingStateService service = PhingStateService.getInstance(project);
        for (PhingBuildFile buildFile : service.getBuildFiles()) {
            if (id.equals(PhingActionIdUtils.getDefaultTargetActionId(buildFile))) {
                return buildFile;
            }
            PhingBuildFileParsedData parsedData = service.getParsedData(buildFile);
            if (parsedData == null) continue;
            for (PhingBuildTarget target : parsedData.getTargets()) {
                if (!id.equals(PhingActionIdUtils.getActionId(target))) continue;
                return buildFile;
            }
        }
        return null;
    }

    @Nullable
    public static String getDefaultTargetActionId(PhingBuildFile buildFile) {
        VirtualFile baseDir = buildFile.getProject().getBaseDir();
        if (baseDir == null) {
            return null;
        }
        PhingStateService service = PhingStateService.getInstance(buildFile.getProject());
        PhingBuildFileParsedData data = service.getParsedData(buildFile);
        if (data == null) {
            return null;
        }
        boolean foundDefault = false;
        for (PhingBuildTarget target : data.getTargets()) {
            if (!target.isDefault()) continue;
            foundDefault = true;
            break;
        }
        if (!foundDefault) {
            return null;
        }
        return PhingActionIdUtils.getActionIdPrefix(buildFile.getProject()) + "_" + VfsUtilCore.getRelativePath((VirtualFile)buildFile.getFile(), (VirtualFile)baseDir, (char)'/') + "_";
    }

    @Nullable
    public static String getActionId(PhingBuildFile buildFile) {
        VirtualFile baseDir = buildFile.getProject().getBaseDir();
        if (baseDir == null) {
            return null;
        }
        return PhingActionIdUtils.getActionIdPrefix(buildFile.getProject()) + "_" + VfsUtilCore.getRelativePath((VirtualFile)buildFile.getFile(), (VirtualFile)baseDir, (char)'/');
    }

    @NotNull
    public static String getActionId(PhingBuildTarget target) {
        VirtualFile baseDir = target.getContextBuildFile().getProject().getBaseDir();
        assert (baseDir != null);
        String string = PhingActionIdUtils.getActionIdPrefix(target.getContextBuildFile().getProject()) + "_" + VfsUtilCore.getRelativePath((VirtualFile)target.getContextBuildFile().getFile(), (VirtualFile)baseDir, (char)'/') + '_' + target.getName();
        if (string == null) {
            PhingActionIdUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRegisteredActions(Project project) {
        if (project.isDisposed()) {
            return;
        }
        PhingStateService service = PhingStateService.getInstance(project);
        HashMap<String, PhingRunTargetAction> actionMap = new HashMap<String, PhingRunTargetAction>();
        for (PhingBuildFile buildFile : service.getBuildFiles()) {
            PhingBuildFileParsedData data;
            String defaultTargetActionId = PhingActionIdUtils.getDefaultTargetActionId(buildFile);
            if (defaultTargetActionId != null) {
                PhingRunTargetAction action = new PhingRunTargetAction(buildFile, PhingRunTargetAction.DEFAULT_TARGET_NAME, null, null);
                actionMap.put(defaultTargetActionId, action);
            }
            if ((data = service.getParsedData(buildFile)) == null) continue;
            for (PhingBuildTarget target : data.getTargets()) {
                if (target.isHiddenByAttribute() || buildFile.getTargetsToHide().contains(target.getName())) continue;
                PhingRunTargetAction action = new PhingRunTargetAction(buildFile, target.getName(), target.getName(), null);
                actionMap.put(PhingActionIdUtils.getActionId(target), action);
            }
        }
        Object object = LOCK;
        synchronized (object) {
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            String[] oldIds = actionManager.getActionIds(PhingActionIdUtils.getActionIdPrefix(project));
            for (String oldId : oldIds) {
                if (actionMap.remove(oldId) != null) continue;
                actionManager.unregisterAction(oldId);
            }
            for (Map.Entry entry : actionMap.entrySet()) {
                actionManager.registerAction((String)entry.getKey(), (AnAction)entry.getValue());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/phing/PhingActionIdUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIdPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

