/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericDomValue;
import com.jetbrains.php.phing.dom.PhingDomRecursiveVisitor;
import com.jetbrains.php.phing.dom.PhingDomReferenceBase;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedCustomElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingDomRefIdConverter
extends Converter<PhingPredefinedElement>
implements CustomReferenceConverter<PhingPredefinedElement> {
    public PhingPredefinedElement fromString(@Nullable @NonNls String s, ConvertContext context) {
        PhingPredefinedElement element;
        if (s != null && (element = PhingUtils.getInvocationBFDomElement(context)) != null) {
            return PhingDomRefIdConverter.findElementById(element.findPhingProject(), s);
        }
        return null;
    }

    public String toString(@Nullable PhingPredefinedElement bfDomElement, ConvertContext context) {
        GenericDomValue<String> id;
        if (bfDomElement != null && (id = bfDomElement.findId()) != null) {
            return id.getRawText();
        }
        return null;
    }

    @NotNull
    public PsiReference[] createReferences(final GenericDomValue<PhingPredefinedElement> genericDomValue, final PsiElement element, ConvertContext context) {
        final PhingPredefinedElement invocationElement = PhingUtils.getInvocationBFDomElement(context);
        PsiReference[] psiReferenceArray = new PsiReference[]{new PhingDomReferenceBase(element, true){

            public PsiElement resolve() {
                PhingPredefinedElement value = (PhingPredefinedElement)genericDomValue.getValue();
                if (value == null) {
                    return null;
                }
                DomTarget target = PhingUtils.getDomTarget(value, value.findId());
                if (target == null) {
                    return null;
                }
                return PomService.convertToPsi((Project)element.getProject(), (PomTarget)target);
            }

            @NotNull
            public Object[] getVariants() {
                if (invocationElement == null) {
                    if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                final LinkedHashSet variants = new LinkedHashSet();
                PhingPredefinedProject contextBFProject = invocationElement.findPhingProject();
                if (contextBFProject != null) {
                    contextBFProject.accept(new PhingDomRecursiveVisitor(){

                        @Override
                        public void visitPhingDomElement(PhingPredefinedElement element) {
                            String variant;
                            GenericDomValue<String> id = element.findId();
                            if (id != null && (variant = id.getRawText()) != null) {
                                variants.add(variant);
                            }
                            super.visitPhingDomElement(element);
                        }
                    });
                }
                Object[] objectArray = variants.size() > 0 ? ArrayUtil.toObjectArray(variants) : ArrayUtil.EMPTY_OBJECT_ARRAY;
                if (objectArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/PhingDomRefIdConverter$1", "getVariants"));
            }
        }};
        if (psiReferenceArray == null) {
            PhingDomRefIdConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    @Nullable
    private static PhingPredefinedElement findElementById(PhingPredefinedElement from, final String id) {
        GenericDomValue<String> fromId = from.findId();
        if (fromId != null && id.equals(fromId.getRawText())) {
            return from;
        }
        final Ref result = new Ref(null);
        from.accept(new PhingDomRecursiveVisitor(){

            @Override
            public void visitPhingDomCustomElement(PhingPredefinedCustomElement custom) {
            }

            @Override
            public void visitPhingDomElement(PhingPredefinedElement element) {
                if (result.get() != null || element instanceof PhingPredefinedCustomElement) {
                    return;
                }
                GenericDomValue<String> elementId = element.findId();
                if (elementId != null && id.equals(elementId.getRawText())) {
                    result.set((Object)element);
                    return;
                }
                super.visitPhingDomElement(element);
            }
        });
        return (PhingPredefinedElement)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/PhingDomRefIdConverter", "createReferences"));
    }
}

