/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MapSerializerUtil {
    private static final String STD_EX_SUFFIX = "Valid property list format is (name( )*=( )*'escaped_value'( )*)* where escape simbol is \"|\"";
    public static final EscapeInfoProvider STD_ESCAPER = new EscapeInfoProvider(){

        @Override
        public char escape(char c) {
            switch (c) {
                case '\n': {
                    return 'n';
                }
                case '\r': {
                    return 'r';
                }
                case '\u0085': {
                    return 'x';
                }
                case '\u2028': {
                    return 'l';
                }
                case '\u2029': {
                    return 'p';
                }
                case '|': {
                    return '|';
                }
                case '\'': {
                    return '\'';
                }
                case '[': {
                    return '[';
                }
                case ']': {
                    return ']';
                }
            }
            return '\u0000';
        }

        @Override
        public char unescape(char c) {
            switch (c) {
                case 'n': {
                    return '\n';
                }
                case 'r': {
                    return '\r';
                }
                case 'x': {
                    return '\u0085';
                }
                case 'l': {
                    return '\u2028';
                }
                case 'p': {
                    return '\u2029';
                }
                case '\'': {
                    return '\'';
                }
                case '|': {
                    return '|';
                }
                case '[': {
                    return '[';
                }
                case ']': {
                    return ']';
                }
            }
            return '\u0000';
        }

        @Override
        public char escapeCharacter() {
            return '|';
        }
    };

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider escaper) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil.stringToProperties must not be null");
        }
        if (escaper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil.stringToProperties must not be null");
        }
        Map<String, String> map = MapSerializerUtil.stringToProperties(string, escaper, true);
        if (map == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil.stringToProperties must not return null");
        }
        return map;
    }

    public static String propertiesToString(Map<String, String> props, EscapeInfoProvider escaper) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(MapSerializerUtil.escapeStr(entry.getKey(), escaper));
            builder.append('=');
            builder.append('\'').append(MapSerializerUtil.escapeStr(entry.getValue(), escaper)).append('\'');
        }
        return builder.toString();
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider escaper, boolean strictNameCheck) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil.stringToProperties must not be null");
        }
        if (escaper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil.stringToProperties must not be null");
        }
        String currentString = string;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while (currentString.length() > 0) {
            int nameSep = currentString.indexOf("=");
            if (nameSep == -1) {
                throw new ParseException("Property value not found\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape simbol is \"|\"", 0);
            }
            String name = currentString.substring(0, nameSep).trim();
            MapSerializerUtil.checkPropName(name, strictNameCheck);
            currentString = currentString.substring(nameSep + 1).trim();
            if (currentString.startsWith("'")) {
                int endOfValue = MapSerializerUtil.indexOf(currentString = currentString.substring(1), '\'', escaper);
                if (endOfValue >= 0) {
                    String escapedValue = currentString.substring(0, endOfValue);
                    currentString = currentString.substring(endOfValue + 1).trim();
                    result.put(name, MapSerializerUtil.unescapeStr(escapedValue, escaper));
                    continue;
                }
                throw new ParseException("Value should end with \"'\"\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape simbol is \"|\"", 0);
            }
            throw new ParseException("Value should start with \"'\"\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape simbol is \"|\"", 0);
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil.stringToProperties must not return null");
        }
        return linkedHashMap;
    }

    private static void checkPropName(String name, boolean strict) throws ParseException {
        boolean isCorrect;
        boolean bl = strict ? MapSerializerUtil.isValidJavaIdentifier(name) : (isCorrect = !MapSerializerUtil.hasSpaces(name));
        if (!isCorrect) {
            throw new ParseException("Incorrect property name.\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape simbol is \"|\"", 0);
        }
    }

    private static boolean hasSpaces(String name) {
        return name.indexOf(32) >= 0;
    }

    public static int indexOf(String currentString, char findWhat, EscapeInfoProvider escaper) {
        for (int i = 0; i < currentString.length(); ++i) {
            char currentChar = currentString.charAt(i);
            if (escaper.escapeCharacter() == currentChar) {
                ++i;
                continue;
            }
            if (currentChar != findWhat) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidJavaIdentifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil.isValidJavaIdentifier must not be null");
        }
        if (name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String escapeStr(String str, EscapeInfoProvider p) {
        if (str == null) {
            return null;
        }
        int finalCount = MapSerializerUtil.calcFinalEscapedStringCount(str, p);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            char escaped = p.escape(c);
            if (escaped != '\u0000') {
                resultChars[resultPos++] = p.escapeCharacter();
                resultChars[resultPos++] = escaped;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(String name, EscapeInfoProvider p) {
        int result = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (p.escape(c) != '\u0000') {
                result += 2;
                continue;
            }
            ++result;
        }
        return result;
    }

    public static String unescapeStr(String str, EscapeInfoProvider p) {
        if (str == null) {
            return null;
        }
        int finalCount = MapSerializerUtil.calcFinalUnescapedStringCount(str, p);
        int len = str.length();
        if (len == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < len; ++i) {
            char nextChar;
            char unescaped;
            char c = str.charAt(i);
            if (c == p.escapeCharacter() && i < len - 1 && (unescaped = p.unescape(nextChar = str.charAt(i + 1))) != '\u0000') {
                c = unescaped;
                ++i;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect unescaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalUnescapedStringCount(String name, EscapeInfoProvider p) {
        int result = 0;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char nextChar;
            char c = name.charAt(i);
            if (c == p.escapeCharacter() && i < len - 1 && p.unescape(nextChar = name.charAt(i + 1)) != '\u0000') {
                ++i;
            }
            ++result;
        }
        return result;
    }

    public static interface EscapeInfoProvider {
        public char escape(char var1);

        public char unescape(char var1);

        public char escapeCharacter();
    }
}

