/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.timeTracking;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitMessageProvider;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.timeTracking.SendTimeTrackingInformationDialog;
import com.intellij.tasks.timeTracking.TimeTrackingPlaceholderProvider;
import java.util.regex.Matcher;
import org.jetbrains.annotations.Nullable;

public class TaskCommitMessageProvider
implements CommitMessageProvider {
    @Nullable
    public String getCommitMessage(LocalChangeList forChangelist, Project project) {
        LocalTask task = TaskManager.getManager((Project)project).getAssociatedTask(forChangelist);
        if (task == null) {
            return null;
        }
        TaskRepository repository = task.getRepository();
        if (repository == null || !repository.isShouldFormatCommitMessage()) {
            return null;
        }
        String oldComment = forChangelist.getComment();
        String comment = TaskUtil.getChangeListComment((Task)task);
        if (oldComment == null) {
            return comment;
        }
        Matcher matcher = SendTimeTrackingInformationDialog.PATTERN.matcher(oldComment);
        if (!matcher.find()) {
            return null;
        }
        return matcher.replaceAll(new TimeTrackingPlaceholderProvider().getPlaceholderValue(task, "time"));
    }
}

