/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.TextMateServiceImpl;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;
import org.jetbrains.plugins.textmate.configuration.TextMateBundlesListPanel;
import org.jetbrains.plugins.textmate.configuration.TextMateErrorPanel;
import org.jetbrains.plugins.textmate.configuration.TextMateExtensionsIntersectionDialog;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;
import org.jetbrains.plugins.textmate.configuration.TextMateThemeMappingPanel;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.XmlPlistReader;

public class TextMateSettingsUI
implements ConfigurableUi<TextMateSettings>,
Disposable {
    private TextMateBundlesListPanel myBundlesListPanel;
    private TextMateThemeMappingPanel myThemeMappingPanel;
    private JPanel myExtensionsIntersectionsPanel;
    private JPanel myPanel;
    private JPanel myBundlesList;
    private JPanel myThemeMappingComponent;
    private Map<String, FileType> fileTypeConflicts;
    private Map<String, FileType> conflictsToResolve;

    public TextMateSettingsUI() {
        this.$$$setupUI$$$();
        this.fileTypeConflicts = ContainerUtil.newHashMap();
        this.conflictsToResolve = ContainerUtil.newHashMap();
    }

    public void apply(@NotNull TextMateSettings settings) {
        TextMateSettings.TextMateSettingsState state;
        if (settings == null) {
            TextMateSettingsUI.$$$reportNull$$$0(0);
        }
        if ((state = settings.getState()) == null) {
            state = new TextMateSettings.TextMateSettingsState();
        }
        settings.loadState(state);
        if (this.myThemeMappingPanel.isModified(state.getThemesMapping())) {
            this.myThemeMappingPanel.apply(state);
            EditorFactory.getInstance().refreshAllEditors();
        }
        if (!this.conflictsToResolve.isEmpty() || this.myBundlesListPanel.isModified(state.getBundles())) {
            final TextMateService textMateService = TextMateService.getInstance();
            state.setBundles(this.myBundlesListPanel.getState());
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Loading TextMate Bundles", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    TextMateSettingsUI.resolveFileTypeConflicts(TextMateSettingsUI.this.conflictsToResolve);
                    TextMateSettingsUI.this.conflictsToResolve.clear();
                    textMateService.unregisterAllBundles(false);
                    textMateService.reloadThemesFromDisk();
                    textMateService.registerEnabledBundles(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/textmate/configuration/TextMateSettingsUI$1", "run"));
                }
            });
        }
    }

    public void reset(@NotNull TextMateSettings settings) {
        if (settings == null) {
            TextMateSettingsUI.$$$reportNull$$$0(1);
        }
        this.myThemeMappingPanel.reset(settings);
        this.myBundlesListPanel.setState(settings.getBundles());
        this.fillFileTypeConflicts();
        this.showWarningIfNeeded();
    }

    public boolean isModified(@NotNull TextMateSettings settings) {
        TextMateSettings.TextMateSettingsState state;
        if (settings == null) {
            TextMateSettingsUI.$$$reportNull$$$0(2);
        }
        if ((state = settings.getState()) == null) {
            return !this.myBundlesListPanel.getState().isEmpty() || this.myThemeMappingPanel.isModified(this.myThemeMappingPanel.getDefaultThemesMapping(settings));
        }
        return this.conflictsToResolve.size() > 0 || this.myBundlesListPanel.isModified(state.getBundles()) || this.myThemeMappingPanel.isModified(state.getThemesMapping());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TextMateSettingsUI.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public void dispose() {
        this.myBundlesList = null;
        this.myThemeMappingComponent = null;
    }

    private TextMateErrorPanel createErrorPanel() {
        TextMateErrorPanel errorPanel = new TextMateErrorPanel("Some extensions declared in attached bundles are already used by native file types.", "Show details", new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                TextMateExtensionsIntersectionDialog dialog = new TextMateExtensionsIntersectionDialog(TextMateSettingsUI.this.myPanel, TextMateSettingsUI.this.fileTypeConflicts, TextMateSettingsUI.this.conflictsToResolve);
                if (dialog.showAndGet()) {
                    TextMateSettingsUI.this.conflictsToResolve = dialog.getConflictsToResolve();
                    TextMateSettingsUI.this.showWarningIfNeeded();
                }
            }
        });
        errorPanel.setVisible(false);
        return errorPanel;
    }

    private void showWarningIfNeeded() {
        if (!this.fileTypeConflicts.isEmpty() && !this.fileTypeConflicts.equals(this.conflictsToResolve)) {
            this.myExtensionsIntersectionsPanel.setVisible(true);
        } else {
            this.myExtensionsIntersectionsPanel.setVisible(false);
        }
        this.myExtensionsIntersectionsPanel.revalidate();
        this.myExtensionsIntersectionsPanel.repaint();
    }

    private static String[] retrieveAllSchemeNames() {
        return (String[])ContainerUtil.map2Array((Object[])EditorColorsManager.getInstance().getAllSchemes(), String.class, s -> SchemeManager.getDisplayName((Scheme)s));
    }

    private void fillFileTypeConflicts() {
        HashMap conflicts = ContainerUtil.newHashMap();
        for (BundleConfigBean bean : this.myBundlesListPanel.getState()) {
            Bundle bundle;
            VirtualFile bundleDirectory;
            if (!bean.isEnabled() || (bundleDirectory = LocalFileSystem.getInstance().findFileByPath(bean.getPath())) == null || (bundle = TextMateService.getInstance().createBundle(bundleDirectory)) == null) continue;
            XmlPlistReader plistReader = TextMateService.getInstance().getPlistReader();
            for (File file : bundle.getGrammarFiles()) {
                try {
                    Plist plist = plistReader.read(file);
                    List<String> extensions = plist.getPlistValue("fileTypes", Collections.emptyList()).getStringArray();
                    for (String extension : extensions) {
                        FileType fileType = TextMateSettingsUI.getAlreadyRegisteredFileType(extension);
                        if (fileType == null) continue;
                        conflicts.put(extension, fileType);
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        this.fileTypeConflicts = conflicts;
        this.conflictsToResolve = ContainerUtil.newHashMap((Map)ContainerUtil.intersection((Map)conflicts, this.conflictsToResolve));
    }

    private static void resolveFileTypeConflicts(Map<String, FileType> conflictsToResolve) {
        for (Map.Entry<String, FileType> entry : conflictsToResolve.entrySet()) {
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                FileTypeManager.getInstance().removeAssociatedExtension((FileType)entry.getValue(), (String)entry.getKey());
                ExactFileNameMatcher matcher = new ExactFileNameMatcher((String)entry.getKey(), false);
                FileTypeManager.getInstance().removeAssociation((FileType)entry.getValue(), (FileNameMatcher)matcher);
                matcher = new ExactFileNameMatcher((String)entry.getKey(), true);
                FileTypeManager.getInstance().removeAssociation((FileType)entry.getValue(), (FileNameMatcher)matcher);
            }));
        }
    }

    private static FileType getAlreadyRegisteredFileType(String extension) {
        FileType result = FileTypeManager.getInstance().getFileTypeByExtension(extension);
        if (TextMateServiceImpl.isTypeShouldBeReplacedByTextMateType(result)) {
            result = FileTypeManager.getInstance().getFileTypeByFileName(extension);
            return TextMateServiceImpl.isTypeShouldBeReplacedByTextMateType(result) ? null : result;
        }
        return result;
    }

    private void createUIComponents() {
        this.myExtensionsIntersectionsPanel = this.createErrorPanel();
        this.myBundlesListPanel = new TextMateBundlesListPanel();
        this.myBundlesList = this.myBundlesListPanel.createMainComponent();
        this.myThemeMappingPanel = new TextMateThemeMappingPanel(TextMateService.getInstance().getThemeNames(), TextMateSettingsUI.retrieveAllSchemeNames());
        this.myThemeMappingComponent = this.myThemeMappingPanel.getMainComponent();
        this.myBundlesListPanel.addChangeStateListener(new TextMateBundlesListPanel.TextMateBundlesChangeStateListener(){

            @Override
            public void stateChanged() {
                TextMateSettingsUI.this.fillFileTypeConflicts();
                TextMateSettingsUI.this.showWarningIfNeeded();
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myThemeMappingPanel);
        Disposer.register((Disposable)this, (Disposable)this.myBundlesListPanel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/configuration/TextMateSettingsUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/configuration/TextMateSettingsUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = this.myBundlesList;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = this.myExtensionsIntersectionsPanel;
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = this.myThemeMappingComponent;
        jPanel.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

