/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.problems;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.TaskRunnerImpl;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.problems.FwOutputSettings;
import com.intellij.plugins.watcher.problems.TaskProblemDescription;
import com.intellij.tools.FilterInfo;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskProblemFinder {
    @NonNls
    public static final String FILE_PATH_MACROS = "$FILE_PATH$";
    @NonNls
    public static final String LINE_MACROS = "$LINE$";
    @NonNls
    public static final String COLUMN_MACROS = "$COLUMN$";
    @NonNls
    public static final String MESSAGE_MACROS = "$MESSAGE$";
    @NonNls
    public static final String WIN_FILE_PATH_REGEXP = "((?:\\p{Alpha}\\:)?[0-9 a-z_A-Z()\\-\\\\./]+)";
    @NonNls
    public static final String FILE_PATH_REGEXP = "([0-9a-z_A-Z\\-\\\\./]+)";
    @NonNls
    public static final String MESSAGE_REGEXP = "(.*?)";
    public static final String NUMBER_REGEXP = "(\\d++)";
    private final int myFileRegister;
    private final int myLineRegister;
    private final int myColumnRegister;
    private final int myMessageRegister;
    @NonNls
    private static final String FILE_STR = "file";
    @NonNls
    private static final String LINE_STR = "line";
    @NonNls
    private static final String COLUMN_STR = "column";
    @NonNls
    private static final String MESSAGE_STR = "message";
    private final Pattern myPattern;
    private final FwOutputSettings myOutputSettings;

    public TaskProblemFinder(@NotNull String expression, @NotNull FwOutputSettings outputSettings) {
        if (expression == null) {
            TaskProblemFinder.$$$reportNull$$$0(0);
        }
        if (outputSettings == null) {
            TaskProblemFinder.$$$reportNull$$$0(1);
        }
        this(expression, outputSettings, SystemInfo.isWindows);
    }

    public TaskProblemFinder(@NotNull String expression, @NotNull FwOutputSettings outputSettings, boolean isWindows) {
        if (expression == null) {
            TaskProblemFinder.$$$reportNull$$$0(2);
        }
        if (outputSettings == null) {
            TaskProblemFinder.$$$reportNull$$$0(3);
        }
        this.myOutputSettings = outputSettings;
        int filePathIndex = expression.indexOf(FILE_PATH_MACROS);
        int lineIndex = expression.indexOf(LINE_MACROS);
        int columnIndex = expression.indexOf(COLUMN_MACROS);
        int messageIndex = expression.indexOf(MESSAGE_MACROS);
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        if (filePathIndex != -1) {
            String filePathRegexp = isWindows ? WIN_FILE_PATH_REGEXP : FILE_PATH_REGEXP;
            expression = StringUtil.replace((String)expression, (String)FILE_PATH_MACROS, (String)filePathRegexp);
            map.put(new Integer(filePathIndex), FILE_STR);
        }
        if (lineIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)LINE_MACROS, (String)NUMBER_REGEXP);
            map.put(new Integer(lineIndex), LINE_STR);
        }
        if (columnIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)COLUMN_MACROS, (String)NUMBER_REGEXP);
            map.put(new Integer(columnIndex), COLUMN_STR);
        }
        if (messageIndex != -1) {
            expression = StringUtil.replace((String)expression, (String)MESSAGE_MACROS, (String)MESSAGE_REGEXP);
            map.put(new Integer(messageIndex), MESSAGE_STR);
        }
        int count = 0;
        for (Integer integer : map.keySet()) {
            ++count;
            String s = (String)map.get(integer);
            if (FILE_STR.equals(s)) {
                filePathIndex = count;
                continue;
            }
            if (LINE_STR.equals(s)) {
                lineIndex = count;
                continue;
            }
            if (COLUMN_STR.equals(s)) {
                columnIndex = count;
                continue;
            }
            if (!MESSAGE_STR.equals(s)) continue;
            messageIndex = count;
        }
        this.myFileRegister = filePathIndex;
        this.myLineRegister = lineIndex;
        this.myColumnRegister = columnIndex;
        this.myMessageRegister = messageIndex;
        if (messageIndex == 1 && !expression.startsWith("^")) {
            expression = "^" + expression;
        }
        if (messageIndex == count && !expression.endsWith("$")) {
            expression = expression + "$";
        }
        this.myPattern = Pattern.compile(expression);
    }

    public static List<TaskProblemDescription> findProblems(@NotNull List<String> lines, @NotNull TaskOptions taskOptions) {
        if (lines == null) {
            TaskProblemFinder.$$$reportNull$$$0(4);
        }
        if (taskOptions == null) {
            TaskProblemFinder.$$$reportNull$$$0(5);
        }
        return TaskProblemFinder.findProblems(lines, taskOptions.getOutputFilters(), taskOptions.getOutputSettings(), SystemInfo.isWindows);
    }

    public static List<TaskProblemDescription> findProblems(@NotNull List<String> lines, @NotNull FilterInfo[] filters, @NotNull FwOutputSettings outputSettings, boolean isWindows) {
        if (lines == null) {
            TaskProblemFinder.$$$reportNull$$$0(6);
        }
        if (filters == null) {
            TaskProblemFinder.$$$reportNull$$$0(7);
        }
        if (outputSettings == null) {
            TaskProblemFinder.$$$reportNull$$$0(8);
        }
        ArrayList<TaskProblemDescription> result = new ArrayList<TaskProblemDescription>();
        TaskProblemFinder[] finders = new TaskProblemFinder[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            finders[i] = new TaskProblemFinder(filters[i].getRegExp(), outputSettings, isWindows);
        }
        ListIterator<String> lineIterator = lines.listIterator();
        block1: while (lineIterator.hasNext()) {
            String current = lineIterator.next();
            for (TaskProblemFinder finder : finders) {
                TaskProblemDescription initialDescription = finder.find(current);
                if (initialDescription == null) continue;
                if (outputSettings.isMultilineMessage()) {
                    result.add(TaskProblemFinder.createMultilineDescription(lineIterator, initialDescription));
                    continue block1;
                }
                result.add(initialDescription);
                continue block1;
            }
        }
        return result;
    }

    @NotNull
    private static TaskProblemDescription createMultilineDescription(@NotNull ListIterator<String> lineIterator, @NotNull TaskProblemDescription description) {
        if (lineIterator == null) {
            TaskProblemFinder.$$$reportNull$$$0(9);
        }
        if (description == null) {
            TaskProblemFinder.$$$reportNull$$$0(10);
        }
        if (description.getMessage() == null) {
            TaskProblemDescription taskProblemDescription = description;
            if (taskProblemDescription == null) {
                TaskProblemFinder.$$$reportNull$$$0(11);
            }
            return taskProblemDescription;
        }
        StringBuilder wholeMessage = new StringBuilder(description.getMessage());
        while (lineIterator.hasNext()) {
            String current = lineIterator.next();
            if (current.startsWith("  ") && !StringUtil.isEmptyOrSpaces((String)current)) {
                wholeMessage.append("\n").append(current);
                continue;
            }
            lineIterator.previous();
            break;
        }
        TaskProblemDescription taskProblemDescription = new TaskProblemDescription(description.getPath(), description.getLine(), description.getColumn(), wholeMessage.toString());
        if (taskProblemDescription == null) {
            TaskProblemFinder.$$$reportNull$$$0(12);
        }
        return taskProblemDescription;
    }

    @Nullable
    public TaskProblemDescription find(String line) {
        if (line == null || line.length() > 10000) {
            return null;
        }
        Matcher matcher = this.myPattern.matcher(line);
        if (matcher.find()) {
            return this.createResult(matcher);
        }
        return null;
    }

    private TaskProblemDescription createResult(Matcher matcher) {
        Integer column = TaskProblemFinder.parseInt(TaskProblemFinder.getGroup(matcher, this.myColumnRegister));
        String filePath = TaskProblemFinder.getGroup(matcher, this.myFileRegister);
        Integer line = TaskProblemFinder.parseInt(TaskProblemFinder.getGroup(matcher, this.myLineRegister));
        String message = TaskProblemFinder.getGroup(matcher, this.myMessageRegister);
        return new TaskProblemDescription(filePath, line == null ? null : Integer.valueOf(this.myOutputSettings.zeroBaseLine(line)), column == null ? null : Integer.valueOf(this.myOutputSettings.zeroBasedColumn(column)), message);
    }

    private static Integer parseInt(@Nullable String value) {
        try {
            return value == null ? null : Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    private static String getGroup(Matcher matcher, int index) {
        if (0 < index && index <= matcher.groupCount()) {
            return matcher.group(index);
        }
        return null;
    }

    public Filter getFilter(final @NotNull Project project, final @Nullable VirtualFile workingDir, final @NotNull VirtualFile currentFile) {
        if (project == null) {
            TaskProblemFinder.$$$reportNull$$$0(13);
        }
        if (currentFile == null) {
            TaskProblemFinder.$$$reportNull$$$0(14);
        }
        return new Filter(){

            @Nullable
            public Filter.Result applyFilter(String line, int entireLength) {
                try {
                    Matcher matcher = TaskProblemFinder.this.myPattern.matcher(line);
                    if (matcher.find()) {
                        TaskProblemDescription description = TaskProblemFinder.this.createResult(matcher);
                        return this.createFilterResult(line, matcher, description, entireLength);
                    }
                }
                catch (ProcessCanceledException e) {
                    return null;
                }
                return null;
            }

            private Filter.Result createFilterResult(String line, Matcher matcher, TaskProblemDescription description, int entireLength) {
                HyperlinkInfo hyperlink = this.createOpenFileHyperlink(description);
                if (hyperlink == null) {
                    return null;
                }
                if (TaskProblemFinder.this.myFileRegister <= 0) {
                    return null;
                }
                String pathInLine = matcher.group(TaskProblemFinder.this.myFileRegister);
                if (pathInLine == null) {
                    return null;
                }
                int offset = entireLength - line.length();
                int start = offset + line.indexOf(pathInLine);
                return new Filter.Result(start, start + pathInLine.length(), hyperlink);
            }

            @Nullable
            private HyperlinkInfo createOpenFileHyperlink(TaskProblemDescription description) {
                VirtualFile file = TaskRunnerImpl.findFile(description, workingDir, currentFile);
                if (file == null) {
                    return null;
                }
                int line = (Integer)ObjectUtils.notNull((Object)description.getLine(), (Object)0);
                int column = (Integer)ObjectUtils.notNull((Object)description.getColumn(), (Object)0);
                return new OpenFileHyperlinkInfo(project, file, line, column);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputSettings";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskOptions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineIterator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/problems/TaskProblemFinder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/problems/TaskProblemFinder";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultilineDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findProblems";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createMultilineDescription";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

