/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.NameEnumerator;
import com.intellij.rt.coverage.data.TestDiscoveryDataListener;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TIntIntHashMap;
import org.jetbrains.coverage.gnu.trove.TIntIntIterator;

public abstract class TestDiscoveryProtocolDataListener
implements TestDiscoveryDataListener {
    public static final int START_MARKER = 1;
    public static final int FINISH_MARKER = 0;
    public static final int NAMES_DICTIONARY_PART_MARKER = 2;
    public static final int TEST_FINISHED_MARKER = 3;
    public static final int METADATA_MARKER = 5;
    public static final int CLASS_METADATA_MARKER = 6;
    protected final byte myVersion;

    public TestDiscoveryProtocolDataListener(byte version) {
        this.myVersion = version;
    }

    protected void writeTestFinished(DataOutput output, String className, String methodName, Map<Integer, boolean[]> classToVisitedMethods, Map<Integer, int[]> classToMethodNames, List<int[]> openedFiles) throws IOException {
        NameEnumerator.Incremental nameEnumerator = this.getNameEnumerator();
        int testClassNameId = nameEnumerator.enumerate(className);
        int testMethodNameId = nameEnumerator.enumerate(methodName);
        this.writeDictionaryIncrementIfNeeded(output);
        output.writeByte(3);
        CoverageIOUtil.writeINT(output, testClassNameId);
        CoverageIOUtil.writeINT(output, testMethodNameId);
        this.writeVisitedMethod(classToVisitedMethods, classToMethodNames, output);
        this.writeAffectedFiles(output, openedFiles);
    }

    private void writeAffectedFiles(DataOutput output, List<int[]> files) throws IOException {
        if (this.myVersion < 3) {
            return;
        }
        CoverageIOUtil.writeINT(output, files.size());
        for (int[] file : files) {
            CoverageIOUtil.writeINT(output, file.length);
            for (int i : file) {
                CoverageIOUtil.writeINT(output, i);
            }
        }
    }

    protected void start(DataOutput output) throws IOException {
        output.writeByte(1);
        output.writeByte(this.myVersion);
    }

    protected void finish(DataOutput output) throws IOException {
        output.writeByte(0);
    }

    @Override
    public abstract NameEnumerator.Incremental getNameEnumerator();

    protected void writeDictionaryIncrementIfNeeded(DataOutput output) throws IOException {
        List<NameEnumerator.Incremental.NameAndId> increment = this.getNameEnumerator().getAndClearDataIncrement();
        if (increment.isEmpty()) {
            return;
        }
        output.writeByte(2);
        this.writeEnumeratorIncrement(output, increment);
    }

    protected void writeEnumeratorIncrement(DataOutput output, List<NameEnumerator.Incremental.NameAndId> increment) throws IOException {
        CoverageIOUtil.writeINT(output, increment.size());
        for (NameEnumerator.Incremental.NameAndId nameAndId : increment) {
            CoverageIOUtil.writeINT(output, nameAndId.getId());
            CoverageIOUtil.writeUTF(output, nameAndId.getName());
        }
    }

    protected void writeVisitedMethod(Map<Integer, boolean[]> classToVisitedMethods, Map<Integer, int[]> classToMethodNames, DataOutput os) throws IOException {
        int usedMethodsCount;
        TIntIntHashMap classToUsedMethods = new TIntIntHashMap();
        for (Map.Entry<Integer, boolean[]> o : classToVisitedMethods.entrySet()) {
            boolean[] used = o.getValue();
            usedMethodsCount = 0;
            for (boolean anUsed : used) {
                if (!anUsed) continue;
                ++usedMethodsCount;
            }
            if (usedMethodsCount <= 0) continue;
            classToUsedMethods.put(o.getKey(), usedMethodsCount);
        }
        int size = classToUsedMethods.size();
        CoverageIOUtil.writeINT(os, size);
        if (size == 0) {
            return;
        }
        TIntIntIterator iterator = classToUsedMethods.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int className = iterator.key();
            usedMethodsCount = iterator.value();
            CoverageIOUtil.writeINT(os, className);
            CoverageIOUtil.writeINT(os, usedMethodsCount);
            int[] methodNames = classToMethodNames.get(className);
            boolean[] used = classToVisitedMethods.get(className);
            int len = used.length;
            for (int i = 0; i < len; ++i) {
                if (!used[i] || usedMethodsCount-- <= 0) continue;
                CoverageIOUtil.writeINT(os, methodNames[i]);
            }
        }
    }

    protected void writeMetadata(DataOutput os, Map<String, String> metadata) throws IOException {
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(metadata);
        os.writeByte(5);
        CoverageIOUtil.writeINT(os, map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CoverageIOUtil.writeUTF(os, entry.getKey());
            CoverageIOUtil.writeUTF(os, entry.getValue());
        }
    }

    protected void writeClassMetadata(DataOutput os, List<ClassMetadata> metadata) throws IOException {
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        if (this.myVersion < 2) {
            return;
        }
        NameEnumerator.Incremental enumerator = this.getNameEnumerator();
        for (ClassMetadata data : metadata) {
            enumerator.enumerate(data.getFqn());
            if (data.getFiles() != null) {
                for (String file : data.getFiles()) {
                    enumerator.enumerate(file);
                }
            }
            if (data.getMethods() == null) continue;
            for (String method : data.getMethods().keySet()) {
                enumerator.enumerate(method);
            }
        }
        this.writeDictionaryIncrementIfNeeded(os);
        ArrayList<ClassMetadata> list = new ArrayList<ClassMetadata>(metadata);
        os.writeByte(6);
        CoverageIOUtil.writeINT(os, list.size());
        for (ClassMetadata data : list) {
            CoverageIOUtil.writeINT(os, enumerator.enumerate(data.getFqn()));
            List<String> files = data.getFiles();
            if (files == null) {
                CoverageIOUtil.writeINT(os, 0);
            } else {
                CoverageIOUtil.writeINT(os, files.size());
                for (String file : files) {
                    CoverageIOUtil.writeINT(os, enumerator.enumerate(file));
                }
            }
            Map<String, byte[]> methods = data.getMethods();
            if (methods == null) {
                CoverageIOUtil.writeINT(os, 0);
                continue;
            }
            CoverageIOUtil.writeINT(os, methods.size());
            for (Map.Entry<String, byte[]> method : methods.entrySet()) {
                CoverageIOUtil.writeINT(os, enumerator.enumerate(method.getKey()));
                CoverageIOUtil.writeINT(os, method.getValue().length);
                os.write(method.getValue());
            }
        }
    }
}

