/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.comment;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSChangeToEndOfLineCommentIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        CStyleCommentPredicate cStyleCommentPredicate = new CStyleCommentPredicate();
        if (cStyleCommentPredicate == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(0);
        }
        return cStyleCommentPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSChangeToEndOfLineCommentIntention.$$$reportNull$$$0(1);
        }
        PsiElement parent = element.getParent();
        assert (parent != null);
        String commentText = element.getText();
        PsiElement whitespace = element.getNextSibling();
        String text = commentText.substring(2, commentText.length() - 2);
        String[] lines = text.split("\n");
        String[] newComments = JSChangeToEndOfLineCommentIntention.buildCommentStrings(lines);
        PsiElement currentElement = element;
        int index = newComments.length;
        while (--index >= 0) {
            if (newComments[index].length() <= 0) continue;
            currentElement = JSElementFactory.addElementBefore(currentElement, "\n");
            currentElement = JSElementFactory.addElementBefore(currentElement, newComments[index]);
        }
        if (whitespace != null) {
            com.intellij.lang.javascript.psi.JSElementFactory.removeElement((PsiElement)whitespace);
        }
        com.intellij.lang.javascript.psi.JSElementFactory.removeElement((PsiElement)element);
    }

    private static String[] buildCommentStrings(String[] lines) {
        int lastNonEmtpyLine = -1;
        for (int i = lines.length - 1; i >= 0 && lastNonEmtpyLine == -1; --i) {
            String line = lines[i].trim();
            if (line.length() == 0) continue;
            lastNonEmtpyLine = i;
        }
        if (lastNonEmtpyLine == -1) {
            return new String[]{"//"};
        }
        StringBuilder buffer = new StringBuilder();
        String[] commentStrings = new String[lastNonEmtpyLine + 1];
        for (int i = 0; i <= lastNonEmtpyLine; ++i) {
            String line = lines[i];
            if (line.trim().length() != 0) {
                buffer.replace(0, buffer.length(), "//");
                if (line.startsWith(" *")) {
                    buffer.append(line.substring(2));
                } else if (line.startsWith("*")) {
                    buffer.append(line.substring(1));
                } else {
                    buffer.append(line);
                }
            }
            commentStrings[i] = buffer.toString();
        }
        return commentStrings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/comment/JSChangeToEndOfLineCommentIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/comment/JSChangeToEndOfLineCommentIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CStyleCommentPredicate
    implements JSElementPredicate {
        private CStyleCommentPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                CStyleCommentPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiComment)) {
                return false;
            }
            PsiComment comment = (PsiComment)element;
            IElementType type = comment.getTokenType();
            if (!JSTokenTypes.C_STYLE_COMMENT.equals(type)) {
                return false;
            }
            PsiElement sibling = PsiTreeUtil.nextLeaf((PsiElement)comment);
            if (!(sibling instanceof PsiWhiteSpace)) {
                return false;
            }
            String whitespaceText = sibling.getText();
            return whitespaceText.indexOf(10) >= 0 || whitespaceText.indexOf(13) >= 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToEndOfLineCommentIntention$CStyleCommentPredicate", "satisfiedBy"));
        }
    }
}

