/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.refactoring;

import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueFileType;
import org.jetbrains.vuejs.index.VueComponentsIndex;
import org.jetbrains.vuejs.index.VueIndexKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/vuejs/refactoring/VueRefactoringUtils;", "", "()V", "getComponent", "Lcom/intellij/lang/javascript/psi/stubs/JSImplicitElement;", "element", "Lcom/intellij/psi/PsiElement;", "isComponentName", "", "intellij.vuejs"})
public final class VueRefactoringUtils {
    public static final VueRefactoringUtils INSTANCE;

    @Nullable
    public final JSImplicitElement getComponent(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof JSImplicitElementImpl) {
            String string = ((JSImplicitElementImpl)element).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.name");
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)((JSImplicitElementImpl)element).getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(element.project)");
            Collection<JSImplicitElement> collection = VueIndexKt.resolve(string, globalSearchScope, VueComponentsIndex.Companion.getKEY());
            return collection != null ? (JSImplicitElement)CollectionsKt.first((Iterable)collection) : null;
        }
        return null;
    }

    public final boolean isComponentName(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element.getContainingFile() == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
        if (Intrinsics.areEqual((Object)psiFile.getFileType(), (Object)((Object)VueFileType.Companion.getINSTANCE())) ^ true) {
            return false;
        }
        PsiElement psiElement = element.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element.parent");
        PsiElement psiElement2 = psiElement.getParent();
        if (!(psiElement2 instanceof JSPropertyImpl)) {
            psiElement2 = null;
        }
        JSPropertyImpl jSPropertyImpl = (JSPropertyImpl)psiElement2;
        return Intrinsics.areEqual((Object)(jSPropertyImpl != null ? jSPropertyImpl.getName() : null), (Object)"name");
    }

    private VueRefactoringUtils() {
    }

    static {
        VueRefactoringUtils vueRefactoringUtils;
        INSTANCE = vueRefactoringUtils = new VueRefactoringUtils();
    }
}

