/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.inspections.DockerFileInspectorBase;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileAnyValue;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileArgDeclaration;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileEnvRegularDeclaration;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileLabelCommand;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileLabelDef;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileRegularValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DockerFileAssignmentsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DockerFileAssignmentsInspection.$$$reportNull$$$0(0);
        }
        if (holder.getFile() instanceof DockerPsiFile) {
            AssignmentsInspector assignmentsInspector = new AssignmentsInspector(holder, isOnTheFly);
            if (assignmentsInspector == null) {
                DockerFileAssignmentsInspection.$$$reportNull$$$0(1);
            }
            return assignmentsInspector;
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            DockerFileAssignmentsInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/dockerFile/inspections/DockerFileAssignmentsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileAssignmentsInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AssignmentsInspector
    extends DockerFileInspectorBase {
        AssignmentsInspector(@NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
            if (problemsHolder == null) {
                AssignmentsInspector.$$$reportNull$$$0(0);
            }
            super(problemsHolder, isOnTheFly);
        }

        @Override
        public void visitArgDeclaration(@NotNull DockerFileArgDeclaration argDeclaration) {
            DockerFileAnyValue optionalValue;
            if (argDeclaration == null) {
                AssignmentsInspector.$$$reportNull$$$0(1);
            }
            if ((optionalValue = argDeclaration.getAnyValue()) == null) {
                return;
            }
            List<PsiWhiteSpace> rightSideSpaces = AssignmentsInspector.collectSpacesBefore((PsiElement)optionalValue);
            List<PsiWhiteSpace> leftSideSpaces = AssignmentsInspector.collectSpacesAfter(argDeclaration.getDeclaredName());
            if (rightSideSpaces.isEmpty() || leftSideSpaces.isEmpty()) {
                this.requireNoSpaces(leftSideSpaces);
                this.requireNoSpaces(rightSideSpaces);
            } else {
                ArrayList<PsiWhiteSpace> all = new ArrayList<PsiWhiteSpace>();
                all.addAll(leftSideSpaces);
                all.addAll(rightSideSpaces);
                this.requireNoSpaces(all);
            }
        }

        @Override
        public void visitEnvRegularDeclaration(@NotNull DockerFileEnvRegularDeclaration declaration) {
            DockerFileRegularValue value;
            if (declaration == null) {
                AssignmentsInspector.$$$reportNull$$$0(2);
            }
            if ((value = declaration.getRegularValue()) == null) {
                return;
            }
            List<PsiWhiteSpace> leftSideSpaces = AssignmentsInspector.collectSpacesAfter(declaration.getDeclaredName());
            List<PsiWhiteSpace> rightSideSpaces = AssignmentsInspector.collectSpacesBefore((PsiElement)value);
            if (leftSideSpaces.isEmpty()) {
                this.requireNoSpaces(rightSideSpaces);
            }
        }

        @Override
        public void visitLabelDef(@NotNull DockerFileLabelDef labelDef) {
            if (labelDef == null) {
                AssignmentsInspector.$$$reportNull$$$0(3);
            }
            if (!AssignmentsInspector.isFirstDefInCommand(labelDef)) {
                return;
            }
            List<PsiWhiteSpace> leftSideSpaces = AssignmentsInspector.collectSpacesBefore(labelDef.getAssign());
            List<PsiWhiteSpace> rightSideSpaces = AssignmentsInspector.collectSpacesAfter(labelDef.getAssign());
            if (leftSideSpaces.isEmpty()) {
                this.requireNoSpaces(rightSideSpaces);
            }
        }

        private static boolean isFirstDefInCommand(@NotNull DockerFileLabelDef labelDef) {
            DockerFileLabelCommand command;
            if (labelDef == null) {
                AssignmentsInspector.$$$reportNull$$$0(4);
            }
            return (command = (DockerFileLabelCommand)PsiTreeUtil.getParentOfType((PsiElement)labelDef, DockerFileLabelCommand.class)) != null && command.getLabelDefList().indexOf(labelDef) == 0;
        }

        private void requireNoSpaces(@NotNull List<PsiWhiteSpace> spaces) {
            if (spaces == null) {
                AssignmentsInspector.$$$reportNull$$$0(5);
            }
            if (spaces.stream().anyMatch(ws -> ws.getTextLength() > 0)) {
                this.registerProblem(spaces, DockerBundle.getText((String)"DockerFileAssignmentsInspection.error.spacing.not.allowed", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }

        @NotNull
        private static List<PsiWhiteSpace> collectSpacesAfter(@NotNull PsiElement anchor) {
            if (anchor == null) {
                AssignmentsInspector.$$$reportNull$$$0(6);
            }
            SmartList result = new SmartList();
            PsiElement next = anchor.getNextSibling();
            while (next instanceof PsiWhiteSpace) {
                result.add((Object)((PsiWhiteSpace)next));
                next = next.getNextSibling();
            }
            SmartList smartList = result;
            if (smartList == null) {
                AssignmentsInspector.$$$reportNull$$$0(7);
            }
            return smartList;
        }

        @NotNull
        private static List<PsiWhiteSpace> collectSpacesBefore(PsiElement anchor) {
            SmartList result = new SmartList();
            PsiElement next = anchor.getPrevSibling();
            while (next instanceof PsiWhiteSpace) {
                result.add(0, (Object)((PsiWhiteSpace)next));
                next = next.getPrevSibling();
            }
            SmartList smartList = result;
            if (smartList == null) {
                AssignmentsInspector.$$$reportNull$$$0(8);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argDeclaration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "labelDef";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spaces";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/dockerFile/inspections/DockerFileAssignmentsInspection$AssignmentsInspector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/dockerFile/inspections/DockerFileAssignmentsInspection$AssignmentsInspector";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSpacesAfter";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSpacesBefore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitArgDeclaration";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitEnvRegularDeclaration";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLabelDef";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isFirstDefInCommand";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "requireNoSpaces";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSpacesAfter";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

