/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermImpl;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFunctionImpl
extends CssElementImpl
implements CssFunction {
    private static final Map<String, CssTermType> typeOfStringMap = ContainerUtil.newHashMap((Pair)Pair.create((Object)"%", (Object)CssTermTypes.PERCENTAGE), (Pair[])new Pair[]{Pair.create((Object)"string", (Object)CssTermTypes.STRING), Pair.create((Object)"number", (Object)CssTermTypes.NUMBER), Pair.create((Object)"integer", (Object)CssTermTypes.INTEGER), Pair.create((Object)"length", (Object)CssTermTypes.LENGTH), Pair.create((Object)"angle", (Object)CssTermTypes.ANGLE), Pair.create((Object)"time", (Object)CssTermTypes.TIME), Pair.create((Object)"frequency", (Object)CssTermTypes.FREQUENCY), Pair.create((Object)"color", (Object)CssTermTypes.COLOR), Pair.create((Object)"url", (Object)CssTermTypes.URI)});

    CssFunctionImpl() {
        super(CssElementTypes.CSS_FUNCTION);
    }

    @NotNull
    public String getName() {
        PsiElement namedElement = this.getNameIdentifier();
        String string = namedElement != null ? namedElement.getText() : "";
        if (string == null) {
            CssFunctionImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement token;
        if (name == null) {
            CssFunctionImpl.$$$reportNull$$$0(1);
        }
        if ((token = this.getNameIdentifier()) != null) {
            CssPsiUtil.replaceToken((PsiElement)token, (String)name);
        }
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getToken(CssElementTypes.CSS_FUNCTION_TOKEN);
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (psiReferenceArray == null) {
            CssFunctionImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssFunctionImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssFunction((CssFunction)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public Collection<? extends CssFunctionDescriptor> getDescriptors() {
        Collection<? extends CssFunctionDescriptor> collection = this.getDescriptors((PsiElement)this);
        if (collection == null) {
            CssFunctionImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssFunctionDescriptor> getDescriptors(@NotNull PsiElement context) {
        if (context == null) {
            CssFunctionImpl.$$$reportNull$$$0(5);
        }
        Collection collection = CssDescriptorsUtil.getFunctionDescriptors((String)this.getName(), (PsiElement)context);
        if (collection == null) {
            CssFunctionImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Nullable
    public CssTermList getValue() {
        return this.getChildOfType(CssTermList.class);
    }

    @NotNull
    public TextRange getTrimmedValueTextRange() {
        PsiElement lParenthesis = this.getLParenthesis();
        CssTermList termList = this.getValue();
        if (termList != null) {
            TextRange textRange = termList.getTextRange();
            if (textRange == null) {
                CssFunctionImpl.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        int startOffset = lParenthesis != null ? lParenthesis.getTextRange().getStartOffset() : 0;
        PsiElement rParenthesis = this.getRParenthesis();
        int endOffset = rParenthesis != null ? rParenthesis.getTextRange().getEndOffset() : startOffset;
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            CssFunctionImpl.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @NotNull
    public TextRange getValueTextRange() {
        PsiElement lParenthesis = this.getLParenthesis();
        int startOffset = lParenthesis != null ? lParenthesis.getTextRange().getEndOffset() : 0;
        CssTermList termList = this.getValue();
        PsiElement rParenthesis = this.getRParenthesis();
        int endOffset = rParenthesis != null ? rParenthesis.getTextRange().getEndOffset() : (termList != null ? termList.getTextRange().getEndOffset() : startOffset);
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            CssFunctionImpl.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    @Nullable
    public PsiElement getLParenthesis() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier == null) {
            return null;
        }
        PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)nameIdentifier);
        return nextVisibleLeaf != null && nextVisibleLeaf.getNode().getElementType() == CssElementTypes.CSS_LPAREN ? nextVisibleLeaf : null;
    }

    @Nullable
    public PsiElement getRParenthesis() {
        ASTNode node;
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)this);
        if (lastChild instanceof PsiWhiteSpace) {
            lastChild = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastChild);
        }
        if (lastChild != null && (node = lastChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_RPAREN) {
            return lastChild;
        }
        return null;
    }

    @NotNull
    public CssTermType getType() {
        CssFunctionDescriptor descriptor;
        CssTermList termList;
        String name = CssPropertyUtil.getElementNameWithoutVendorPrefix(this.getName());
        if ("calc".equalsIgnoreCase(name)) {
            CssTerm firstTerm;
            termList = this.getValue();
            if (termList != null && (firstTerm = (CssTerm)ArrayUtil.getFirstElement((Object[])termList.getTerms())) != null) {
                CssTermType cssTermType = firstTerm.getTermType();
                if (cssTermType == null) {
                    CssFunctionImpl.$$$reportNull$$$0(10);
                }
                return cssTermType;
            }
        } else if ("attr".equalsIgnoreCase(name) && (termList = this.getValue()) != null) {
            CssTerm[] terms = termList.getTerms();
            if (terms.length > 1) {
                CssTerm firstTerm = terms[0];
                PsiElement nextVisibleLeaf = PsiTreeUtil.nextVisibleLeaf((PsiElement)firstTerm);
                CssTerm secondTerm = terms[1];
                if (nextVisibleLeaf != null) {
                    if (nextVisibleLeaf.getNode().getElementType() == CssElementTypes.CSS_COMMA) {
                        CssTermType cssTermType = secondTerm.getTermType();
                        if (cssTermType == null) {
                            CssFunctionImpl.$$$reportNull$$$0(11);
                        }
                        return cssTermType;
                    }
                    String typeOfUnit = secondTerm.getText().trim().toLowerCase(Locale.US);
                    CssTermType cssTermType = typeOfStringMap.containsKey(typeOfUnit) ? typeOfStringMap.get(typeOfUnit) : CssTermImpl.getTypeBySuffix(typeOfUnit);
                    if (cssTermType == null) {
                        CssFunctionImpl.$$$reportNull$$$0(12);
                    }
                    return cssTermType;
                }
            }
            CssTermType cssTermType = CssTermTypes.STRING;
            if (cssTermType == null) {
                CssFunctionImpl.$$$reportNull$$$0(13);
            }
            return cssTermType;
        }
        if ((descriptor = (CssFunctionDescriptor)ContainerUtil.getFirstItem((Collection)CssDescriptorsUtil.getFunctionDescriptors((String)name, (PsiElement)this))) != null) {
            CssTermType cssTermType = descriptor.getType();
            if (cssTermType == null) {
                CssFunctionImpl.$$$reportNull$$$0(14);
            }
            return cssTermType;
        }
        CssTermType cssTermType = CssTermType.UNKNOWN;
        if (cssTermType == null) {
            CssFunctionImpl.$$$reportNull$$$0(15);
        }
        return cssTermType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssFunctionImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssFunctionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedValueTextRange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTextRange";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

