/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssBraceMatcher
implements PairedBraceMatcher {
    private static final BracePair[] BRACE_PAIRS = new BracePair[]{new BracePair(CssElementTypes.CSS_LPAREN, CssElementTypes.CSS_RPAREN, false), new BracePair(CssElementTypes.CSS_LBRACKET, CssElementTypes.CSS_RBRACKET, false), new BracePair(CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_RBRACE, true)};

    @NotNull
    public BracePair[] getPairs() {
        if (BRACE_PAIRS == null) {
            CssBraceMatcher.$$$reportNull$$$0(0);
        }
        return BRACE_PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType type) {
        if (lbraceType == null) {
            CssBraceMatcher.$$$reportNull$$$0(1);
        }
        return type == null || CssElementTypes.COMMENTS.contains(type) || CssElementTypes.WHITESPACES.contains(type) || type == CssElementTypes.CSS_SEMICOLON || type == CssElementTypes.CSS_COMMA || type == CssElementTypes.CSS_RPAREN || type == CssElementTypes.CSS_LBRACE || type == CssElementTypes.CSS_RBRACE || type == CssElementTypes.CSS_RBRACKET;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        PsiElement element = file.findElementAt(openingBraceOffset);
        if (element == null || element instanceof PsiFile) {
            return openingBraceOffset;
        }
        CssRuleset closestRuleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)element, CssRuleset.class);
        return closestRuleset != null ? closestRuleset.getTextRange().getStartOffset() : openingBraceOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/editor/CssBraceMatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssBraceMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

