/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixLiveTemplate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class PostfixTemplatesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    PostfixTemplatesCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            PostfixTemplatesCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PostfixTemplatesCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            PostfixTemplatesCompletionProvider.$$$reportNull$$$0(2);
        }
        Editor editor = parameters.getEditor();
        if (!PostfixTemplatesCompletionProvider.isCompletionEnabled(parameters) || LiveTemplateCompletionContributor.shouldShowAllTemplates() || editor.getCaretModel().getCaretCount() != 1) {
            return;
        }
        PsiFile originalFile = parameters.getOriginalFile();
        PostfixLiveTemplate postfixLiveTemplate = PostfixTemplateCompletionContributor.getPostfixLiveTemplate(originalFile, editor);
        if (postfixLiveTemplate != null) {
            postfixLiveTemplate.addCompletions(parameters, result2.withPrefixMatcher((PrefixMatcher)new MyPrefixMatcher(result2.getPrefixMatcher().getPrefix())));
            String possibleKey = postfixLiveTemplate.computeTemplateKeyWithoutContextChecking(new CustomTemplateCallback(editor, originalFile));
            if (possibleKey != null) {
                result2 = result2.withPrefixMatcher(possibleKey);
                result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().oneOf(postfixLiveTemplate.getAllTemplateKeys(originalFile, parameters.getOffset())));
            }
        }
    }

    private static boolean isCompletionEnabled(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            PostfixTemplatesCompletionProvider.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        if (!parameters.isAutoPopup()) {
            return false;
        }
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings.isPostfixTemplatesEnabled() && settings.isTemplatesCompletionEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompletionEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPrefixMatcher
    extends PrefixMatcher {
        protected MyPrefixMatcher(String prefix) {
            super(prefix);
        }

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                MyPrefixMatcher.$$$reportNull$$$0(0);
            }
            return name.equalsIgnoreCase(this.myPrefix);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                MyPrefixMatcher.$$$reportNull$$$0(1);
            }
            MyPrefixMatcher myPrefixMatcher = new MyPrefixMatcher(prefix);
            if (myPrefixMatcher == null) {
                MyPrefixMatcher.$$$reportNull$$$0(2);
            }
            return myPrefixMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider$MyPrefixMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider$MyPrefixMatcher";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cloneWithPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prefixMatches";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneWithPrefix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

