/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.util.containers.StringInterner;
import com.thoughtworks.xstream.io.xml.XppReader;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class OfflineViewParseUtil {
    @NonNls
    private static final String PACKAGE = "package";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String HINTS = "hints";
    @NonNls
    private static final String LINE = "line";
    @NonNls
    private static final String MODULE = "module";

    private OfflineViewParseUtil() {
    }

    public static Map<String, Set<OfflineProblemDescriptor>> parse(File problemFile) throws FileNotFoundException {
        return OfflineViewParseUtil.parse(new FileReader(problemFile));
    }

    @Deprecated
    public static Map<String, Set<OfflineProblemDescriptor>> parse(String problemText) {
        return OfflineViewParseUtil.parse(new StringReader(problemText));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Set<OfflineProblemDescriptor>> parse(Reader problemReader) {
        TObjectIntHashMap fqName2IdxMap = new TObjectIntHashMap();
        StringInterner stringInterner = new StringInterner();
        HashMap<String, Set<OfflineProblemDescriptor>> package2Result = new HashMap<String, Set<OfflineProblemDescriptor>>();
        try (XppReader reader = new XppReader(problemReader, (XmlPullParser)new MXParser());){
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                OfflineProblemDescriptor descriptor = new OfflineProblemDescriptor();
                boolean added = false;
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if ("entry_point".equals(reader.getNodeName())) {
                        descriptor.setType(reader.getAttribute("TYPE"));
                        String fqName = reader.getAttribute("FQNAME");
                        descriptor.setFQName(fqName);
                        if (!fqName2IdxMap.containsKey((Object)fqName)) {
                            fqName2IdxMap.put((Object)fqName, 0);
                        }
                        int idx = fqName2IdxMap.get((Object)fqName);
                        descriptor.setProblemIndex(idx);
                        fqName2IdxMap.put((Object)fqName, idx + 1);
                    }
                    if (DESCRIPTION.equals(reader.getNodeName())) {
                        descriptor.setDescription((String)stringInterner.intern((Object)reader.getValue()));
                    }
                    if (LINE.equals(reader.getNodeName())) {
                        descriptor.setLine(Integer.parseInt(reader.getValue()));
                    }
                    if (MODULE.equals(reader.getNodeName())) {
                        descriptor.setModule((String)stringInterner.intern((Object)reader.getValue()));
                    }
                    if (HINTS.equals(reader.getNodeName())) {
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            ArrayList<Object> hints = descriptor.getHints();
                            if (hints == null) {
                                hints = new ArrayList<Object>();
                                descriptor.setHints(hints);
                            }
                            hints.add(stringInterner.intern((Object)reader.getAttribute("value")));
                            reader.moveUp();
                        }
                    }
                    if (PACKAGE.equals(reader.getNodeName())) {
                        OfflineViewParseUtil.appendDescriptor(package2Result, reader.getValue(), descriptor);
                        added = true;
                    }
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if (PACKAGE.equals(reader.getNodeName())) {
                            OfflineViewParseUtil.appendDescriptor(package2Result, reader.getValue(), descriptor);
                            added = true;
                        }
                        reader.moveUp();
                    }
                    reader.moveUp();
                }
                if (!added) {
                    OfflineViewParseUtil.appendDescriptor(package2Result, null, descriptor);
                }
                reader.moveUp();
            }
        }
        return package2Result;
    }

    @Nullable
    public static String parseProfileName(File descriptorFile) throws FileNotFoundException {
        return OfflineViewParseUtil.parseProfileName(new FileReader(descriptorFile));
    }

    @Deprecated
    @Nullable
    public static String parseProfileName(String descriptorText) {
        return OfflineViewParseUtil.parseProfileName(new StringReader(descriptorText));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String parseProfileName(Reader descriptorReader) {
        try (XppReader reader = new XppReader(descriptorReader, (XmlPullParser)new MXParser());){
            String string = reader.getAttribute("profile");
            return string;
        }
    }

    private static void appendDescriptor(Map<String, Set<OfflineProblemDescriptor>> package2Result, String packageName, OfflineProblemDescriptor descriptor) {
        THashSet descriptors = package2Result.get(packageName);
        if (descriptors == null) {
            descriptors = new THashSet();
            package2Result.put(packageName, (Set<OfflineProblemDescriptor>)descriptors);
        }
        descriptors.add((OfflineProblemDescriptor)descriptor);
    }
}

