/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools;

import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ComponentDiffRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDiffTool
implements FrameDiffTool {
    public static final ErrorDiffTool INSTANCE = new ErrorDiffTool();
    private static final Logger LOG = Logger.getInstance(ErrorDiffTool.class);

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            ErrorDiffTool.$$$reportNull$$$0(0);
        }
        if (request == null) {
            ErrorDiffTool.$$$reportNull$$$0(1);
        }
        MyViewer myViewer = new MyViewer(context, request);
        if (myViewer == null) {
            ErrorDiffTool.$$$reportNull$$$0(2);
        }
        return myViewer;
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            ErrorDiffTool.$$$reportNull$$$0(3);
        }
        if (request == null) {
            ErrorDiffTool.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    public String getName() {
        if ("Error viewer" == null) {
            ErrorDiffTool.$$$reportNull$$$0(5);
        }
        return "Error viewer";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/ErrorDiffTool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/ErrorDiffTool";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canShow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyViewer
    implements FrameDiffTool.DiffViewer {
        @NotNull
        private final DiffContext myContext;
        @NotNull
        private final DiffRequest myRequest;
        @NotNull
        private final JPanel myPanel;

        MyViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
            if (context == null) {
                MyViewer.$$$reportNull$$$0(0);
            }
            if (request == null) {
                MyViewer.$$$reportNull$$$0(1);
            }
            this.myContext = context;
            this.myRequest = request;
            this.myPanel = JBUI.Panels.simplePanel((Component)this.createComponent(request));
        }

        @NotNull
        private JComponent createComponent(@NotNull DiffRequest request) {
            if (request == null) {
                MyViewer.$$$reportNull$$$0(2);
            }
            if (request instanceof MessageDiffRequest) {
                String message = ((MessageDiffRequest)request).getMessage();
                JPanel jPanel = DiffUtil.createMessagePanel(message);
                if (jPanel == null) {
                    MyViewer.$$$reportNull$$$0(3);
                }
                return jPanel;
            }
            if (request instanceof ComponentDiffRequest) {
                JComponent jComponent = ((ComponentDiffRequest)request).getComponent(this.myContext);
                if (jComponent == null) {
                    MyViewer.$$$reportNull$$$0(4);
                }
                return jComponent;
            }
            if (request instanceof ContentDiffRequest) {
                List contents = ((ContentDiffRequest)request).getContents();
                for (DiffContent content : contents) {
                    if (!(content instanceof FileContent) || !FileTypes.UNKNOWN.equals(content.getContentType())) continue;
                    VirtualFile file2 = ((FileContent)content).getFile();
                    UnknownFileTypeDiffRequest unknownFileTypeRequest = new UnknownFileTypeDiffRequest(file2, this.myRequest.getTitle());
                    JComponent jComponent = unknownFileTypeRequest.getComponent(this.myContext);
                    if (jComponent == null) {
                        MyViewer.$$$reportNull$$$0(5);
                    }
                    return jComponent;
                }
            }
            LOG.info("Can't show diff for " + request.getClass().getName());
            if (request instanceof ContentDiffRequest) {
                for (DiffContent content : ((ContentDiffRequest)request).getContents()) {
                    String type = content.getContentType() != null ? content.getContentType().getName() : "null";
                    LOG.info(String.format("      %s, content type: %s", content.getClass().getName(), type));
                }
            }
            JPanel jPanel = DiffUtil.createMessagePanel("Can't show diff");
            if (jPanel == null) {
                MyViewer.$$$reportNull$$$0(6);
            }
            return jPanel;
        }

        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                MyViewer.$$$reportNull$$$0(7);
            }
            return jPanel;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public FrameDiffTool.ToolbarComponents init() {
            String fileName;
            if (this.myRequest instanceof UnknownFileTypeDiffRequest && (fileName = ((UnknownFileTypeDiffRequest)this.myRequest).getFileName()) != null && FileTypeManager.getInstance().getFileTypeByFileName(fileName) != UnknownFileType.INSTANCE && this.myContext instanceof DiffContextEx) {
                ApplicationManager.getApplication().invokeLater(() -> ((DiffContextEx)this.myContext).reloadDiffRequest(), ModalityState.current());
            }
            FrameDiffTool.ToolbarComponents toolbarComponents = new FrameDiffTool.ToolbarComponents();
            if (toolbarComponents == null) {
                MyViewer.$$$reportNull$$$0(8);
            }
            return toolbarComponents;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/ErrorDiffTool$MyViewer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/ErrorDiffTool$MyViewer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "init";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createComponent";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

