/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.dvcs.util.LocalCommitCompareInfo;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.ui.ReplaceFileConfirmationDialog;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

class CompareBranchesDiffPanel
extends JPanel {
    private final CompareBranchesHelper myHelper;
    private final String myBranchName;
    private final Project myProject;
    private final String myCurrentBranchName;
    private final CommitCompareInfo myCompareInfo;
    private final DvcsCompareSettings myVcsSettings;
    private final JEditorPane myLabel;
    private final MyChangesBrowser myChangesBrowser;

    CompareBranchesDiffPanel(CompareBranchesHelper helper, String branchName, String currentBranchName, CommitCompareInfo compareInfo) {
        this.myHelper = helper;
        this.myProject = helper.getProject();
        this.myCurrentBranchName = currentBranchName;
        this.myCompareInfo = compareInfo;
        this.myBranchName = branchName;
        this.myVcsSettings = helper.getDvcsCompareSettings();
        this.myLabel = new JEditorPane(){

            @Override
            public void setText(String t) {
                super.setText(t);
                this.getPreferredSize();
            }
        };
        this.myLabel.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myLabel.setEditable(false);
        this.myLabel.setBackground(null);
        this.myLabel.setOpaque(false);
        this.myLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                boolean swapSides = CompareBranchesDiffPanel.this.myVcsSettings.shouldSwapSidesInCompareBranches();
                CompareBranchesDiffPanel.this.myVcsSettings.setSwapSidesInCompareBranches(!swapSides);
                CompareBranchesDiffPanel.this.refreshView();
            }
        });
        this.myChangesBrowser = new MyChangesBrowser(helper.getProject(), Collections.emptyList());
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLabel, "North");
        this.add((Component)this.myChangesBrowser, "Center");
        this.refreshView();
    }

    private void refreshView() {
        boolean swapSides = this.myVcsSettings.shouldSwapSidesInCompareBranches();
        String currentBranchText = String.format("current working tree on <b><code>%s</code></b>", this.myCurrentBranchName);
        String otherBranchText = String.format("files in <b><code>%s</code></b>", this.myBranchName);
        this.myLabel.setText(String.format("<html>Difference between %s and %s:&emsp;<a href=\"\">Swap branches</a></html>", swapSides ? otherBranchText : currentBranchText, swapSides ? currentBranchText : otherBranchText));
        List<Change> diff = this.myCompareInfo.getTotalDiff();
        if (swapSides) {
            diff = DvcsBranchUtil.swapRevisions(diff);
        }
        this.myChangesBrowser.setChangesToDisplay(diff);
    }

    private class MyCopyChangesAction
    extends DumbAwareAction {
        MyCopyChangesAction() {
            super("Get from Branch", "Replace file content with its version from branch " + CompareBranchesDiffPanel.this.myBranchName, AllIcons.Actions.Download);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("Vcs.GetVersion"));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCopyChangesAction.$$$reportNull$$$0(0);
            }
            boolean isEnabled = !CompareBranchesDiffPanel.this.myChangesBrowser.getSelectedChanges().isEmpty();
            boolean isVisible = CompareBranchesDiffPanel.this.myCompareInfo instanceof LocalCommitCompareInfo;
            e.getPresentation().setEnabled(isEnabled && isVisible);
            e.getPresentation().setVisible(isVisible);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCopyChangesAction.$$$reportNull$$$0(1);
            }
            String title = String.format("Get from Branch '%s'", CompareBranchesDiffPanel.this.myBranchName);
            final List<Change> changes2 = CompareBranchesDiffPanel.this.myChangesBrowser.getSelectedChanges();
            final boolean swapSides = CompareBranchesDiffPanel.this.myVcsSettings.shouldSwapSidesInCompareBranches();
            ReplaceFileConfirmationDialog confirmationDialog = new ReplaceFileConfirmationDialog(CompareBranchesDiffPanel.this.myProject, title);
            if (!confirmationDialog.confirmFor(ChangesUtil.getFilesFromChanges(changes2))) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            final LocalHistoryAction action = LocalHistory.getInstance().startAction(title);
            new Task.Modal(CompareBranchesDiffPanel.this.myProject, "Loading Content from Branch", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        ((LocalCommitCompareInfo)CompareBranchesDiffPanel.this.myCompareInfo).copyChangesFromBranch(changes2, swapSides);
                    }
                    catch (VcsException err) {
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)err.getMessage(), (String)"Can't Copy Changes"));
                    }
                }

                public void onFinished() {
                    action.finish();
                    CompareBranchesDiffPanel.this.refreshView();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyCopyChangesAction$1", "run"));
                }
            }.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyCopyChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyChangesBrowser
    extends SimpleChangesBrowser {
        MyChangesBrowser(@NotNull Project project, List<Change> changes2) {
            if (project == null) {
                MyChangesBrowser.$$$reportNull$$$0(0);
            }
            if (changes2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(1);
            }
            super(project, false, true);
            this.setChangesToDisplay(changes2);
        }

        @Override
        public void setChangesToDisplay(@NotNull Collection<? extends Change> changes2) {
            if (changes2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(2);
            }
            List<Change> oldSelection = this.getSelectedChanges();
            super.setChangesToDisplay(changes2);
            this.myViewer.setSelectedChanges(DvcsBranchUtil.swapRevisions(oldSelection));
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions() {
            List list2 = ContainerUtil.append(super.createToolbarActions(), (Object[])new AnAction[]{new MyCopyChangesAction()});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<AnAction> createPopupMenuActions() {
            List list2 = ContainerUtil.append(super.createPopupMenuActions(), (Object[])new AnAction[]{new MyCopyChangesAction()});
            if (list2 == null) {
                MyChangesBrowser.$$$reportNull$$$0(4);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyChangesBrowser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/ui/CompareBranchesDiffPanel$MyChangesBrowser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createToolbarActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupMenuActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setChangesToDisplay";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

