/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.ui.TabbedPaneWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class HeaderlessTabbedPane
extends JPanel {
    private final TabbedPaneWrapper myTabbedPane;
    @Nullable
    private JComponent myTabContent;
    @Nullable
    private String myTabTitle;

    public HeaderlessTabbedPane(Disposable disposable) {
        super(new BorderLayout());
        this.myTabbedPane = new TabbedPaneWrapper(disposable);
        this.add((Component)this.myTabbedPane.getComponent(), "Center");
    }

    public void addTab(String title, JComponent component) {
        if (this.myTabContent != null) {
            throw new IllegalStateException("Please show header before changing tabs");
        }
        this.myTabbedPane.addTab(title, component);
    }

    public void setSelectedIndex(int index) {
        if (this.myTabContent != null) {
            if (index != 0) {
                throw new IllegalArgumentException("Invalid index");
            }
            return;
        }
        this.myTabbedPane.setSelectedIndex(index);
    }

    public int getTabCount() {
        if (this.myTabContent != null) {
            return 0;
        }
        return this.myTabbedPane.getTabCount();
    }

    public void addChangeListener(ChangeListener listener2) {
        this.myTabbedPane.addChangeListener(listener2);
    }

    public int indexOfComponent(JComponent component) {
        if (this.myTabContent != null) {
            return component == this.myTabContent ? 0 : -1;
        }
        return this.myTabbedPane.indexOfComponent(component);
    }

    public void removeTabAt(int index) {
        if (this.myTabContent != null) {
            throw new IllegalStateException("Please show header before changing tabs");
        }
        this.myTabbedPane.removeTabAt(index);
    }

    public int getSelectedIndex() {
        if (this.myTabContent != null) {
            return 0;
        }
        return this.myTabbedPane.getSelectedIndex();
    }

    public void setHeaderVisible(boolean visible) {
        if (visible == (this.myTabContent == null)) {
            return;
        }
        if (visible) {
            this.remove(this.myTabContent);
            this.myTabbedPane.addTab(this.myTabTitle, this.myTabContent);
            this.add(this.myTabbedPane.getComponent());
            this.myTabTitle = null;
            this.myTabContent = null;
        } else {
            if (this.myTabbedPane.getTabCount() != 1) {
                throw new IllegalStateException("Please leave one tab before hiding header, now we have " + this.myTabbedPane.getTabCount() + " tabs");
            }
            this.add((Component)this.myTabbedPane.getComponent(), "Center");
            this.myTabContent = this.myTabbedPane.getComponentAt(0);
            this.myTabTitle = this.myTabbedPane.getTitleAt(0);
            this.myTabbedPane.removeTabAt(0);
            this.remove(this.myTabbedPane.getComponent());
            this.add((Component)this.myTabContent, "Center");
        }
    }
}

