/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.media.css3;

import org.w3c.css.media.MediaFeature;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class MediaHeight
extends MediaFeature {
    public MediaHeight() {
    }

    public MediaHeight(ApplContext ac, String modifier, CssExpression expression, boolean check2) throws InvalidParamException {
        if (expression != null) {
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 5: {
                    val = ((CssNumber)val).getLength();
                }
                case 6: {
                    CssLength l = (CssLength)val;
                    if (!l.isPositive()) {
                        throw new InvalidParamException("negative-value", val.toString(), ac);
                    }
                    this.value = val;
                    expression.next();
                    break;
                }
                default: {
                    throw new InvalidParamException("value", expression.getValue(), this.getFeatureName(), ac);
                }
            }
            this.setModifier(ac, modifier);
        } else if (modifier != null) {
            throw new InvalidParamException("nomodifiershortmedia", this.getFeatureName(), ac);
        }
    }

    public MediaHeight(ApplContext ac, String modifier, CssExpression expression) throws InvalidParamException {
        this(ac, modifier, expression, false);
    }

    public Object get() {
        return this.value;
    }

    @Override
    public final String getFeatureName() {
        return "height";
    }

    @Override
    public boolean equals(MediaFeature other) {
        try {
            MediaHeight mh = (MediaHeight)other;
            return (this.value == null && mh.value == null || this.value != null && this.value.equals(mh.value)) && (this.modifier == null && mh.modifier == null || this.modifier != null && this.modifier.equals(mh.modifier));
        }
        catch (ClassCastException cce) {
            return false;
        }
    }
}

