/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.ArrayList;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssValue;

public class CssExpression
implements CssOperator {
    private ArrayList<ValueOperator> items = new ArrayList();
    private int count = 0;
    private int index = 0;
    private int mark = -1;
    private boolean vendor_extension = false;

    public boolean hasVendorExtensions() {
        return this.vendor_extension;
    }

    public void markVendorExtension() {
        this.vendor_extension = true;
    }

    public void mark() {
        this.mark = this.index;
    }

    public void reset() {
        this.index = this.mark >= 0 ? this.mark : 0;
    }

    public void addValue(CssValue value) {
        this.items.add(new ValueOperator(value));
        ++this.count;
    }

    public void setOperator(char operator) {
        this.items.get((int)(this.count - 1)).operator = operator;
    }

    public void setCurrentOperator(char operator) {
        this.items.get((int)this.index).operator = operator;
    }

    public CssValue getValue() {
        if (this.index == this.count) {
            return null;
        }
        return this.items.get((int)this.index).value;
    }

    public CssValue getNextValue() {
        if (this.index + 1 >= this.count) {
            return null;
        }
        return this.items.get((int)(this.index + 1)).value;
    }

    public char getOperator() {
        if (this.index == this.count) {
            return ' ';
        }
        return this.items.get((int)this.index).operator;
    }

    public int getCount() {
        return this.count;
    }

    public int getRemainingCount() {
        return this.count - this.index;
    }

    public void insert(CssValue value) {
        this.items.add(this.index, new ValueOperator(value));
        ++this.count;
    }

    public void remove() {
        if (this.index != this.count) {
            this.items.remove(this.index);
        }
        --this.count;
    }

    public boolean end() {
        return this.index == this.count;
    }

    public void starts() {
        this.index = 0;
    }

    public void ends() {
        this.index = this.count;
    }

    public void next() {
        if (this.index < this.count) {
            ++this.index;
        }
    }

    public void precedent() {
        if (this.index > 0) {
            --this.index;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.index; i < this.count; ++i) {
            ValueOperator vo = this.items.get(i);
            sb.append(vo.value.toString()).append(vo.operator);
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return "**invalid state**";
    }

    public String toStringFromStart() {
        StringBuilder sb = new StringBuilder();
        for (ValueOperator anItem : this.items) {
            sb.append(anItem.value.toString()).append(anItem.operator);
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private class ValueOperator {
        CssValue value;
        char operator;

        ValueOperator(CssValue value) {
            this.value = value;
            this.operator = (char)32;
        }
    }
}

