/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import a.b.lb;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsHighlightingUtil;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementProblemDescriptorImpl
implements DomElementProblemDescriptor {
    private static final Logger g;
    private final DomElement a;
    private final HighlightSeverity h;
    private final String f;
    private final LocalQuickFix[] e;
    private List<Annotation> b;
    private Pair<TextRange, PsiElement> d;
    public static final Pair<TextRange, PsiElement> NO_PROBLEM;
    private final ProblemHighlightType c;
    private static final long k;

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String message, HighlightSeverity type) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(0);
        }
        this(domElement, message, type, LocalQuickFix.EMPTY_ARRAY);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String message, HighlightSeverity type, @Nullable TextRange textRange) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(1);
        }
        this(domElement, message, type, textRange, null, LocalQuickFix.EMPTY_ARRAY);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String message, HighlightSeverity type, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(2);
        }
        if (fixes == null) {
            DomElementProblemDescriptorImpl.a(3);
        }
        this(domElement, message, type, (TextRange)null, (ProblemHighlightType)null, fixes);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String message, HighlightSeverity type, @Nullable TextRange textRange, ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        long l3 = k ^ 0x21FD8C74FE15L;
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(4);
        }
        if (fixes == null) {
            DomElementProblemDescriptorImpl.a(5);
        }
        this.a = domElement;
        XmlElement xmlElement = domElement.getXmlElement();
        if (xmlElement == null || !ApplicationManager.getApplication().isUnitTestMode()) {
            // empty if block
        }
        this.h = type;
        this.f = message;
        LocalQuickFix[] localQuickFixArray = this.e = ArrayUtil.contains(null, (Object[])fixes) ? (LocalQuickFix[])ContainerUtil.mapNotNull((Object[])fixes, (Function)FunctionUtil.id(), (Object[])LocalQuickFix.EMPTY_ARRAY) : fixes;
        if (textRange != null) {
            PsiElement psiElement = this.b();
            g.assertTrue(psiElement != null, (Object)"Problems with explicit text range can't be created for DOM elements without underlying XML element");
            assert (psiElement.isValid());
            this.d = Pair.create((Object)textRange, (Object)psiElement);
        }
        this.c = highlightType;
    }

    @NotNull
    public DomElement getDomElement() {
        DomElement domElement = this.a;
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(6);
        }
        return domElement;
    }

    @NotNull
    public HighlightSeverity getHighlightSeverity() {
        HighlightSeverity highlightSeverity = this.h;
        if (highlightSeverity == null) {
            DomElementProblemDescriptorImpl.a(7);
        }
        return highlightSeverity;
    }

    @NotNull
    public String getDescriptionTemplate() {
        String string = this.f == null ? "" : this.f;
        if (string == null) {
            DomElementProblemDescriptorImpl.a(8);
        }
        return string;
    }

    @NotNull
    public LocalQuickFix[] getFixes() {
        if (this.e == null) {
            DomElementProblemDescriptorImpl.a(9);
        }
        return this.e;
    }

    @NotNull
    public final List<Annotation> getAnnotations() {
        if (this.b == null) {
            this.b = ContainerUtil.createMaybeSingletonList((Object)DomElementsHighlightingUtil.createAnnotation(this));
        }
        List<Annotation> list2 = this.b;
        if (list2 == null) {
            DomElementProblemDescriptorImpl.a(10);
        }
        return list2;
    }

    public void highlightWholeElement() {
        PsiElement psiElement = this.b();
        if (psiElement instanceof XmlAttributeValue) {
            assert (psiElement.isValid()) : psiElement;
            PsiElement psiElement2 = psiElement.getParent();
            this.d = Pair.create((Object)new TextRange(0, psiElement2.getTextLength()), (Object)psiElement2);
        } else if (psiElement != null) {
            assert (psiElement.isValid()) : psiElement;
            XmlTag xmlTag = (XmlTag)(psiElement instanceof XmlTag ? psiElement : psiElement.getParent());
            this.d = new Pair((Object)new TextRange(0, xmlTag.getTextLength()), (Object)xmlTag);
        }
    }

    public Pair<TextRange, PsiElement> getProblemRange() {
        PsiElement psiElement;
        if (this.d == null) {
            this.d = this.computeProblemRange();
        }
        if ((psiElement = (PsiElement)this.d.second) != null) {
            PsiUtilCore.ensureValid((PsiElement)psiElement);
        }
        return this.d;
    }

    @NotNull
    protected Pair<TextRange, PsiElement> computeProblemRange() {
        PsiElement psiElement = this.b();
        if (psiElement != null) {
            String string;
            assert (psiElement.isValid()) : psiElement;
            if (psiElement instanceof XmlTag) {
                Pair pair = DomUtil.getProblemRange((XmlTag)((XmlTag)psiElement));
                if (pair == null) {
                    DomElementProblemDescriptorImpl.a(11);
                }
                return pair;
            }
            int n2 = psiElement.getTextRange().getLength();
            TextRange textRange = TextRange.from((int)0, (int)n2);
            if (psiElement instanceof XmlAttributeValue && StringUtil.isNotEmpty((String)(string = ((XmlAttributeValue)psiElement).getValue()))) {
                textRange = TextRange.from((int)psiElement.getText().indexOf(string), (int)string.length());
            }
            Pair pair = Pair.create((Object)textRange, (Object)psiElement);
            if (pair == null) {
                DomElementProblemDescriptorImpl.a(12);
            }
            return pair;
        }
        XmlTag xmlTag = this.a();
        if (xmlTag != null) {
            Pair pair = DomUtil.getProblemRange((XmlTag)xmlTag);
            if (pair == null) {
                DomElementProblemDescriptorImpl.a(13);
            }
            return pair;
        }
        Pair<TextRange, PsiElement> pair = NO_PROBLEM;
        if (pair == null) {
            DomElementProblemDescriptorImpl.a(14);
        }
        return pair;
    }

    public String toString() {
        long l3 = k ^ 0x13F930A7A002L;
        return this.a + "; " + this.f;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DomElementProblemDescriptorImpl domElementProblemDescriptorImpl = (DomElementProblemDescriptorImpl)o2;
        if (this.a != null ? !this.a.equals(domElementProblemDescriptorImpl.a) : domElementProblemDescriptorImpl.a != null) {
            return false;
        }
        if (!this.f.equals(domElementProblemDescriptorImpl.f)) {
            return false;
        }
        return this.h.equals((Object)domElementProblemDescriptorImpl.h);
    }

    public int hashCode() {
        int n2 = this.a != null ? this.a.hashCode() : 0;
        n2 = 31 * n2 + this.h.hashCode();
        n2 = 31 * n2 + this.f.hashCode();
        return n2;
    }

    @Nullable
    private PsiElement b() {
        XmlText[] xmlTextArray;
        if (this.a instanceof DomFileElement) {
            return ((DomFileElement)this.a).getFile();
        }
        if (this.a instanceof GenericAttributeValue) {
            GenericAttributeValue genericAttributeValue = (GenericAttributeValue)this.a;
            XmlAttributeValue xmlAttributeValue = genericAttributeValue.getXmlAttributeValue();
            return xmlAttributeValue != null && StringUtil.isNotEmpty((String)xmlAttributeValue.getText()) ? xmlAttributeValue : genericAttributeValue.getXmlElement();
        }
        XmlTag xmlTag = this.a.getXmlTag();
        if (this.a instanceof GenericValue && xmlTag != null && (xmlTextArray = xmlTag.getValue().getTextElements()).length > 0) {
            return xmlTextArray[0];
        }
        return xmlTag;
    }

    @Nullable
    private XmlTag a() {
        for (DomElement domElement = this.a.getParent(); domElement != null; domElement = domElement.getParent()) {
            if (domElement.getXmlTag() == null) continue;
            return domElement.getXmlTag();
        }
        return null;
    }

    @Nullable
    public ProblemHighlightType getHighlightType() {
        return this.c;
    }

    static {
        k = lb.a(-7588637654212427021L, 1236389325367577925L, MethodHandles.lookup().lookupClass()).a(250909453196500L);
        long l3 = k ^ 0x355131027157L;
        g = Logger.getInstance((String)"#com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl");
        NO_PROBLEM = new Pair(null, null);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l3 = k ^ 0x6F8F5B77921FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementProblemDescriptorImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementProblemDescriptorImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightSeverity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProblemRange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

