/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.push.CommitLoader;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.VcsErrorHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgOutgoingCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.push.HgPushSource;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgOutgoingCommitsProvider
extends OutgoingCommitsProvider<HgRepository, HgPushSource, HgTarget> {
    private static final Logger LOG = Logger.getInstance(HgOutgoingCommitsProvider.class);
    private static final String LOGIN_AND_REFRESH_LINK = "Enter Password & Refresh";

    @NotNull
    public OutgoingResult getOutgoingCommits(@NotNull HgRepository repository, @NotNull PushSpec<HgPushSource, HgTarget> pushSpec, boolean initial) {
        if (repository == null) {
            HgOutgoingCommitsProvider.$$$reportNull$$$0(0);
        }
        if (pushSpec == null) {
            HgOutgoingCommitsProvider.$$$reportNull$$$0(1);
        }
        Project project = repository.getProject();
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(true, version);
        HgOutgoingCommand hgOutgoingCommand = new HgOutgoingCommand(project);
        HgTarget hgTarget = (HgTarget)pushSpec.getTarget();
        ArrayList<VcsError> errors = new ArrayList<VcsError>();
        if (StringUtil.isEmptyOrSpaces((String)hgTarget.myTarget)) {
            errors.add(new VcsError("Hg push path could not be empty."));
            OutgoingResult outgoingResult = new OutgoingResult(Collections.emptyList(), errors);
            if (outgoingResult == null) {
                HgOutgoingCommitsProvider.$$$reportNull$$$0(2);
            }
            return outgoingResult;
        }
        HgCommandResult result = hgOutgoingCommand.execute(repository.getRoot(), HgChangesetUtil.makeTemplate(templates), ((HgPushSource)pushSpec.getSource()).getPresentation(), hgTarget.myTarget, initial);
        if (result == null) {
            errors.add(new VcsError("Couldn't execute hg outgoing command for " + repository));
            OutgoingResult outgoingResult = new OutgoingResult(Collections.emptyList(), errors);
            if (outgoingResult == null) {
                HgOutgoingCommitsProvider.$$$reportNull$$$0(3);
            }
            return outgoingResult;
        }
        List<String> resultErrors = result.getErrorLines();
        if (resultErrors != null && !resultErrors.isEmpty() && result.getExitValue() != 0) {
            for (String error : resultErrors) {
                if (!HgErrorUtil.isAbortLine(error)) continue;
                if (HgErrorUtil.isAuthorizationError(error)) {
                    VcsError authorizationError = new VcsError(error + "<a href='authenticate'>" + LOGIN_AND_REFRESH_LINK + "</a>", new VcsErrorHandler(){

                        public void handleError(@NotNull CommitLoader commitLoader) {
                            if (commitLoader == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            commitLoader.reloadCommits();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitLoader", "org/zmlx/hg4idea/push/HgOutgoingCommitsProvider$1", "handleError"));
                        }
                    });
                    errors.add(authorizationError);
                    continue;
                }
                errors.add(new VcsError(error));
            }
            LOG.warn(resultErrors.toString());
        }
        OutgoingResult outgoingResult = new OutgoingResult(HgHistoryUtil.createFullCommitsFromResult(project, repository.getRoot(), result, version, true), errors);
        if (outgoingResult == null) {
            HgOutgoingCommitsProvider.$$$reportNull$$$0(4);
        }
        return outgoingResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSpec";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/push/HgOutgoingCommitsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/push/HgOutgoingCommitsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutgoingCommits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOutgoingCommits";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

