/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.PublicFieldBasedOptionDescription;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public final class PerforceOptionsTopHitProvider
extends OptionsTopHitProvider {
    public String getId() {
        return "vcs";
    }

    @NotNull
    public Collection<OptionDescription> getOptions(@Nullable Project project) {
        if (project != null) {
            for (VcsDescriptor descriptor : ProjectLevelVcsManager.getInstance((Project)project).getAllVcss()) {
                if (!"Perforce".equals(descriptor.getDisplayName())) continue;
                Collection<BooleanOptionDescription> collection = Collections.unmodifiableCollection(Arrays.asList(PerforceOptionsTopHitProvider.option(project, "Perforce: Perforce is online", "ENABLED"), PerforceOptionsTopHitProvider.option(project, "Perforce: Switch to offline mode automatically if Perforce is unavailable", "myCanGoOffline"), PerforceOptionsTopHitProvider.option(project, "Perforce: Dump Perforce Commands to log", "showCmds"), PerforceOptionsTopHitProvider.option(project, "Perforce: Use login authentication", "USE_LOGIN"), PerforceOptionsTopHitProvider.option(project, "Perforce: Show branching history", "SHOW_BRANCHES_HISTORY"), PerforceOptionsTopHitProvider.option(project, "Perforce: Show integrated changelists in committed changes", "SHOW_INTEGRATED_IN_COMMITTED_CHANGES"), PerforceOptionsTopHitProvider.option(project, "Perforce: Enable Perforce Jobs support", "USE_PERFORCE_JOBS")));
                if (collection == null) {
                    PerforceOptionsTopHitProvider.$$$reportNull$$$0(0);
                }
                return collection;
            }
        }
        List<OptionDescription> list = Collections.emptyList();
        if (list == null) {
            PerforceOptionsTopHitProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static BooleanOptionDescription option(final Project project, String option, final String field) {
        return new PublicFieldBasedOptionDescription(option, "vcs.Perforce", field){

            public PerforceSettings getInstance() {
                return PerforceSettings.getSettings(project);
            }

            public void setOptionState(boolean enabled) {
                super.setOptionState(enabled);
                if ("ENABLED".equals(field)) {
                    if (enabled) {
                        this.getInstance().enable();
                    } else {
                        this.getInstance().disable(true);
                        VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/PerforceOptionsTopHitProvider", "getOptions"));
    }
}

