/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.parsing;

import com.intellij.openapi.util.Pair;
import com.jetbrains.php.framework.data.FrameworkOption;
import com.jetbrains.php.framework.parsing.UserInputPart;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionPart
extends UserInputPart {
    public static final OptionPart EMPTY = new OptionPart("");
    private final String valueText;
    private final boolean hasValue;

    public OptionPart(String text) {
        this(text, false, null);
    }

    public OptionPart(String text, @NotNull String valueText) {
        if (valueText == null) {
            OptionPart.$$$reportNull$$$0(0);
        }
        this(text, true, valueText);
    }

    private OptionPart(String text, boolean hasValue, String valueText) {
        super(text);
        this.valueText = valueText;
        this.hasValue = hasValue;
    }

    public String getValueText() {
        return this.valueText;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OptionPart part = (OptionPart)o;
        if (this.hasValue != part.hasValue) {
            return false;
        }
        return !(this.valueText != null ? !this.valueText.equals(part.valueText) : part.valueText != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.valueText != null ? this.valueText.hashCode() : 0);
        result = 31 * result + (this.hasValue ? 1 : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "OptionPart{valueText='" + this.valueText + '\'' + ", hasValue=" + this.hasValue + '}';
    }

    @Nullable
    public static OptionPart cutOption(List<String> parts, List<FrameworkOption> params) {
        if (parts.isEmpty()) {
            return null;
        }
        String option = parts.get(0);
        if (!OptionPart.isOption(option)) {
            return null;
        }
        parts.remove(0);
        FrameworkOption frameworkOption = OptionPart.getMatchingOption(option, params);
        if (frameworkOption == null) {
            return new OptionPart(option);
        }
        FrameworkOption.ValuePattern pattern = frameworkOption.getValuePattern();
        if (pattern == null) {
            return new OptionPart(option);
        }
        if (!pattern.hasSeparateValue()) {
            Pair<String, String> optionAndValue = pattern.parseOptionAndValue(option);
            return new OptionPart((String)optionAndValue.getFirst(), (String)optionAndValue.getSecond());
        }
        if (parts.isEmpty()) {
            return new OptionPart(option);
        }
        String value = parts.get(0);
        if (!OptionPart.isOption(value)) {
            parts.remove(0);
            return new OptionPart(option, value);
        }
        return new OptionPart(option);
    }

    @Nullable
    private static FrameworkOption getMatchingOption(String part, List<FrameworkOption> params) {
        if (part == null) {
            return null;
        }
        for (FrameworkOption param : params) {
            if (!(param.getValuePattern() == null ? part.equals(param.getName()) || param.hasShortcut() && part.equals(param.getShortcut()) : param.getValuePattern().matches(param, part))) continue;
            return param;
        }
        return null;
    }

    private static boolean isOption(String part) {
        return part.startsWith("-");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueText", "com/jetbrains/php/framework/parsing/OptionPart", "<init>"));
    }
}

