/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.copy;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.checkin.CmdCheckinClient;
import org.jetbrains.idea.svn.checkin.CommitEventHandler;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.copy.CopyMoveClient;

public class CmdCopyMoveClient
extends BaseSvnClient
implements CopyMoveClient {
    @Override
    public void copy(@NotNull File src, @NotNull File dst, boolean makeParents, boolean isMove) throws VcsException {
        if (src == null) {
            CmdCopyMoveClient.$$$reportNull$$$0(0);
        }
        if (dst == null) {
            CmdCopyMoveClient.$$$reportNull$$$0(1);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, src);
        CommandUtil.put(parameters, dst, false);
        CommandUtil.put(parameters, makeParents, "--parents");
        File workingDirectory = isMove && !SystemInfo.isFileSystemCaseSensitive && FileUtil.filesEqual((File)src, (File)dst) ? CommandUtil.getHomeDirectory() : null;
        this.execute(this.myVcs, Target.on(dst), workingDirectory, CmdCopyMoveClient.getCommandName(isMove), parameters, null);
    }

    @Override
    public long copy(@NotNull Target source, @NotNull Target destination, @Nullable Revision revision, boolean makeParents, boolean isMove, @NotNull String message, @Nullable CommitEventHandler handler) throws VcsException {
        if (source == null) {
            CmdCopyMoveClient.$$$reportNull$$$0(2);
        }
        if (destination == null) {
            CmdCopyMoveClient.$$$reportNull$$$0(3);
        }
        if (message == null) {
            CmdCopyMoveClient.$$$reportNull$$$0(4);
        }
        if (!destination.isUrl()) {
            throw new IllegalArgumentException("Only urls are supported as destination " + destination);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source);
        CommandUtil.put(parameters, destination);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, makeParents, "--parents");
        parameters.add("--message");
        parameters.add(message);
        CmdCheckinClient.CommandListener listener = new CmdCheckinClient.CommandListener(handler);
        if (source.isFile()) {
            listener.setBaseDirectory(source.getFile());
        }
        this.execute(this.myVcs, source, CmdCopyMoveClient.getCommandName(isMove), parameters, (LineCommandListener)listener);
        return listener.getCommittedRevision();
    }

    @Override
    public void copy(@NotNull Target source, @NotNull File destination, @Nullable Revision revision, boolean makeParents, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            CmdCopyMoveClient.$$$reportNull$$$0(5);
        }
        if (destination == null) {
            CmdCopyMoveClient.$$$reportNull$$$0(6);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source);
        CommandUtil.put(parameters, destination);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, makeParents, "--parents");
        File workingDirectory = CommandUtil.getHomeDirectory();
        BaseUpdateCommandListener listener = new BaseUpdateCommandListener(workingDirectory, handler);
        this.execute(this.myVcs, source, workingDirectory, SvnCommandName.copy, parameters, listener);
        listener.throwWrappedIfException();
    }

    @NotNull
    private static SvnCommandName getCommandName(boolean isMove) {
        SvnCommandName svnCommandName = isMove ? SvnCommandName.move : SvnCommandName.copy;
        if (svnCommandName == null) {
            CmdCopyMoveClient.$$$reportNull$$$0(7);
        }
        return svnCommandName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/copy/CmdCopyMoveClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/copy/CmdCopyMoveClient";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

