/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5Action;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceAppletTagAction;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceFontTagAction;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithAnotherAction;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithCssAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlDeprecatedTagInspection
extends HtmlLocalInspectionTool {
    @NonNls
    private static final Set<String> ourHtmlReplacableTags = new HashSet();
    @NonNls
    private static final Set<String> ourCssReplacableTags;
    @NonNls
    private static final Set<String> ourDeprecatedTags;
    @NonNls
    private static final Set<String> ourHtml5DeprecatedTags;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.check.deprecated.tag", (Object[])new Object[0]);
        if (string == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("HtmlDeprecatedTag" == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(1);
        }
        return "HtmlDeprecatedTag";
    }

    static void registerTag(@NotNull XmlTag tag, @NotNull String message, @NotNull ProblemsHolder holder, LocalQuickFix[] fixes, @NotNull ProblemHighlightType type) {
        XmlToken endTagNameElement;
        if (tag == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(2);
        }
        if (message == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(4);
        }
        if (type == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(5);
        }
        if (fixes == null) {
            return;
        }
        XmlToken startTagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        String description = XmlBundle.message((String)message, (Object[])new Object[0]);
        if (description != null) {
            description = description + " #loc";
        }
        if (startTagNameElement != null) {
            holder.registerProblem((PsiElement)startTagNameElement, description, type, fixes);
        }
        if ((endTagNameElement = XmlTagUtil.getEndTagNameElement((XmlTag)tag)) != null) {
            holder.registerProblem((PsiElement)endTagNameElement, description, type, fixes);
        }
    }

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            HtmlDeprecatedTagInspection.$$$reportNull$$$0(7);
        }
        if (HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            LocalQuickFix[] fixes;
            String name = tag.getName().toLowerCase();
            boolean deprecated = ourDeprecatedTags.contains(name);
            boolean deprecatedInHtml5 = ourHtml5DeprecatedTags.contains(name);
            if (!deprecated && !deprecatedInHtml5) {
                return;
            }
            boolean inHtml5 = HtmlUtil.isHtml5Context((XmlElement)tag);
            if (!(inHtml5 && deprecatedInHtml5 || !inHtml5 && deprecated)) {
                return;
            }
            if (tag.getDescriptor() == null) {
                return;
            }
            if ("font".equals(name)) {
                fixes = new LocalQuickFix[]{new ReplaceFontTagAction()};
            } else if ("applet".equals(name)) {
                fixes = new LocalQuickFix[]{new ReplaceAppletTagAction()};
            } else if (ourCssReplacableTags.contains(name)) {
                fixes = new LocalQuickFix[]{new ReplaceHtmlTagWithCssAction(name)};
                if (ourHtmlReplacableTags.contains(name)) {
                    fixes = new LocalQuickFix[]{fixes[0], new ReplaceHtmlTagWithAnotherAction(name)};
                }
            } else {
                fixes = ourHtmlReplacableTags.contains(name) ? new LocalQuickFix[]{new ReplaceHtmlTagWithAnotherAction(name)} : LocalQuickFix.EMPTY_ARRAY;
            }
            if (!inHtml5 && deprecated && !deprecatedInHtml5 && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag)) {
                LocalQuickFix[] newFixes = new LocalQuickFix[fixes.length + 1];
                System.arraycopy(fixes, 0, newFixes, 0, fixes.length);
                newFixes[fixes.length] = new SwitchToHtml5Action();
                fixes = newFixes;
            }
            HtmlDeprecatedTagInspection.registerTag(tag, "html.deprecated.tag", holder, fixes, ProblemHighlightType.LIKE_DEPRECATED);
        }
    }

    static {
        ourHtmlReplacableTags.addAll(Arrays.asList("s", "strike", "u", "menu"));
        ourCssReplacableTags = new HashSet();
        ourCssReplacableTags.addAll(Arrays.asList("center", "u", "s", "strike", "xmp"));
        ourDeprecatedTags = new HashSet();
        ourDeprecatedTags.addAll(Arrays.asList("applet", "basefont", "center", "dir", "font", "frame", "frameset", "isindex", "menu", "noframes", "s", "strike", "u", "xmp"));
        ourHtml5DeprecatedTags = new HashSet();
        ourHtml5DeprecatedTags.addAll(Arrays.asList("acronym", "applet", "basefont", "big", "center", "dir", "font", "frame", "frameset", "hgroup", "isindex", "noframes", "strike", "tt"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlDeprecatedTagInspection";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlDeprecatedTagInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerTag";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

