/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.intention;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.intention.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Intention
implements IntentionAction {
    private final PsiElementPredicate predicate = this.getElementPredicate();

    protected Intention() {
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        if (project == null) {
            Intention.$$$reportNull$$$0(0);
        }
        if ((element = this.findMatchingElement(file, editor)) == null) {
            return;
        }
        this.processIntention(element, editor);
    }

    protected void processIntention(@NotNull PsiElement element, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            Intention.$$$reportNull$$$0(1);
        }
        this.processIntention(element);
    }

    protected abstract void processIntention(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    protected abstract PsiElementPredicate getElementPredicate();

    @Nullable
    private PsiElement findMatchingElement(PsiFile file, Editor editor) {
        PsiElement element;
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        for (element = file.findElementAt(position); element != null && !(element instanceof PsiDirectory); element = element.getParent()) {
            if (!this.predicate.satisfiedBy(element)) continue;
            return element;
        }
        for (element = file.findElementAt(position - 1); element != null && !(element instanceof PsiDirectory); element = element.getParent()) {
            if (!this.predicate.satisfiedBy(element)) continue;
            return element;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            Intention.$$$reportNull$$$0(2);
        }
        return this.findMatchingElement(file, editor) != null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/sixrr/xrp/intention/Intention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

