/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.injection;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.jetbrains.php.injection.PhpInjectionInternalFragmentSubstProvider;
import com.jetbrains.php.joomla.injection.JDatabaseQueryInjector;
import com.jetbrains.php.joomla.injection.builder.JDatabaseQuery;
import com.jetbrains.php.joomla.injection.builder.JDbQueryAnalyzer;
import com.jetbrains.php.joomla.injection.builder.JDbQueryElement;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JoomlaInjectionInternalFragmentSubstProvider
implements PhpInjectionInternalFragmentSubstProvider {
    public Collection<Trinity<String, String, TextRange>> getInternalFragmentsSubstitutions(@NotNull Project project, @NotNull ASTNode injectionHostNode, @NotNull Trinity<String, String, TextRange> chunk, @NotNull Language language) {
        JoomlaDataService service;
        if (project == null) {
            JoomlaInjectionInternalFragmentSubstProvider.$$$reportNull$$$0(0);
        }
        if (injectionHostNode == null) {
            JoomlaInjectionInternalFragmentSubstProvider.$$$reportNull$$$0(1);
        }
        if (chunk == null) {
            JoomlaInjectionInternalFragmentSubstProvider.$$$reportNull$$$0(2);
        }
        if (language == null) {
            JoomlaInjectionInternalFragmentSubstProvider.$$$reportNull$$$0(3);
        }
        if (!(service = JoomlaDataService.getInstance(project)).isEnabled()) {
            return null;
        }
        int originalStartOffset = ((TextRange)chunk.getThird()).getStartOffset();
        if (language.getDisplayName().contains("SQL")) {
            String text = injectionHostNode.getText();
            int prefixIndex = text.indexOf("#__");
            PsiElement psi = injectionHostNode.getPsi();
            MemberReference methodReference = JoomlaInjectionInternalFragmentSubstProvider.getQueryBuilderReference(psi);
            if (prefixIndex == -1 && methodReference == null) {
                return null;
            }
            String queryBuilderPrefix = "";
            String queryBuilderSuffix = "";
            if (methodReference instanceof MethodReference) {
                queryBuilderPrefix = JoomlaInjectionInternalFragmentSubstProvider.generatePrefix(methodReference);
                queryBuilderSuffix = JoomlaInjectionInternalFragmentSubstProvider.generateSuffix(methodReference);
            }
            SmartList toReturn = new SmartList();
            int chunkStartOffset = 0;
            String externalPrefix = (String)chunk.first;
            while (prefixIndex >= 0) {
                toReturn.add(new Trinity((Object)(queryBuilderPrefix + externalPrefix), (Object)JoomlaDataService.getDbPrefix(project), (Object)new TextRange(chunkStartOffset, prefixIndex).shiftRight(originalStartOffset)));
                queryBuilderPrefix = "";
                externalPrefix = "";
                chunkStartOffset = prefixIndex + "#__".length();
                prefixIndex = text.indexOf("#__", chunkStartOffset);
            }
            String concatenatedSuffix = (String)chunk.second + queryBuilderSuffix;
            toReturn.add(new Trinity((Object)queryBuilderPrefix, (Object)concatenatedSuffix, (Object)TextRange.create((int)(chunkStartOffset + originalStartOffset), (int)((TextRange)chunk.getThird()).getEndOffset())));
            return toReturn;
        }
        return null;
    }

    private static MemberReference getQueryBuilderReference(PsiElement psi) {
        String name;
        MethodReference memberReference;
        MemberReference methodReference = JDatabaseQueryInjector.getJDatabaseQueryUsage(psi);
        if (methodReference == null && (memberReference = JDatabaseQueryInjector.getJDatabaseDriverUsage(psi)) != null && (name = memberReference.getName()) != null && StringUtil.findIgnoreCase((String)name, (String[])new String[]{"quote", "quoteName", "qn"})) {
            methodReference = JDatabaseQueryInjector.getJDatabaseQueryUsage((PsiElement)memberReference);
        }
        return methodReference;
    }

    private static String generateSuffix(@NotNull MemberReference reference) {
        String methodName;
        if (reference == null) {
            JoomlaInjectionInternalFragmentSubstProvider.$$$reportNull$$$0(4);
        }
        if ((methodName = reference.getName()) == null) {
            return "";
        }
        JDatabaseQuery query = JDbQueryAnalyzer.INSTANCE.doQuery(reference);
        JDbQueryElement where = query.getWhere();
        JDbQueryElement from = query.getFrom();
        JDbQueryElement order = query.getOrder();
        JDbQueryElement set = query.getSet();
        List<JDbQueryElement> joins = query.getJoins();
        if (methodName.equalsIgnoreCase("select")) {
            StringBuilder queryText = new StringBuilder(" " + (from != null ? from.toString() : ""));
            queryText.append(order != null ? order.toString() : "");
            for (JDbQueryElement it : query.getJoins()) {
                queryText.append(" ").append(it.toString());
            }
            return queryText.toString();
        }
        if (methodName.equalsIgnoreCase("insert")) {
            JDbQueryElement columns = query.getColumns();
            JDbQueryElement values = query.getValues();
            return " " + (columns != null ? columns.toString() : "") + (values != null ? " values" + values.toString() : "");
        }
        if (methodName.equalsIgnoreCase("columns")) {
            return ") VALUES " + query.getValues();
        }
        if (methodName.equalsIgnoreCase("values")) {
            return ")";
        }
        if (methodName.equalsIgnoreCase("delete")) {
            return " " + (from != null ? from : "") + (where != null ? where : "") + (order != null ? order : "");
        }
        if (methodName.equalsIgnoreCase("update")) {
            return " " + (joins != null ? joins.stream().map(i -> i.toString()).collect(Collectors.joining(", ")) : "") + (set != null ? set : "") + " " + (where != null ? where : "") + " " + (order != null ? order : "");
        }
        if (methodName.equalsIgnoreCase("set")) {
            return (where != null ? where.toString() : "") + (order != null ? order : "");
        }
        return "";
    }

    private static String generatePrefix(@NotNull MemberReference memberReference) {
        String methodName;
        if (memberReference == null) {
            JoomlaInjectionInternalFragmentSubstProvider.$$$reportNull$$$0(5);
        }
        if ((methodName = memberReference.getName()) == null) {
            return "";
        }
        JDatabaseQuery query = JDbQueryAnalyzer.INSTANCE.doQuery(memberReference);
        JDbQueryElement select = query.getSelect();
        JDbQueryElement delete = query.getDelete();
        JDbQueryElement from = query.getFrom();
        JDbQueryElement where = query.getWhere();
        JDbQueryElement insert = query.getInsert();
        JDbQueryElement columns = query.getColumns();
        JDbQueryElement update = query.getUpdate();
        List<JDbQueryElement> joins = query.getJoins();
        if (methodName.equalsIgnoreCase("from")) {
            return (select != null ? select : "") + " FROM ";
        }
        if (methodName.equalsIgnoreCase("columns")) {
            if (insert != null) {
                return insert + "(";
            }
            return "(";
        }
        if (methodName.equalsIgnoreCase("values")) {
            if (insert != null && columns != null) {
                return insert + " " + columns + " VALUES (";
            }
            return "(";
        }
        if (methodName.equalsIgnoreCase("select")) {
            return "SELECT ";
        }
        if (methodName.equalsIgnoreCase("insert")) {
            return "INSERT INTO ";
        }
        if (methodName.equalsIgnoreCase("delete")) {
            return "DELETE ";
        }
        if (methodName.equalsIgnoreCase("where")) {
            String answer = JoomlaInjectionInternalFragmentSubstProvider.getType(select, delete, insert, update);
            return answer + (from != null ? from.toString() : "") + " where ";
        }
        if (methodName.equalsIgnoreCase("order")) {
            String answer = JoomlaInjectionInternalFragmentSubstProvider.getType(select, delete, insert, update);
            answer = answer + (from != null ? from.toString() : "") + (where != null ? where.toString() : "") + " order by ";
            return answer;
        }
        if (methodName.equalsIgnoreCase("group")) {
            String answer = "";
            if (select != null) {
                answer = answer + select.toString();
            }
            answer = answer + (from != null ? from.toString() : "") + (joins != null ? joins.stream().map(i -> i.toString()).collect(Collectors.joining(", ")) : "") + (where != null);
            return answer;
        }
        if (methodName.equalsIgnoreCase("update")) {
            return "update ";
        }
        if (methodName.equalsIgnoreCase("set")) {
            if (insert != null) {
                return insert.toString() + " set ";
            }
            if (update != null) {
                return update.toString() + " set ";
            }
        }
        return "";
    }

    @NotNull
    private static String getType(JDbQueryElement select, JDbQueryElement delete, JDbQueryElement insert, JDbQueryElement update) {
        String answer = "";
        if (select != null) {
            answer = answer + select.toString();
        } else if (insert != null) {
            answer = answer + insert;
        } else if (delete != null) {
            answer = answer + delete;
        } else if (update != null) {
            answer = answer + update;
        }
        String string = answer;
        if (string == null) {
            JoomlaInjectionInternalFragmentSubstProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHostNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/joomla/injection/JoomlaInjectionInternalFragmentSubstProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/joomla/injection/JoomlaInjectionInternalFragmentSubstProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInternalFragmentsSubstitutions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateSuffix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePrefix";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

