/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.service;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCacheImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.angular2.lang.Angular2LangUtil;
import org.angular2.lang.html.Angular2HtmlFileType;
import org.angular2.service.protocol.Angular2LanguageServiceProtocol;
import org.angular2.service.protocol.command.Angular2CompletionsCommand;
import org.angular2.service.protocol.command.Angular2GetHtmlErrCommand;
import org.angular2.service.protocol.command.Angular2GetProjectHtmlErrCommand;
import org.angular2.settings.AngularSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2LanguageService
extends TypeScriptServerServiceImpl {
    private static final ParameterizedCachedValueProvider<Collection<VirtualFile>, Project> CACHE_SERVICE_PATH_PROVIDER = project -> {
        Collection<VirtualFile> result = Angular2LanguageService.findServiceDirectoriesImpl(project);
        return CachedValueProvider.Result.create(result, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
    };
    public static final Key<ParameterizedCachedValue<Collection<VirtualFile>, Project>> NG_SERVICE_PATH_KEY = Key.create((String)"CACHED_NG_SERVICE_PATH");
    private final Condition<VirtualFile> myFileFilter;

    public Angular2LanguageService(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            Angular2LanguageService.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            Angular2LanguageService.$$$reportNull$$$0(1);
        }
        super(project, settings, "Angular Console");
        this.myFileFilter = Conditions.or((Condition)super.getAcceptableFilesFilter(), el -> {
            if (el != null && el.isInLocalFileSystem() && Angular2LanguageService.isAcceptableFile(el)) {
                VirtualFile config = TypeScriptConfigUtil.getNearestParentConfig((VirtualFile)el);
                return config != null;
            }
            return false;
        });
    }

    @Nullable
    protected JSLanguageServiceProtocol createProtocol(Consumer<?> readyConsumer, @NotNull String tsServicePath) {
        if (tsServicePath == null) {
            Angular2LanguageService.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile directory = Angular2LanguageService.getServiceDirectory(this.myProject);
        if (directory == null) {
            return null;
        }
        String path = directory.getCanonicalPath();
        if (path == null) {
            return null;
        }
        return new Angular2LanguageServiceProtocol(this.myProject, path, this.mySettings, readyConsumer, (Consumer<JSLanguageServiceAnswer>)this.createEventConsumer(), tsServicePath);
    }

    public static VirtualFile getServiceDirectory(@NotNull Project project) {
        Collection result;
        if (project == null) {
            Angular2LanguageService.$$$reportNull$$$0(3);
        }
        return (result = (Collection)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)project, NG_SERVICE_PATH_KEY, CACHE_SERVICE_PATH_PROVIDER, false, (Object)project)).size() == 1 ? (VirtualFile)ContainerUtil.getFirstItem((Collection)result) : null;
    }

    @NotNull
    private static Collection<VirtualFile> findServiceDirectoriesImpl(@NotNull Project project) {
        if (project == null) {
            Angular2LanguageService.$$$reportNull$$$0(4);
        }
        if (project.isDefault() || project.isDisposed()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                Angular2LanguageService.$$$reportNull$$$0(5);
            }
            return list;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                Angular2LanguageService.$$$reportNull$$$0(6);
            }
            return list;
        }
        VirtualFile rootService = Angular2LanguageService.searchInRootDirectory(baseDir);
        if (rootService != null) {
            Set<VirtualFile> set = Collections.singleton(rootService);
            if (set == null) {
                Angular2LanguageService.$$$reportNull$$$0(7);
            }
            return set;
        }
        Collection configFiles = TypeScriptConfigService.Provider.getConfigFiles((Project)project);
        if (configFiles.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                Angular2LanguageService.$$$reportNull$$$0(8);
            }
            return list;
        }
        Collection collection = configFiles.stream().map(el -> el.getConfigDirectory()).map(dir -> Angular2LanguageService.searchInRootDirectory(dir)).filter(el -> el != null).collect(Collectors.toList());
        if (collection == null) {
            Angular2LanguageService.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Nullable
    private static VirtualFile searchInRootDirectory(@NotNull VirtualFile file) {
        VirtualFile serviceDirectory;
        VirtualFile angularPackage;
        VirtualFile modules;
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(10);
        }
        if (file.isInLocalFileSystem() && file.isDirectory() && (modules = file.findChild("node_modules")) != null && (angularPackage = modules.findChild("@angular")) != null && (serviceDirectory = angularPackage.findChild("language-service")) != null) {
            return serviceDirectory;
        }
        return null;
    }

    @NotNull
    protected Collection<JSLanguageServiceCacheableCommand> createGetErrCommand(@NotNull VirtualFile file, @NotNull String path) {
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(11);
        }
        if (path == null) {
            Angular2LanguageService.$$$reportNull$$$0(12);
        }
        if (Angular2LanguageService.isAcceptableFile(file)) {
            String configFile = this.getConfigForFile(file);
            if (configFile == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    Angular2LanguageService.$$$reportNull$$$0(13);
                }
                return list;
            }
            Angular2GetHtmlErrCommand error = new Angular2GetHtmlErrCommand(path);
            ((TypeScriptFileWithConfigArgs)error.arguments).projectFileName = LocalFilePath.create((String)configFile);
            List<JSLanguageServiceCacheableCommand> list = Collections.singletonList(error);
            if (list == null) {
                Angular2LanguageService.$$$reportNull$$$0(14);
            }
            return list;
        }
        Collection collection = super.createGetErrCommand(file, path);
        if (collection == null) {
            Angular2LanguageService.$$$reportNull$$$0(15);
        }
        return collection;
    }

    private static boolean isAcceptableFile(@NotNull VirtualFile file) {
        FileType type;
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(16);
        }
        return (type = file.getFileType()) == Angular2HtmlFileType.INSTANCE || type == HtmlFileType.INSTANCE;
    }

    public boolean canHighlight(@NotNull PsiFile file) {
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(17);
        }
        if (file instanceof HtmlFileImpl) {
            return TypeScriptLanguageServiceAnnotatorCheckerProvider.checkServiceIsAvailable((Project)this.myProject, (JSLanguageServiceBase)this, (TypeScriptCompilerSettings)this.mySettings);
        }
        return super.canHighlight(file);
    }

    @NotNull
    protected String getProcessName() {
        if ("Angular" == null) {
            Angular2LanguageService.$$$reportNull$$$0(18);
        }
        return "Angular";
    }

    @NotNull
    public Condition<VirtualFile> getAcceptableFilesFilter() {
        Condition<VirtualFile> condition = this.myFileFilter;
        if (condition == null) {
            Angular2LanguageService.$$$reportNull$$$0(19);
        }
        return condition;
    }

    @NotNull
    protected JSLanguageServiceSimpleCommand createCompletionCommand(@NotNull TypeScriptCompletionsRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull PsiFile file) {
        if (args == null) {
            Angular2LanguageService.$$$reportNull$$$0(20);
        }
        if (virtualFile == null) {
            Angular2LanguageService.$$$reportNull$$$0(21);
        }
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(22);
        }
        Angular2CompletionsCommand angular2CompletionsCommand = file instanceof XmlFile || virtualFile.getFileType() instanceof XmlLikeFileType ? new Angular2CompletionsCommand(args) : super.createCompletionCommand(args, virtualFile, file);
        if (angular2CompletionsCommand == null) {
            Angular2LanguageService.$$$reportNull$$$0(23);
        }
        return angular2CompletionsCommand;
    }

    @NotNull
    protected JSLanguageServiceCommand createProjectCommand(@NotNull VirtualFile file, @NotNull String path) {
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(24);
        }
        if (path == null) {
            Angular2LanguageService.$$$reportNull$$$0(25);
        }
        Angular2GetProjectHtmlErrCommand angular2GetProjectHtmlErrCommand = Angular2LanguageService.isAcceptableFile(file) ? new Angular2GetProjectHtmlErrCommand(path) : super.createProjectCommand(file, path);
        if (angular2GetProjectHtmlErrCommand == null) {
            Angular2LanguageService.$$$reportNull$$$0(26);
        }
        return angular2GetProjectHtmlErrCommand;
    }

    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        TypeScriptCompilerService defaultService = TypeScriptCompilerService.getDefaultService((Project)this.myProject);
        if (defaultService.isServiceCreated()) {
            JSLanguageServiceQueue.LOGGER.info("Dispose default service by " + this.getProcessName());
            TransactionGuard.submitTransaction((Disposable)this, () -> defaultService.terminateStartedProcess(false, true));
        }
        return super.createLanguageServiceQueue();
    }

    @NotNull
    protected TypeScriptLanguageServiceCacheImpl createLSCache() {
        TypeScriptLanguageServiceCacheImpl typeScriptLanguageServiceCacheImpl = new TypeScriptLanguageServiceCacheImpl(this.myProject){

            @Nullable
            protected TypeScriptConfig getConfigForFile(VirtualFile virtualFile) {
                if (Angular2LanguageService.isAcceptableFile(virtualFile)) {
                    VirtualFile tsFile = Angular2LanguageService.findSiblingTsFile(virtualFile);
                    if (tsFile != null) {
                        return super.getConfigForFile(tsFile);
                    }
                    return Angular2LanguageService.this.getNearestConfig(virtualFile);
                }
                return super.getConfigForFile(virtualFile);
            }
        };
        if (typeScriptLanguageServiceCacheImpl == null) {
            Angular2LanguageService.$$$reportNull$$$0(27);
        }
        return typeScriptLanguageServiceCacheImpl;
    }

    @Nullable
    protected String getConfigForFile(@NotNull VirtualFile file) {
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(28);
        }
        if (Angular2LanguageService.isAcceptableFile(file)) {
            return (String)ReadAction.compute(() -> {
                if (file == null) {
                    Angular2LanguageService.$$$reportNull$$$0(35);
                }
                if (this.myProject.isDisposed()) {
                    return null;
                }
                VirtualFile tsFile = Angular2LanguageService.findSiblingTsFile(file);
                if (tsFile != null) {
                    return super.getConfigForFile(tsFile);
                }
                TypeScriptConfig config = this.getNearestConfig(file);
                return config == null ? null : TypeScriptCompilerConfigUtil.normalizeNameAndPath((VirtualFile)config.getConfigFile());
            });
        }
        return super.getConfigForFile(file);
    }

    private TypeScriptConfig getNearestConfig(@NotNull VirtualFile file) {
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(29);
        }
        Collection allConfigs = TypeScriptConfigService.Provider.getConfigFiles((Project)this.myProject);
        return TypeScriptConfigUtil.getNearestParentConfig((VirtualFile)file, (Collection)allConfigs);
    }

    @Nullable
    private static VirtualFile findSiblingTsFile(@NotNull VirtualFile file) {
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(30);
        }
        VirtualFile parent = file.getParent();
        String nameWithoutExtension = file.getNameWithoutExtension();
        return parent.findChild(nameWithoutExtension + ".ts");
    }

    public static boolean isEnabledAngularService(@NotNull PsiElement element) {
        if (element == null) {
            Angular2LanguageService.$$$reportNull$$$0(31);
        }
        return Angular2LanguageService.isEnabledAngularService(element.getProject()) && Angular2LangUtil.isAngular2Context(element);
    }

    public static boolean isEnabledAngularService(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(32);
        }
        return Angular2LanguageService.isEnabledAngularService(project) && Angular2LangUtil.isAngular2Context(project, file);
    }

    private static boolean isEnabledAngularService(Project project) {
        return AngularSettings.get(project).isUseService() && TypeScriptCompilerSettings.getSettings((Project)project).getVersionType() != TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED && Angular2LanguageService.getServiceDirectory(project) != null;
    }

    @Nullable
    public TypeScriptServerServiceSettings getServiceSettings() {
        return AngularSettings.get(this.myProject);
    }

    @NotNull
    protected List<JSAnnotationError> parseGetErrorResult(@NotNull JSLanguageServiceAnswer answer, String path) {
        if (answer == null) {
            Angular2LanguageService.$$$reportNull$$$0(33);
        }
        List<JSAnnotationError> list = super.parseGetErrorResult(answer, path).stream().filter(error -> !error.getDescription().startsWith("ng: Parser Error:")).collect(Collectors.toList());
        if (list == null) {
            Angular2LanguageService.$$$reportNull$$$0(34);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsServicePath";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/service/Angular2LanguageService";
                break;
            }
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/service/Angular2LanguageService";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findServiceDirectoriesImpl";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetErrCommand";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptableFilesFilter";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionCommand";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectCommand";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createLSCache";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGetErrorResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProtocol";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServiceDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findServiceDirectoriesImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 34: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "searchInRootDirectory";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createGetErrCommand";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canHighlight";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionCommand";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createProjectCommand";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getNearestConfig";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingTsFile";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledAngularService";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parseGetErrorResult";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConfigForFile$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 23: 
            case 26: 
            case 27: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

