/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag xmlTag) {
        if (xmlTag != null) {
            PsiElement declaration;
            Project project = xmlTag.getProject();
            if (!AngularIndexUtil.hasAngularJS(xmlTag.getProject())) {
                return XmlAttributeDescriptor.EMPTY;
            }
            LinkedHashMap<String, XmlAttributeDescriptor> result = new LinkedHashMap<String, XmlAttributeDescriptor>();
            Collection<String> directives = AngularIndexUtil.getAllKeys(AngularDirectivesIndex.KEY, project);
            Collection<String> docDirectives = AngularIndexUtil.getAllKeys(AngularDirectivesDocIndex.KEY, project);
            for (String directiveName : docDirectives) {
                declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, directiveName, xmlTag, AngularDirectivesDocIndex.KEY);
                if (!AngularJSAttributeDescriptorsProvider.isApplicable(declaration)) continue;
                this.addAttributes(project, result, directiveName, declaration);
            }
            for (String directiveName : directives) {
                if (docDirectives.contains(directiveName) || !AngularJSAttributeDescriptorsProvider.isApplicable(declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, directiveName, xmlTag, AngularDirectivesIndex.KEY))) continue;
                this.addAttributes(project, result, directiveName, declaration);
            }
            return result.values().toArray(XmlAttributeDescriptor.EMPTY);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    protected void addAttributes(@Nullable Project project, @NotNull Map<String, XmlAttributeDescriptor> result, @NotNull String directiveName, @NotNull PsiElement declaration) {
        if (result == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(0);
        }
        if (directiveName == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(1);
        }
        if (declaration == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(2);
        }
        result.put(directiveName, (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, DirectiveUtil.getAttributeName(directiveName), declaration));
        if ("ngRepeat".equals(directiveName)) {
            result.put("ngRepeatStart", (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, "ng-repeat-start", declaration));
            result.put("ngRepeatEnd", (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, "ng-repeat-end", declaration));
        }
    }

    private static PsiElement applicableDirective(@NotNull Project project, @NotNull String directiveName, @NotNull XmlTag tag, @NotNull StubIndexKey<String, JSImplicitElementProvider> index) {
        if (project == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(3);
        }
        if (directiveName == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(4);
        }
        if (tag == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(5);
        }
        if (index == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(6);
        }
        Ref result = Ref.create((Object)PsiUtilCore.NULL_PSI_ELEMENT);
        AngularIndexUtil.multiResolve(project, index, directiveName, (Processor<? super JSImplicitElement>)((Processor)directive -> {
            if (project == null) {
                AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(10);
            }
            if (tag == null) {
                AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(11);
            }
            if (directive == null || !"adi".equals(directive.getUserString()) && !"addi".equals(directive.getUserString())) {
                return true;
            }
            if (AngularJSAttributeDescriptorsProvider.isApplicable(project, tag, directive)) {
                result.set(directive);
                return false;
            }
            result.set(null);
            return true;
        }));
        return (PsiElement)result.get();
    }

    private static boolean isApplicable(@NotNull Project project, @NotNull XmlTag tag, @NotNull JSImplicitElement directive) {
        String restrictions;
        if (project == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(7);
        }
        if (tag == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(8);
        }
        if (directive == null) {
            AngularJSAttributeDescriptorsProvider.$$$reportNull$$$0(9);
        }
        if ((restrictions = directive.getTypeString()) != null) {
            String[] split = restrictions.split(";", -1);
            String restrict = AngularIndexUtil.convertRestrictions(project, split[0]);
            String requiredTagAndAttr = split[1];
            if (!StringUtil.isEmpty((String)restrict) && !StringUtil.containsIgnoreCase((String)restrict, (String)"A")) {
                return false;
            }
            if (!AngularJSAttributeDescriptorsProvider.tagAndAttrMatches(tag, requiredTagAndAttr)) {
                return false;
            }
        }
        return true;
    }

    private static boolean tagAndAttrMatches(XmlTag tag, String requiredTagAndDirective) {
        List tagAndDirectiveSplit = StringUtil.split((String)requiredTagAndDirective, (String)"=");
        if (tagAndDirectiveSplit.isEmpty()) {
            return true;
        }
        if (!AngularJSAttributeDescriptorsProvider.tagMatches(tag, (String)tagAndDirectiveSplit.get(0))) {
            return false;
        }
        if (tagAndDirectiveSplit.size() == 1) {
            return true;
        }
        String requiredAttr = ((String)tagAndDirectiveSplit.get(1)).trim();
        if (requiredAttr.isEmpty()) {
            return true;
        }
        for (XmlAttribute attr : tag.getAttributes()) {
            if (!requiredAttr.equals(DirectiveUtil.normalizeAttributeName(attr.getName()))) continue;
            return true;
        }
        return false;
    }

    private static boolean tagMatches(XmlTag tag, String requiredTag) {
        if (StringUtil.isEmpty((String)requiredTag) || StringUtil.equalsIgnoreCase((CharSequence)requiredTag, (CharSequence)"ANY")) {
            return true;
        }
        String normalizedTag = DirectiveUtil.normalizeAttributeName(tag.getName());
        for (String s : StringUtil.split((String)requiredTag, (String)",")) {
            String requirement = s.trim();
            if (!StringUtil.equals((CharSequence)normalizedTag, (CharSequence)requirement) && !StringUtil.equalsIgnoreCase((CharSequence)tag.getName(), (CharSequence)requirement)) continue;
            return true;
        }
        if ("input".equalsIgnoreCase(requiredTag)) {
            XmlTag parent = tag;
            while (parent != null && !(parent instanceof PsiFile)) {
                if (!((parent = parent.getParent()) instanceof XmlTag) || !AngularJSAttributeDescriptorsProvider.isForm(parent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isForm(XmlTag parent) {
        String name = parent.getName();
        return "form".equalsIgnoreCase(name) || DirectiveUtil.normalizeAttributeName(name).equals("ngForm");
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attrName, XmlTag xmlTag) {
        return AngularJSAttributeDescriptorsProvider.getDescriptor(attrName, xmlTag);
    }

    static XmlAttributeDescriptor getDescriptor(String attrName, XmlTag xmlTag) {
        if (xmlTag != null) {
            Project project = xmlTag.getProject();
            if (!AngularIndexUtil.hasAngularJS(xmlTag.getProject())) {
                return null;
            }
            String directiveName = DirectiveUtil.normalizeAttributeName(attrName);
            PsiElement declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, directiveName, xmlTag, AngularDirectivesDocIndex.KEY);
            if (declaration == PsiUtilCore.NULL_PSI_ELEMENT) {
                declaration = AngularJSAttributeDescriptorsProvider.applicableDirective(project, directiveName, xmlTag, AngularDirectivesIndex.KEY);
            }
            if (AngularJSAttributeDescriptorsProvider.isApplicable(declaration)) {
                return AngularAttributesRegistry.createDescriptor(project, attrName, declaration);
            }
        }
        return null;
    }

    private static boolean isApplicable(PsiElement declaration) {
        return declaration != null && declaration != PsiUtilCore.NULL_PSI_ELEMENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
        }
        objectArray2[1] = "org/angularjs/codeInsight/attributes/AngularJSAttributeDescriptorsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addAttributes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "applicableDirective";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$applicableDirective$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

