/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.hooks;

import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.hooks.DrupalHookIndexDescription;
import com.jetbrains.php.drupal.hooks.DrupalHookInvocationMethod;
import com.jetbrains.php.drupal.hooks.DrupalHooksIndex;
import com.jetbrains.php.drupal.hooks.DrupalHooksUtils;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import icons.DrupalIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrupalHookImplLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            DrupalHookImplLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            DrupalHookImplLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            DrupalHookImplLineMarkerProvider.$$$reportNull$$$0(2);
        }
        HashMap moduleNamesCache = new HashMap();
        for (PsiElement element : elements) {
            DrupalHookImplLineMarkerProvider.handlePotentialHook(element, result, (Map<VirtualFile, String>)moduleNamesCache);
        }
    }

    private static void handlePotentialHook(PsiElement element, Collection<LineMarkerInfo> result, @NotNull Map<VirtualFile, String> moduleNamesCache) {
        String hookName;
        if (moduleNamesCache == null) {
            DrupalHookImplLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((hookName = DrupalHooksUtils.getPotentialHookName(element, moduleNamesCache)) == null) {
            return;
        }
        DrupalDataService dataService = DrupalDataService.getInstance(element.getProject());
        if (!dataService.isEnabled() || !dataService.isVersionValid()) {
            return;
        }
        HashSet<DrupalHookIndexDescription> descriptions = new HashSet<DrupalHookIndexDescription>();
        for (DrupalVersion version : dataService.getVersion().getSmallerOfEqual()) {
            descriptions.add(new DrupalHookIndexDescription(hookName, version));
        }
        HashSet filesWithKeys = new HashSet();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)element.getProject());
        for (DrupalHookIndexDescription drupalHookIndexDescription : descriptions) {
            filesWithKeys.addAll(FileBasedIndex.getInstance().getContainingFiles(DrupalHooksIndex.KEY, (Object)drupalHookIndexDescription, scope));
        }
        MyHooksInvocationCollector visitor = new MyHooksInvocationCollector(hookName, dataService.getVersion());
        for (VirtualFile vFile : filesWithKeys) {
            PsiFile file = element.getManager().findFile(vFile);
            if (file == null) continue;
            file.accept((PsiElementVisitor)visitor);
        }
        Function function = DrupalHooksUtils.getDescriptiveFunctionByHookName(hookName, element.getProject());
        if (function == null && visitor.myInvocations.isEmpty()) {
            return;
        }
        ArrayList<Function> destinations = new ArrayList<Function>();
        if (function != null) {
            destinations.add(function);
        }
        destinations.addAll(visitor.myInvocations);
        String title = function == null ? DrupalBundle.message("drupal.choose.invocation.of.hook.0", hookName) : DrupalBundle.message("drupal.choose.invocation.or.doc.of.hook.0", hookName);
        PsiElement anchor = PsiTreeUtil.getDeepestFirst((PsiElement)element);
        result.add(new LineMarkerInfo(anchor, anchor.getTextRange(), DrupalIcons.ImplementingHook, 11, (com.intellij.util.Function)new OverriddenHookTooltipGenerator(visitor.myInvocations, function), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler(destinations, title), GutterIconRenderer.Alignment.LEFT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNamesCache";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/drupal/hooks/DrupalHookImplLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handlePotentialHook";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class OverriddenHookTooltipGenerator
    implements com.intellij.util.Function<PsiElement, String> {
        private final List<FunctionReference> myInvocations;
        @Nullable
        private final Function myDoc;

        private OverriddenHookTooltipGenerator(List<FunctionReference> invocations, @Nullable Function doc) {
            this.myInvocations = invocations;
            this.myDoc = doc;
        }

        public String fun(PsiElement __) {
            PsiFile file;
            if (this.myInvocations.size() > 6) {
                return this.myDoc != null ? DrupalBundle.message("drupal.has.invocations.or.docs", new Object[0]) : DrupalBundle.message("drupal.has.invocations", new Object[0]);
            }
            StringBuilder sb = new StringBuilder();
            String beginning = this.myDoc != null && this.myInvocations.isEmpty() ? DrupalBundle.message("drupal.is.documented.in", new Object[0]) : (this.myDoc == null && !this.myInvocations.isEmpty() ? DrupalBundle.message("drupal.is.invoked.in", new Object[0]) : DrupalBundle.message("drupal.is.invoked.or.documented.in", new Object[0]));
            sb.append(beginning).append("<br/>");
            HashSet<String> fileNames = new HashSet<String>();
            boolean hasRealInvocations = false;
            if (this.myDoc != null && (file = this.myDoc.getContainingFile()) != null) {
                String fileName = file.getName();
                sb.append(" '").append(fileName).append("'").append("<br/>");
                fileNames.add(fileName);
                hasRealInvocations = true;
            }
            for (FunctionReference invocation : this.myInvocations) {
                PsiFile file2 = invocation.getContainingFile();
                if (file2 == null) continue;
                String fileName = file2.getName();
                if (!fileNames.contains(fileName)) {
                    sb.append(" '").append(fileName).append("'").append("<br/>");
                    fileNames.add(fileName);
                }
                hasRealInvocations = true;
            }
            return hasRealInvocations ? sb.toString() : DrupalBundle.message("drupal.has.invocations", new Object[0]);
        }
    }

    private static class MyHooksInvocationCollector
    extends PhpRecursiveElementVisitor {
        private final List<FunctionReference> myInvocations = new ArrayList<FunctionReference>();
        private final String myHookName;
        private final DrupalVersion myVersion;

        private MyHooksInvocationCollector(String hookName, DrupalVersion version) {
            this.myHookName = hookName;
            this.myVersion = version;
        }

        public void visitPhpFunctionCall(FunctionReference reference) {
            super.visitPhpFunctionCall(reference);
            this.check(reference);
        }

        public void visitPhpMethodReference(MethodReference reference) {
            super.visitPhpMethodReference(reference);
            this.check((FunctionReference)reference);
        }

        private void check(FunctionReference reference) {
            DrupalHookInvocationMethod currentMethod = this.myVersion.findMethod(reference, true);
            if (currentMethod == null || !currentMethod.mayBeInvokedBy(this.myHookName)) {
                return;
            }
            String[] currentParameter = currentMethod.getHookNamesFromInvocation(reference);
            if (currentParameter != null && ArrayUtil.contains((String)this.myHookName, (String[])currentParameter)) {
                this.myInvocations.add(reference);
            }
        }
    }
}

