/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.settings;

import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalUtil;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrupalSettingsPanel
extends JPanel {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myDrupalPathField;
    private JComboBox<DrupalVersion> myVersionComboBox;
    private JPanel myErrorPanel;
    private JBCheckBox mySetupIncludePathCheckBox;
    private FacetErrorPanel myFacetErrorPanel;
    private boolean myEnabled;

    public DrupalSettingsPanel(@Nullable Project project, boolean internalValidation) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.add(this.myMainPanel);
        EnumComboBoxModel model = new EnumComboBoxModel(DrupalVersion.class);
        this.myVersionComboBox.setModel((ComboBoxModel<DrupalVersion>)model);
        this.myVersionComboBox.setRenderer((ListCellRenderer<DrupalVersion>)new ListCellRendererWrapper<DrupalVersion>(){

            public void customize(JList list, DrupalVersion value, int index, boolean selected, boolean hasFocus) {
                String text = "";
                if (value != null) {
                    text = String.valueOf(value.getNumber());
                }
                this.setText(text);
            }
        });
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> browseFolderListener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(DrupalBundle.message("drupal.select.drupal.directory", new Object[0]), DrupalBundle.message("drupal.select.drupal.root.directory", new Object[0]), (ComponentWithBrowseButton)this.myDrupalPathField, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                String lastSavedPath;
                String directoryName = this.getComponentText();
                if (!StringUtil.isEmptyOrSpaces((String)directoryName) && !StringUtil.isEmptyOrSpaces((String)(lastSavedPath = DrupalDataService.getLastDrupalPath()))) {
                    lastSavedPath = FileUtil.toSystemIndependentName((String)lastSavedPath);
                    return LocalFileSystem.getInstance().findFileByPath(lastSavedPath);
                }
                return super.getInitialFile();
            }
        };
        this.myDrupalPathField.addActionListener((ActionListener)browseFolderListener);
        this.myEnabled = this.isEnabled();
        if (internalValidation) {
            this.initErrorValidation();
        }
    }

    private void initErrorValidation() {
        this.myFacetErrorPanel = new FacetErrorPanel();
        this.myErrorPanel.add((Component)this.myFacetErrorPanel.getComponent(), "Center");
        this.myFacetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                String result = DrupalSettingsPanel.this.getValidationMessage();
                if (result != null) {
                    ValidationResult validationResult = new ValidationResult(result);
                    if (validationResult == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return validationResult;
                }
                ValidationResult validationResult = ValidationResult.OK;
                if (validationResult == null) {
                    3.$$$reportNull$$$0(1);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/drupal/settings/DrupalSettingsPanel$3", "check"));
            }
        }, new JComponent[]{this.myDrupalPathField.getTextField(), this.myVersionComboBox});
        this.myFacetErrorPanel.getValidatorsManager().validate();
    }

    @Nullable
    public String getValidationMessage() {
        if (!this.myEnabled) {
            return null;
        }
        Object selectedItem = this.myVersionComboBox.getSelectedItem();
        if (!(selectedItem instanceof DrupalVersion)) {
            return DrupalBundle.message("drupal.please.choose.drupal.version", new Object[0]);
        }
        String result = DrupalUtil.validateDrupalFolder(this.myDrupalPathField.getText(), (DrupalVersion)((Object)selectedItem));
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myEnabled = enabled;
        if (this.myFacetErrorPanel != null) {
            this.myFacetErrorPanel.getValidatorsManager().validate();
        }
    }

    public boolean isModified(DrupalDataService service) {
        if (!Comparing.strEqual((String)this.myDrupalPathField.getText(), (String)service.getDrupalPath())) {
            return true;
        }
        DrupalVersion oldVersion = service.getVersion();
        DrupalVersion currentVersion = (DrupalVersion)((Object)this.myVersionComboBox.getSelectedItem());
        if (oldVersion == null && currentVersion == null) {
            return false;
        }
        if (oldVersion != currentVersion) {
            return true;
        }
        return service.isUpdateIncludePath() != this.mySetupIncludePathCheckBox.isSelected();
    }

    public void apply(DrupalDataService.State state) {
        DrupalVersion version = (DrupalVersion)((Object)this.myVersionComboBox.getSelectedItem());
        state.setDrupalPathVersionAndUpdateLastUsed(this.myDrupalPathField.getText(), version);
        state.setUpdateIncludePath(this.mySetupIncludePathCheckBox.isSelected());
    }

    public void reset(DrupalDataService service) {
        this.myDrupalPathField.setText(service.getDrupalPath());
        this.myVersionComboBox.setSelectedItem((Object)service.getVersion());
        this.mySetupIncludePathCheckBox.setSelected(service.isUpdateIncludePath());
    }

    public void addComponentChangesListener(final Runnable listener) {
        this.myDrupalPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                listener.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/drupal/settings/DrupalSettingsPanel$4", "textChanged"));
            }
        });
        this.myVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.run();
            }
        });
    }

    public void setDrupalDir(@Nullable String path) {
        this.myDrupalPathField.setText(path);
    }

    public void setDrupalVersion(@Nullable DrupalVersion version) {
        if (version != null) {
            this.myVersionComboBox.setSelectedItem((Object)version);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        ComboBox comboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDrupalPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Drupal installation path:");
        jBLabel.setDisplayedMnemonic('P');
        jBLabel.setDisplayedMnemonicIndex(20);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myVersionComboBox = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, new Dimension(50, -1), null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Version:");
        jBLabel2.setDisplayedMnemonic('V');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.mySetupIncludePathCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("Set up PHP | Include paths");
        jBCheckBox.setMnemonic('I');
        jBCheckBox.setDisplayedMnemonicIndex(13);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel2.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

