/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileIndexFacade {
    protected final Project myProject;

    protected FileIndexFacade(Project project) {
        this.myProject = project;
    }

    public static FileIndexFacade getInstance(Project project) {
        return ServiceManager.getService(project, FileIndexFacade.class);
    }

    public abstract boolean isInContent(@NotNull VirtualFile var1);

    public abstract boolean isInSource(@NotNull VirtualFile var1);

    public abstract boolean isInSourceContent(@NotNull VirtualFile var1);

    public abstract boolean isInLibraryClasses(@NotNull VirtualFile var1);

    public abstract boolean isInLibrarySource(@NotNull VirtualFile var1);

    public abstract boolean isExcludedFile(@NotNull VirtualFile var1);

    public abstract boolean isUnderIgnored(@NotNull VirtualFile var1);

    @Nullable
    public abstract Module getModuleForFile(@NotNull VirtualFile var1);

    public abstract boolean isValidAncestor(@NotNull VirtualFile var1, @NotNull VirtualFile var2);

    public boolean shouldBeFound(GlobalSearchScope scope, VirtualFile virtualFile2) {
        return scope.isSearchOutsideRootModel() || this.isInContent(virtualFile2) || this.isInLibrarySource(virtualFile2);
    }

    @NotNull
    public abstract ModificationTracker getRootModificationTracker();

    @NotNull
    public abstract Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions();

    public boolean isInProjectScope(@NotNull VirtualFile file) {
        if (file == null) {
            FileIndexFacade.$$$reportNull$$$0(0);
        }
        if (file instanceof VirtualFileWindow) {
            return true;
        }
        if (this.isInLibraryClasses(file) && !this.isInSourceContent(file)) {
            return false;
        }
        return this.isInContent(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/FileIndexFacade", "isInProjectScope"));
    }
}

