/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<JSArgumentList, JSFunctionWithSubstitutor, JSExpression> {
    private static final Set<Class> ourArgumentListAllowedParentClassesSet = ContainerUtil.newHashSet((Object[])new Class[]{JSCallExpression.class});
    private static final Set<Class> ourStopSearch = Collections.singleton(JSFunction.class);
    private static final int MAX_CANCELED_RETRY_COUNT = 5;

    public boolean couldShowInLookup() {
        return true;
    }

    @NotNull
    public Set<Class> getArgListStopSearchClasses() {
        Set<Class> set = ourStopSearch;
        if (set == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(0);
        }
        return set;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (!(item instanceof MutableLookupElement)) {
            return null;
        }
        Object o = item.getObject();
        if (o instanceof JSFunctionItem) {
            LinkedHashMap<String, JSFunctionWithSubstitutor> typedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            LinkedHashMap<String, JSFunctionWithSubstitutor> untypedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            HashSet untypedKeysForTypedSignatures = ContainerUtil.newHashSet();
            if (o instanceof JSFunction) {
                for (PsiElement el : DefinitionsScopedSearch.search((PsiElement)((JSFunction)o))) {
                    if (!(el instanceof JSFunction)) continue;
                    JSParameterInfoHandler.doAddSignature(typedSignatures, untypedSignatures, untypedKeysForTypedSignatures, (JSFunctionItem)((JSFunction)el), JSTypeSubstitutor.EMPTY);
                }
            }
            ArrayList<JSFunctionWithSubstitutor> result2 = new ArrayList<JSFunctionWithSubstitutor>(typedSignatures.size() + 1);
            result2.add(new JSFunctionWithSubstitutor((JSFunctionItem)o, JSTypeSubstitutor.EMPTY));
            ContainerUtil.addAll(result2, typedSignatures.values());
            return ArrayUtil.toObjectArray(result2);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static void doAddSignature(@NotNull Map<String, JSFunctionWithSubstitutor> typedSignatures, @NotNull Map<String, JSFunctionWithSubstitutor> untypedSignatures, @NotNull Set<String> untypedKeysForTypedSignatures, @NotNull JSFunctionItem functionItem, @NotNull JSTypeSubstitutor typeSubstitutor) {
        String untypedSignature;
        String typedSignature;
        if (typedSignatures == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (untypedSignatures == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (untypedKeysForTypedSignatures == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if (functionItem == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (typeSubstitutor == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(5);
        }
        if ((typedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)false, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text).equals(untypedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)true, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text)) {
            if (!untypedSignatures.containsKey(untypedSignature)) {
                untypedSignatures.put(untypedSignature, new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            }
        } else if (!typedSignatures.containsKey(typedSignature)) {
            typedSignatures.put(typedSignature, new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            untypedKeysForTypedSignatures.add(untypedSignature);
        }
    }

    public JSArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        JSArgumentList argList;
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if ((argList = JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset())) == null) {
            return null;
        }
        if (this.skipTypeScript() && DialectDetector.isTypeScript((PsiElement)argList)) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Stream<JSFunctionWithSubstitutor> resultStream = this.fillSignaturesForArgumentList(context, argList);
            if (resultStream != null) {
                context.setItemsToShow(resultStream.toArray());
                return argList;
            }
            context.setItemsToShow(null);
            return null;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (context == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(49);
            }
            int canceledCount = 0;
            while (canceledCount < 5) {
                boolean isInvalid = (Boolean)ReadAction.compute(() -> {
                    if (context == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(50);
                    }
                    if (!argList.isValid() || JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset()) != argList) {
                        return true;
                    }
                    Editor editor = context.getEditor();
                    return context.getProject().isDisposed() || editor.isDisposed();
                });
                if (isInvalid) {
                    return;
                }
                ProgressIndicatorBase indicator = new ProgressIndicatorBase();
                boolean success = this.runInReadActionWithWritePriority(context, argList, (ProgressIndicator)indicator);
                if (success) {
                    return;
                }
                if (!indicator.isCanceled()) continue;
                ++canceledCount;
            }
        });
        return null;
    }

    private boolean runInReadActionWithWritePriority(@NotNull CreateParameterInfoContext context, @NotNull JSArgumentList argList, @NotNull ProgressIndicator indicator) {
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if (argList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> {
            Stream<JSFunctionWithSubstitutor> resultStream;
            if (context == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(45);
            }
            if (argList == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(46);
            }
            if ((resultStream = this.fillSignaturesForArgumentList(context, argList)) != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (context == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(47);
                    }
                    if (argList == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(48);
                    }
                    context.setItemsToShow(resultStream.toArray());
                    this.showParameterInfo(argList, context);
                });
            }
        }, indicator);
    }

    @Nullable
    public static JSArgumentList findArgumentList(@Nullable PsiFile file2, int offset) {
        JSCallExpression callExpression;
        if (file2 == null) {
            return null;
        }
        JSArgumentList argList = (JSArgumentList)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file2, (int)offset, JSArgumentList.class, (Class[])new Class[]{JSStatement.class, JSFunctionExpression.class});
        if (argList == null && (callExpression = (JSCallExpression)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file2, (int)offset, JSCallExpression.class, (Class[])new Class[]{JSStatement.class})) != null) {
            argList = callExpression.getArgumentList();
        }
        return argList != null && PsiTreeUtil.getContextOfType((PsiElement)file2.findElementAt(offset), TypeScriptTypeArgumentList.class, (boolean)true, (Class[])new Class[]{JSStatement.class}) == null ? argList : null;
    }

    @Nullable
    protected Stream<JSFunctionWithSubstitutor> fillSignaturesForArgumentList(CreateParameterInfoContext context, @NotNull JSArgumentList argList) {
        if (argList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement psiElement = argList.getParent();
        if (!(psiElement instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression parent = (JSCallExpression)psiElement;
        JSExpression methodExpression = JSUtils.unparenthesize(parent.getMethodExpression());
        if (methodExpression instanceof JSReferenceExpression || methodExpression instanceof JSIndexedPropertyAccessExpression) {
            return this.fillSignaturesForReferenceOrIndexAccessExpression(parent, methodExpression);
        }
        if (methodExpression instanceof JSSuperExpression) {
            PsiElement clazz = methodExpression.getReference().resolve();
            if (clazz instanceof JSFunction) {
                if (clazz instanceof TypeScriptFunction) {
                    Collection<? extends JSFunctionItem> overloadDeclarations = TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)clazz);
                    return overloadDeclarations.stream().map(c -> new JSFunctionWithSubstitutor((JSFunctionItem)c, JSTypeSubstitutor.EMPTY));
                }
                return Stream.of(new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunction)clazz), JSTypeSubstitutor.EMPTY));
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            return Stream.of(new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunctionExpression)methodExpression), JSTypeSubstitutor.EMPTY));
        }
        return null;
    }

    private static Collection<PsiElement> getResolvedPsiElements(JSExpression methodExpression) {
        if (methodExpression instanceof JSReferenceExpression) {
            ResolveResult[] resolveResults = ((JSReferenceExpression)methodExpression).multiResolve(true);
            if (resolveResults.length <= 0) {
                return Collections.emptyList();
            }
            return JSResolveResult.toElements(resolveResults, false);
        }
        if (methodExpression instanceof JSIndexedPropertyAccessExpression) {
            String value;
            ArrayList elements = ContainerUtil.newArrayList();
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)methodExpression).getIndexExpression();
            String propertyName = null;
            if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getStringValue()) != null) {
                propertyName = value;
            }
            if (JSPsiImplUtils.isSymbolRef(indexExpression)) {
                propertyName = "[" + indexExpression.getText() + "]";
            }
            if (propertyName != null) {
                JSRecordType recordType;
                JSRecordType.PropertySignature propertySignature;
                JSType qualifierType = JSResolveUtil.getExpressionJSType(((JSIndexedPropertyAccessExpression)methodExpression).getQualifier());
                if ((qualifierType = JSTypeUtils.getValuableType(qualifierType)) != null && (propertySignature = (recordType = qualifierType.asRecordType()).findPropertySignature(propertyName)) != null) {
                    JSRecordType.MemberSource source = propertySignature.getMemberSource();
                    if (!source.isUnion()) {
                        elements.addAll(source.getAllSourceElements());
                    } else if (propertySignature instanceof JSCompositeFunctionPropertySignatureImpl) {
                        for (JSRecordType.PropertySignature part : ((JSCompositeFunctionPropertySignatureImpl)propertySignature).getMembers()) {
                            source = part.getMemberSource();
                            if (source.isUnion()) continue;
                            elements.addAll(source.getAllSourceElements());
                        }
                    }
                }
            }
            return elements;
        }
        throw new UnsupportedOperationException("Expression " + methodExpression.getClass() + " is not supported");
    }

    private JSExpression getQualifier(@NotNull JSExpression methodExpression) {
        if (methodExpression == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(11);
        }
        if (methodExpression instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)methodExpression).getQualifier();
        }
        if (methodExpression instanceof JSIndexedPropertyAccessExpression) {
            return ((JSIndexedPropertyAccessExpression)methodExpression).getQualifier();
        }
        throw new UnsupportedOperationException("Expression " + methodExpression.getClass() + " is not supported");
    }

    @Nullable
    protected Stream<JSFunctionWithSubstitutor> fillSignaturesForReferenceOrIndexAccessExpression(@NotNull JSCallExpression parent, @NotNull JSExpression methodExpression) {
        Collection<PsiElement> elements;
        if (parent == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if (methodExpression == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(13);
        }
        if ((elements = JSParameterInfoHandler.getResolvedPsiElements(methodExpression)).size() == 0) {
            return null;
        }
        elements = JSParameterInfoHandler.getElementsWithConstructors(parent, elements);
        LinkedHashMap<String, JSFunctionWithSubstitutor> typedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>(elements.size());
        LinkedHashMap<String, JSFunctionWithSubstitutor> untypedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
        HashSet untypedKeysForTypedSignatures = ContainerUtil.newHashSet();
        JSExpression qualifier = this.getQualifier(methodExpression);
        ArrayList<JSFunctionItem> items = JSParameterInfoHandler.getFunctionItems(parent, methodExpression, elements);
        JSTypeSubstitutor typeSubstitutor = JSParameterInfoHandler.getTypeSubstitutor(methodExpression, qualifier, items);
        for (JSFunctionItem functionItem : items) {
            JSParameterInfoHandler.doAddSignature(typedSignatures, untypedSignatures, untypedKeysForTypedSignatures, functionItem, typeSubstitutor);
        }
        Stream typedStream = typedSignatures.values().stream();
        Stream.Builder untypedStreamBuilder = Stream.builder();
        for (Map.Entry entry : untypedSignatures.entrySet()) {
            if (untypedKeysForTypedSignatures.contains(entry.getKey())) continue;
            untypedStreamBuilder.add(entry.getValue());
        }
        return Stream.concat(typedStream, untypedStreamBuilder.build());
    }

    @NotNull
    private static ArrayList<JSFunctionItem> getFunctionItems(@NotNull JSCallExpression parent, @NotNull JSExpression methodExpression, @NotNull Collection<PsiElement> elements) {
        if (parent == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(14);
        }
        if (methodExpression == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(15);
        }
        if (elements == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(16);
        }
        ArrayList items = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            Collection<? extends JSFunctionItem> functionItems;
            if (element instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                element = ((TypeScriptProxyImplicitElementWithBackingItem)element).getBackingElement();
            }
            if ((functionItems = JSParameterInfoHandler.getFunctionItems(parent, methodExpression, element)).size() == 0) continue;
            items.addAll(functionItems);
        }
        ArrayList arrayList = items;
        if (arrayList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeSubstitutor(JSExpression methodExpression, @Nullable JSExpression qualifier, @NotNull List<JSFunctionItem> items) {
        JSNamespace namespace;
        JSType qualifierType;
        JSFunctionItem firstFunction;
        if (items == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(18);
        }
        if ((firstFunction = (JSFunctionItem)ContainerUtil.getFirstItem(items)) instanceof TypeScriptFunction) {
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember((JSElement)ContainerUtil.getFirstItem(items), (PsiElement)methodExpression);
            if (jSTypeSubstitutor == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(19);
            }
            return jSTypeSubstitutor;
        }
        if (qualifier != null && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null && (namespace = JSTypeUtils.getNamespaceMatchingType(qualifierType, false)) != null) {
            JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)JSTypeWithOuterGenerics.getGenericArguments(namespace), (Object)JSTypeSubstitutor.EMPTY);
            if (jSTypeSubstitutor == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(20);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(21);
        }
        return jSTypeSubstitutor;
    }

    private static Collection<PsiElement> getElementsWithConstructors(JSCallExpression parent, Collection<PsiElement> elements) {
        if (parent instanceof JSNewExpression) {
            ArrayList newElements = ContainerUtil.newArrayListWithCapacity((int)elements.size());
            for (PsiElement element : elements) {
                if (element instanceof JSClass) {
                    ResolveResult[] constructorResults;
                    JSClass jsClass = (JSClass)element;
                    for (ResolveResult result2 : constructorResults = JSClassUtils.resolveES6Constructor(jsClass, parent.getMethodExpression())) {
                        PsiElement resultConstructor = result2.getElement();
                        if (resultConstructor == null) continue;
                        newElements.add(resultConstructor);
                    }
                    continue;
                }
                newElements.add(element);
            }
            elements = newElements;
        }
        return elements;
    }

    @NotNull
    private static Collection<? extends JSFunctionItem> getFunctionItems(JSCallExpression parent, JSExpression methodExpression, PsiElement element) {
        JSFunctionItem functionItem = JSParameterInfoHandler.calculatePossibleFunctionCarefully(element, (PsiElement)methodExpression);
        if (functionItem == null) {
            JSType jsType = JSTypeUtils.getTypeOfElement(element);
            if ((jsType = JSTypeUtils.getValuableType(jsType)) != null) {
                List result2;
                Collection functionTypes = JSTypeUtils.getFunctionType(jsType, parent instanceof JSNewExpression, (PsiElement)parent).collect(Collectors.toList());
                if (functionTypes.isEmpty()) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(22);
                    }
                    return list;
                }
                DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
                List list = result2 = holder != null && holder.isECMA4 ? ContainerUtil.emptyList() : JSParameterInfoHandler.getFunctionItemsForTypes(functionTypes);
                if (result2.size() > 0) {
                    List list2 = result2;
                    if (list2 == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(23);
                    }
                    return list2;
                }
                PsiElement sourceElement = jsType.getSource().getSourceElement();
                if (sourceElement instanceof JSFunctionItem) {
                    functionItem = (JSFunctionItem)sourceElement;
                }
            }
        }
        if (functionItem instanceof TypeScriptFunction) {
            Collection<? extends JSFunctionItem> collection = TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)functionItem);
            if (collection == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(24);
            }
            return collection;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)functionItem);
        if (list == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    private static Collection<JSFunctionItem> getFunctionItemsForTypes(@NotNull Collection<JSType> functionTypes) {
        if (functionTypes == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(26);
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (JSType functionType : functionTypes) {
            PsiElement functionSourceElement;
            if (functionType instanceof JSGenericTypeImpl) {
                functionType = ((JSGenericTypeImpl)functionType).getType();
            }
            if (!((functionSourceElement = functionType.getSource().getSourceElement()) instanceof JSFunctionItem)) continue;
            JSFunctionItem currentFunction = (JSFunctionItem)functionSourceElement;
            if (currentFunction instanceof TypeScriptFunction) {
                result2.addAll(TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)currentFunction));
                continue;
            }
            result2.add(currentFunction);
        }
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(27);
        }
        return linkedHashSet;
    }

    public void showParameterInfo(@NotNull JSArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(28);
        }
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(29);
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    public JSArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(30);
        }
        return JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset());
    }

    public void updateParameterInfo(@NotNull JSArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(31);
        }
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(32);
        }
        if (context.getParameterOwner() != parameterOwner) {
            context.removeHint();
            return;
        }
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)JSTokenTypes.COMMA);
        context.setCurrentParameter(currentParameterIndex);
    }

    public void updateUI(JSFunctionWithSubstitutor pair, @NotNull ParameterInfoUIContext context) {
        JSFunctionItem p;
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(33);
        }
        if (!((p = pair.myFunctionItem) instanceof JSImplicitFunctionImpl) && !p.isValid()) {
            return;
        }
        JSParameterItem[] params = p.getParameters();
        int currentParameterIndex = context.getCurrentParameterIndex() >= 0 ? context.getCurrentParameterIndex() : params.length;
        JSParameterItem parameter = currentParameterIndex < params.length ? params[currentParameterIndex] : null;
        SignatureInfo signatureInfo = JSParameterInfoHandler.buildSignature(p, false, currentParameterIndex, pair.myTypeSubstitutor);
        String name = signatureInfo.text;
        String currentParameterSignature = parameter != null ? JSParameterInfoHandler.getSignatureForParameter(parameter, pair.myTypeSubstitutor) : null;
        int highlightStart = parameter != null ? signatureInfo.selectedParameterStart : 0;
        int highlightEnd = parameter != null ? highlightStart + currentParameterSignature.length() : 0;
        context.setupUIComponentPresentation(name, highlightStart, highlightEnd, false, false, false, context.getDefaultParameterColor());
    }

    @Nullable
    public static JSFunctionItem calculatePossibleFunctionCarefully(@NotNull PsiElement resolveResult, @Nullable PsiElement methodExpression) {
        PsiElement module;
        if (resolveResult == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(34);
        }
        if (resolveResult instanceof JSParameter && (module = JSAmdPsiUtil.findReferencedModule((JSParameter)resolveResult)) != null) {
            resolveResult = module;
        }
        return JSPsiImplUtils.calculatePossibleFunction(resolveResult, methodExpression, false);
    }

    @NotNull
    private static SignatureInfo buildSignature(@NotNull JSFunctionItem function, boolean skipType, int selectedParameterIndex, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (function == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(35);
        }
        JSParameterItem[] params = function.getParameters();
        SignatureInfo info = new SignatureInfo();
        if (params.length > 0) {
            StringBuilder result2 = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                if (result2.length() > 0) {
                    result2.append(", ");
                }
                if (selectedParameterIndex == i) {
                    info.selectedParameterStart = result2.toString().length();
                }
                result2.append(JSParameterInfoHandler.getSignatureForParameter(params[i], skipType, typeSubstitutor));
            }
            if (function.isReferencesArguments()) {
                result2.append(", ...");
            }
            info.text = result2.toString();
        } else {
            String signature = function.isReferencesArguments() ? "..." : CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
            info.text = signature;
        }
        SignatureInfo signatureInfo = info;
        if (signatureInfo == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(36);
        }
        return signatureInfo;
    }

    private static String getSignatureForParameter(JSParameterItem p, boolean skipType, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSParameterTypeDecorator decorator = p.getTypeDecorator();
        JSType type = p.getTypeIncludingOverridden();
        if (type != null) {
            type = JSTypeUtils.applyGenericArguments(type, typeSubstitutor);
        }
        String initializerText = p instanceof JSParameter ? ((JSParameter)p).getLiteralOrReferenceInitializerText() : null;
        DialectOptionHolder holder = p instanceof PsiElement ? DialectDetector.dialectOfElement((PsiElement)p) : null;
        if (!(skipType |= p instanceof JSDestructuringParameter && ((JSDestructuringParameter)p).getTypeElement() == null) && type != null) {
            boolean needOptional;
            String s = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            boolean isActionScript = holder != null && holder.isECMA4;
            StringBuilder result2 = new StringBuilder();
            boolean bl = needOptional = p.isOptional() && initializerText == null;
            if (p.isRest()) {
                result2.append("... ");
                result2.append(JSParameterInfoHandler.getParameterItemPresentableName(p));
            } else {
                result2.append(JSParameterInfoHandler.getParameterItemPresentableName(p));
                if (needOptional) {
                    result2.append('?');
                }
            }
            result2.append(":");
            if (!isActionScript) {
                result2.append(" ");
            }
            result2.append(JSLookupUtilImpl.getShortName(s));
            if (p.isRest() && !JSTypeUtils.isNonArrayRestType(p.getType())) {
                result2.append("[]");
            }
            if (initializerText != null) {
                result2.append(" = ");
                result2.append(initializerText);
            }
            return result2.toString();
        }
        String res = JSParameterInfoHandler.getParameterItemPresentableName(p);
        if (p.isRest()) {
            res = "... " + res;
        }
        if (p.isOptional() && decorator.isExplicitlyDeclared()) {
            res = res + "?";
        }
        if (initializerText != null) {
            res = res + " = " + initializerText;
        }
        return res;
    }

    @NotNull
    private static String getParameterItemPresentableName(@NotNull JSParameterItem p) {
        String res;
        if (p == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(37);
        }
        if (p instanceof JSDestructuringParameter) {
            StringBuilder builder = new StringBuilder();
            JSDestructuringContainer target = ((JSDestructuringParameter)p).getTarget();
            if (target != null) {
                ES6PsiUtil.buildSignatureForDestructuringContainer(target, builder, true);
            }
            res = builder.toString();
        } else {
            res = p.getName();
        }
        String string = res != null ? res : "<no name>";
        if (string == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(38);
        }
        return string;
    }

    public static String getSignatureForParameter(JSParameterItem p) {
        return JSParameterInfoHandler.getSignatureForParameter(p, null);
    }

    public static String getSignatureForParameter(JSParameterItem p, @Nullable JSTypeSubstitutor typeSubstitutor) {
        return JSParameterInfoHandler.getSignatureForParameter(p, false, typeSubstitutor);
    }

    @NotNull
    public JSExpression[] getActualParameters(@NotNull JSArgumentList jsArgumentList) {
        if (jsArgumentList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(39);
        }
        JSExpression[] jSExpressionArray = jsArgumentList.getArguments();
        if (jSExpressionArray == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(40);
        }
        return jSExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JSTokenTypes.COMMA;
        if (iElementType == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(41);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JSTokenTypes.RBRACE;
        if (iElementType == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(42);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ourArgumentListAllowedParentClassesSet;
        if (set == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(43);
        }
        return set;
    }

    @NotNull
    public Class<JSArgumentList> getArgumentListClass() {
        if (JSArgumentList.class == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(44);
        }
        return JSArgumentList.class;
    }

    protected boolean skipTypeScript() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/JSParameterInfoHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedSignatures";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untypedSignatures";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untypedKeysForTypedSignatures";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
            case 6: 
            case 7: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 45: 
            case 47: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 10: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionTypes";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/JSParameterInfoHandler";
                break;
            }
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionItems";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionItemsForTypes";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSignature";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterItemPresentableName";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAddSignature";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWritePriority";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillSignaturesForArgumentList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fillSignaturesForReferenceOrIndexAccessExpression";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionItems";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionItemsForTypes";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunctionCarefully";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildSignature";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getParameterItemPresentableName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runInReadActionWithWritePriority$3";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findElementForParameterInfo$1";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SignatureInfo {
        String text;
        int selectedParameterStart = -1;

        private SignatureInfo() {
        }
    }
}

