/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.lang.javascript.flow.lsp.FlowJSHighlightingCache;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspServiceKt;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\u00020\b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00060\u0006 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/flow/lsp/FlowJSHighlightingCache;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "(Lcom/intellij/openapi/Disposable;)V", "lastErrors", "", "", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "openedFiles", "", "kotlin.jvm.PlatformType", "", "closeLastEditor", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "languageServer", "Lorg/eclipse/lsp4j/services/LanguageServer;", "dispose", "getAllHighlights", "getHighlights", "Lcom/intellij/psi/PsiFile;", "openEditor", "publishDiagnostics", "diagnostics", "Lorg/eclipse/lsp4j/PublishDiagnosticsParams;", "toJSAnnotationError", "Lorg/eclipse/lsp4j/Diagnostic;", "filePath", "intellij.javascript.impl"})
public final class FlowJSHighlightingCache
implements Disposable {
    private final Set<String> openedFiles;
    private final Map<String, List<JSAnnotationError>> lastErrors;

    public final void openEditor(@NotNull VirtualFile file2, @NotNull LanguageServer languageServer) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)languageServer, (String)"languageServer");
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document != null && this.openedFiles.add(file2.getUrl())) {
            ApplicationManager.getApplication().runReadAction(new Runnable(languageServer, file2, document){
                final /* synthetic */ LanguageServer $languageServer;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ Document $document;

                public final void run() {
                    this.$languageServer.getTextDocumentService().didOpen(new DidOpenTextDocumentParams(new TextDocumentItem(this.$file.getUrl(), "flow", (int)this.$document.getModificationStamp(), this.$document.getText())));
                    this.$document.addDocumentListener(new DocumentListener(this){
                        final /* synthetic */ openEditor.1 this$0;

                        public void documentChanged(@NotNull DocumentEvent event) {
                            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                            VersionedTextDocumentIdentifier documentId = new VersionedTextDocumentIdentifier((int)this.this$0.$document.getModificationStamp());
                            documentId.setUri(this.this$0.$file.getUrl());
                            Range range = new Range(FlowJSLspServiceKt.getPositionByOffset(this.this$0.$document, event.getOffset()), FlowJSLspServiceKt.getPositionByOffset(this.this$0.$document, event.getOffset() + event.getOldLength()));
                            TextDocumentContentChangeEvent lspEvent = new TextDocumentContentChangeEvent(range, Integer.valueOf(event.getOldLength()), ((Object)event.getNewFragment()).toString());
                            DidChangeTextDocumentParams didChangeTextDocumentParams = new DidChangeTextDocumentParams(documentId, CollectionsKt.mutableListOf((Object[])new TextDocumentContentChangeEvent[]{lspEvent}));
                            this.this$0.$languageServer.getTextDocumentService().didChange(didChangeTextDocumentParams);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    });
                }
                {
                    this.$languageServer = languageServer;
                    this.$file = virtualFile;
                    this.$document = document;
                }
            });
        }
    }

    public final void closeLastEditor(@NotNull VirtualFile file2, @NotNull LanguageServer languageServer) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)languageServer, (String)"languageServer");
        if (this.openedFiles.remove(file2.getUrl())) {
            languageServer.getTextDocumentService().didClose(new DidCloseTextDocumentParams(new TextDocumentIdentifier(file2.getUrl())));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void publishDiagnostics(@NotNull PublishDiagnosticsParams diagnostics) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)diagnostics, (String)"diagnostics");
        Map<String, List<JSAnnotationError>> map = this.lastErrors;
        String string = diagnostics.getUri();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"diagnostics.uri");
        String string2 = string;
        List list = diagnostics.getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"diagnostics.diagnostics");
        Iterable iterable = $receiver$iv = (Iterable)list;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Diagnostic diagnostic = (Diagnostic)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            String string3 = VfsUtilCore.urlToPath((String)diagnostics.getUri());
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"VfsUtilCore.urlToPath(diagnostics.uri)");
            JSAnnotationError jSAnnotationError = this.toJSAnnotationError((Diagnostic)v2, string3);
            collection.add(jSAnnotationError);
        }
        List list2 = (List)destination$iv$iv;
        map.put(string2, list2);
    }

    private final JSAnnotationError toJSAnnotationError(@NotNull Diagnostic $receiver, String filePath) {
        String string = $receiver.getMessage();
        String string2 = $receiver.getSeverity().name();
        Range range = $receiver.getRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"this.range");
        Position position = range.getStart();
        Intrinsics.checkExpressionValueIsNotNull((Object)position, (String)"this.range.start");
        int n = position.getLine() + 1;
        Range range2 = $receiver.getRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)range2, (String)"this.range");
        Position position2 = range2.getStart();
        Intrinsics.checkExpressionValueIsNotNull((Object)position2, (String)"this.range.start");
        int n2 = position2.getCharacter() + 1;
        Range range3 = $receiver.getRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)range3, (String)"this.range");
        Position position3 = range3.getEnd();
        Intrinsics.checkExpressionValueIsNotNull((Object)position3, (String)"this.range.end");
        int n3 = position3.getLine() + 1;
        Range range4 = $receiver.getRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)range4, (String)"this.range");
        Position position4 = range4.getEnd();
        Intrinsics.checkExpressionValueIsNotNull((Object)position4, (String)"this.range.end");
        return new JSLanguageServiceAnnotationResult(string, null, filePath, string2, n, n2, n3, position4.getCharacter() + 1);
    }

    @NotNull
    public final List<JSAnnotationError> getHighlights(@NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        VirtualFile virtualFile = file2.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file.virtualFile");
        List list = this.lastErrors.get(virtualFile.getUrl());
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<JSAnnotationError> getAllHighlights() {
        return CollectionsKt.flatten((Iterable)this.lastErrors.values());
    }

    public void dispose() {
    }

    public FlowJSHighlightingCache(@NotNull Disposable parentDisposable) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.openedFiles = Collections.newSetFromMap(new ConcurrentHashMap());
        FlowJSHighlightingCache flowJSHighlightingCache = this;
        flowJSHighlightingCache.lastErrors = map = (Map)new LinkedHashMap();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }
}

