/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExactFileReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements JSModuleBaseReference,
PsiFileReference {
    private static final ResolveCache.PolyVariantResolver<JSExactFileReference> RESOLVER = (el, incomplete) -> el.multiResolveInner();
    @NotNull
    private final Collection<String> myPaths;
    @NotNull
    private final String[] myExtensions;

    public JSExactFileReference(@NotNull PsiElement context, @NotNull TextRange range, @NotNull Collection<String> filePaths, @Nullable String[] extensions) {
        if (context == null) {
            JSExactFileReference.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JSExactFileReference.$$$reportNull$$$0(1);
        }
        if (filePaths == null) {
            JSExactFileReference.$$$reportNull$$$0(2);
        }
        super(context, range, true);
        this.myPaths = filePaths;
        this.myExtensions = extensions == null ? ArrayUtil.EMPTY_STRING_ARRAY : extensions;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiPolyVariantReference)this, RESOLVER, false, incompleteCode);
        if (resolveResultArray == null) {
            JSExactFileReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    @NotNull
    protected ResolveResult[] multiResolveInner() {
        SmartList result2 = new SmartList();
        for (String path : this.myPaths) {
            PsiElement resolvedElement = this.findFileOrDirectory(this.getElement(), path, this.myExtensions);
            if (resolvedElement == null) continue;
            result2.add((Object)resolvedElement);
            if (this.directoryOnly()) continue;
            break;
        }
        ResolveResult[] resolveResultArray = this.getResolveResults((List<PsiElement>)result2);
        if (resolveResultArray == null) {
            JSExactFileReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @NotNull
    protected ResolveResult[] getResolveResults(@NotNull List<PsiElement> results) {
        if (results == null) {
            JSExactFileReference.$$$reportNull$$$0(5);
        }
        SmartList resolveResult = new SmartList();
        for (PsiElement result2 : results) {
            Object[] elements;
            if (result2 instanceof PsiDirectory && !this.directoryOnly() && (elements = this.resolveForNpmPackages(result2)) != null) {
                ContainerUtil.addAll((Collection)resolveResult, (Object[])elements);
                continue;
            }
            resolveResult.add((Object)new JSResolveResult(result2));
        }
        ResolveResult[] resolveResultArray = (ResolveResult[])resolveResult.toArray((Object[])ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            JSExactFileReference.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    protected boolean directoryOnly() {
        return false;
    }

    @Nullable
    protected PsiElement findFileOrDirectory(@NotNull PsiElement context, @Nullable String path, @NotNull String[] extensions) {
        if (context == null) {
            JSExactFileReference.$$$reportNull$$$0(7);
        }
        if (extensions == null) {
            JSExactFileReference.$$$reportNull$$$0(8);
        }
        if (path == null) {
            return null;
        }
        VirtualFile file2 = this.findFileByPath(path);
        if (file2 == null && extensions.length > 0) {
            for (String extension : extensions) {
                VirtualFile pathWithExtension = this.findFileByPath(path + extension);
                if (pathWithExtension == null || pathWithExtension.isDirectory()) continue;
                file2 = pathWithExtension;
                break;
            }
        }
        if (file2 != null) {
            PsiManager manager = context.getManager();
            return file2.isDirectory() ? manager.findDirectory(file2) : manager.findFile(file2);
        }
        return null;
    }

    protected VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            JSExactFileReference.$$$reportNull$$$0(9);
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    @Nullable
    protected ResolveResult[] resolveForNpmPackages(@NotNull PsiElement result2) {
        ResolveResult[] resolveResultArray;
        ResolveResult resolveResult;
        if (result2 == null) {
            JSExactFileReference.$$$reportNull$$$0(10);
        }
        if ((resolveResult = JSExactFileReference.resolveForNpmPackages(result2, this.createNodeProcessor())) == null) {
            resolveResultArray = null;
        } else {
            ResolveResult[] resolveResultArray2 = new ResolveResult[1];
            resolveResultArray = resolveResultArray2;
            resolveResultArray2[0] = resolveResult;
        }
        return resolveResultArray;
    }

    @Nullable
    public static ResolveResult resolveForNpmPackages(@Nullable PsiElement result2, @NotNull NodeModuleDirectorySearchProcessor processor) {
        if (processor == null) {
            JSExactFileReference.$$$reportNull$$$0(11);
        }
        if (!(result2 instanceof PsiDirectory)) {
            return null;
        }
        VirtualFile file2 = ((PsiDirectory)result2).getVirtualFile();
        VirtualFile mainFile = JSExactFileReference.resolveForNpmPackages(file2, processor);
        if (mainFile == null) {
            return null;
        }
        PsiFile mainPsiFile = result2.getManager().findFile(mainFile);
        return mainPsiFile == null ? null : new PsiElementResolveResult((PsiElement)mainPsiFile);
    }

    public static VirtualFile resolveForNpmPackages(@NotNull VirtualFile file2, @NotNull NodeModuleDirectorySearchProcessor processor) {
        VirtualFile mainFile;
        ResolvedModuleInfo info;
        if (file2 == null) {
            JSExactFileReference.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            JSExactFileReference.$$$reportNull$$$0(13);
        }
        if ((info = processor.loadDirectory(null, file2, ModuleType.NODE_MODULES_DIR, true)) != null && !(mainFile = info.getModuleMainFile()).isDirectory()) {
            return mainFile;
        }
        return null;
    }

    protected NodeModuleDirectorySearchProcessor createNodeProcessor() {
        return NodeModuleDirectorySearchProcessor.PROCESSOR;
    }

    @Override
    public int getWeight() {
        return JSModuleBaseReference.ModuleTypes.PATH_MAPPING.weight();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResults";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFileOrDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveForNpmPackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

