/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.control.JSSimplifyIfStatementFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuspiciousTypeUtil {
    public static LocalQuickFix[] getSimplifyFixes(@NotNull JSExpression expression, boolean isAlwaysFalse) {
        PsiElement ifCandidate;
        if (expression == null) {
            JSSuspiciousTypeUtil.$$$reportNull$$$0(0);
        }
        if (!((ifCandidate = expression.getParent()) instanceof JSIfStatement) || ((JSIfStatement)ifCandidate).getCondition() != expression) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new JSSimplifyIfStatementFix(isAlwaysFalse)};
    }

    public static boolean isTypeWithStrictNullability(@Nullable JSType expressionJSType, @NotNull PsiElement context) {
        if (context == null) {
            JSSuspiciousTypeUtil.$$$reportNull$$$0(1);
        }
        if (expressionJSType == null) {
            return false;
        }
        if (expressionJSType.isTypeScript() && TypeScriptConfigUtil.strictNullChecks(context)) {
            return true;
        }
        return TypeScriptTypeRelations.isNotNullInferredPrimitive(expressionJSType);
    }

    @NotNull
    public static JSType getGenericConstraintSelfOrAny(@Nullable JSType t) {
        if (!(t instanceof JSGenericParameterImpl)) {
            JSType jSType = t == null ? JSAnyType.get(JSTypeSource.EMPTY_TS) : t;
            if (jSType == null) {
                JSSuspiciousTypeUtil.$$$reportNull$$$0(2);
            }
            return jSType;
        }
        JSType constraintType = ((JSGenericParameterImpl)t).getConstraintType();
        JSType jSType = constraintType == null ? JSAnyType.get(t.getSource()) : constraintType;
        if (jSType == null) {
            JSSuspiciousTypeUtil.$$$reportNull$$$0(3);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspection/JSSuspiciousTypeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspection/JSSuspiciousTypeUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericConstraintSelfOrAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimplifyFixes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTypeWithStrictNullability";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

