/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.eslint.ESLintSuppressionUtil;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EslintConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.lang.javascript.linter.eslint.EslintExternalAnnotator;
import com.intellij.lang.javascript.linter.eslint.EslintFixSingleErrorAction;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSFixAction;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSInspection;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSService;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSState;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSUtil;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardJSExternalAnnotator
extends JSLinterExternalAnnotator<StandardJSState> {
    private static final Logger LOG = Logger.getInstance(EsLintExternalRunner.class);

    public StandardJSExternalAnnotator() {
        this(true);
    }

    public StandardJSExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected EslintConfigurable createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(0);
        }
        EslintConfigurable eslintConfigurable = new EslintConfigurable(project, true);
        if (eslintConfigurable == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(1);
        }
        return eslintConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<StandardJSState>> getConfigurationClass() {
        return StandardJSConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return StandardJSInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(2);
        }
        return EslintExternalAnnotator.acceptPsiFileForEslintAnnotation(file2);
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult<StandardJSState> annotate(@NotNull JSLinterInput<StandardJSState> input) {
        StandardJSState initialState;
        if (input == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(initialState = input.getState()).getPackagePath())) {
            return null;
        }
        NodePackage standardPackage = new NodePackage(initialState.getPackagePath());
        SemVer semVer = standardPackage.getVersion();
        if (semVer != null && semVer.getMajor() < 7) {
            return JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation("Unsupported package version. Please upgrade 'Standard' package to minimum version 7.0.0"), null);
        }
        EslintState runnableState = StandardJSExternalAnnotator.tryCreateESLintInput(initialState, input.getVirtualFile(), input.getProject(), standardPackage);
        if (runnableState == null) {
            JSLinterFileLevelAnnotation annotation = JSLinterUtil.createLinterPackageError(input.getProject(), initialState.getPackagePath(), "standard");
            return JSLinterAnnotationResult.create(input, annotation, null);
        }
        JSLinterInput<EslintState> eslintInput = JSLinterInput.create(input.getProject(), input.getPsiFile(), input.getFileContent(), runnableState, input.getColorsScheme());
        StandardJSService service = StandardJSService.getInstance(input.getProject());
        JSLinterAnnotationResult<EslintState> eslintResult = EsLintExternalRunner.highlight(eslintInput, service, this.isOnTheFly());
        return new JSLinterAnnotationResult<StandardJSState>(input, eslintResult.getErrors(), eslintResult.getFileLevelError(), eslintResult.getConfigFile());
    }

    @Override
    public void apply(@NotNull PsiFile file2, @Nullable JSLinterAnnotationResult<StandardJSState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(5);
        }
        if (annotationResult == null) {
            return;
        }
        String caption = JSBundle.message((String)"standardjs.name", (Object[])new Object[0]);
        EslintConfigurable configurable = new EslintConfigurable(file2.getProject(), true);
        IntentionAction fixFileAction = new StandardJSFixAction().asIntentionAction();
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setEditConfig(false).setEditSettingsAction(new JSLinterEditSettingsAction(configurable, JSBundle.message((String)"standardjs.edit.settings.caption", (Object[])new Object[0]), null)).setErrorToIntentionConverter((Convertor<JSLinterErrorBase, List<IntentionAction>>)((Convertor)error -> {
            EslintError eslintError;
            if (file2 == null) {
                StandardJSExternalAnnotator.$$$reportNull$$$0(14);
            }
            ArrayList<EslintFixSingleErrorAction> result2 = new ArrayList<EslintFixSingleErrorAction>();
            EslintError eslintError2 = eslintError = error instanceof EslintError ? (EslintError)error : null;
            if (eslintError != null && eslintError.getFixInfo() != null) {
                if (document != null && this.isOnTheFly()) {
                    result2.add(new EslintFixSingleErrorAction(file2, (EslintError)error, caption, document.getModificationStamp()));
                }
                result2.add((EslintFixSingleErrorAction)fixFileAction);
            }
            return result2;
        })).setProblemGroup((Function<JSLinterErrorBase, ProblemGroup>)((Function)error -> {
            if (!this.isOnTheFly()) {
                return null;
            }
            if (error instanceof EslintError) {
                SuppressIntentionAction[] intentionActions = ESLintSuppressionUtil.INSTANCE.getSuppressionsForError((EslintError)error).toArray(SuppressIntentionAction.EMPTY_ARRAY);
                return new JSAnnotatorProblemGroup(intentionActions, null);
            }
            return null;
        }));
        new JSLinterAnnotationsBuilder<StandardJSState>(file2, annotationResult, holder, configurable, caption + ": ", this.getInspectionClass(), fixes).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).apply();
    }

    @Nullable
    public static EslintState tryCreateESLintInput(@NotNull StandardJSState standardJSState, @NotNull VirtualFile fileToLint, @NotNull Project project) {
        if (standardJSState == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(6);
        }
        if (fileToLint == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(7);
        }
        if (project == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(8);
        }
        return StandardJSExternalAnnotator.tryCreateESLintInput(standardJSState, fileToLint, project, new NodePackage(standardJSState.getPackagePath()));
    }

    @Nullable
    private static EslintState tryCreateESLintInput(@NotNull StandardJSState standardJSState, @NotNull VirtualFile fileToLint, @NotNull Project project, @NotNull NodePackage standardPackage) {
        if (standardJSState == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(9);
        }
        if (fileToLint == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(10);
        }
        if (project == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(11);
        }
        if (standardPackage == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(12);
        }
        NodePackage eslintPackage = StandardJSUtil.findEslintPackage(standardPackage);
        VirtualFile packageJson = PackageJsonUtil.findUpPackageJson(fileToLint);
        StandardJSUtil.ConfigData packageJsonData = StandardJSUtil.getPackageJsonConfigData(project, packageJson);
        if (eslintPackage == null) {
            LOG.info(String.format("Could not find eslint package from standard package %s", standardPackage));
            return null;
        }
        String configFilePath = new File(standardPackage.getSystemDependentPath(), "eslintrc.json").getAbsolutePath();
        if (!FileUtil.exists((String)configFilePath)) {
            LOG.info(String.format("Could not find config file from path %s", configFilePath));
            return null;
        }
        return new EslintState.Builder().setInterpreterRef(standardJSState.getInterpreterRef()).setEslintPackagePath(eslintPackage.getSystemDependentPath()).setCustomConfigFileUsed(true).setCustomConfigFilePath(configFilePath).setExtraOptions(StandardJSExternalAnnotator.getExtraOptions(packageJsonData)).build();
    }

    @NotNull
    private static String getExtraOptions(@Nullable StandardJSUtil.ConfigData configData) {
        ArrayList commandLine = ContainerUtil.newArrayList((Object[])new String[]{"--no-eslintrc"});
        if (configData != null) {
            StandardJSExternalAnnotator.addListArgument(commandLine, "global", configData.globals);
            StandardJSExternalAnnotator.addListArgument(commandLine, "ignore-pattern", configData.ignored);
            StandardJSExternalAnnotator.addListArgument(commandLine, "env", configData.env);
            for (String plugin : configData.plugins) {
                commandLine.add("--plugin");
                commandLine.add(plugin);
            }
            if (!StringUtil.isEmpty((String)configData.parser)) {
                commandLine.add("--parser");
                commandLine.add(configData.parser);
            }
        }
        String string = StringUtil.join((Collection)commandLine, (String)" ");
        if (string == null) {
            StandardJSExternalAnnotator.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void addListArgument(List<String> commandLine, String name, List<String> values) {
        if (!values.isEmpty()) {
            commandLine.add("--" + name);
            commandLine.add(StringUtil.join(values, (String)","));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator";
                break;
            }
            case 2: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardJSState";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standardPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsConfigurable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsConfigurable";
                break;
            }
            case 1: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptPsiFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateESLintInput";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$apply$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

