/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JSHintIgnoreInfo {
    private static final char SEPARATOR_CHAR = '/';
    private static final Pattern[] TRUNCATING_PATTERNS = new Pattern[]{Pattern.compile("/[^/]*\\{.*\\}.*$"), Pattern.compile("/[^/]*!\\(.*$"), Pattern.compile("/[^/]*\\+\\(.*$"), Pattern.compile("/[^/]*\\)\\?.*$")};
    private final List<VirtualFile> myIgnoreRoots;
    private final List<Pattern> myIgnorePatterns;
    private final VirtualFile myIgnoreDir;

    public JSHintIgnoreInfo(@NotNull VirtualFile jshintIgnore, @NotNull List<String> patterns) {
        if (jshintIgnore == null) {
            JSHintIgnoreInfo.$$$reportNull$$$0(0);
        }
        if (patterns == null) {
            JSHintIgnoreInfo.$$$reportNull$$$0(1);
        }
        this.myIgnoreRoots = ContainerUtil.newArrayList();
        this.myIgnorePatterns = ContainerUtil.newArrayList();
        this.myIgnoreDir = jshintIgnore.getParent();
        if (this.myIgnoreDir != null && this.myIgnoreDir.isDirectory()) {
            for (String pattern : patterns) {
                String refinedPattern = pattern.replace('\\', '/');
                VirtualFile file2 = this.myIgnoreDir.findFileByRelativePath(refinedPattern = JSHintIgnoreInfo.findPrefix(refinedPattern));
                if (file2 != null && file2.isValid()) {
                    this.myIgnoreRoots.add(file2);
                    continue;
                }
                Pattern p = JSHintIgnoreInfo.buildPattern(refinedPattern);
                this.myIgnorePatterns.add(p);
            }
        }
    }

    @NotNull
    private static Pattern buildPattern(@NotNull String pattern) {
        int singleInd;
        if (pattern == null) {
            JSHintIgnoreInfo.$$$reportNull$$$0(2);
        }
        int i = 0;
        StringBuilder res = new StringBuilder("^");
        while (i < pattern.length() && (singleInd = pattern.indexOf("*", i)) != -1) {
            JSHintIgnoreInfo.addQuotePattern(res, pattern, i, singleInd);
            if (singleInd + 2 == pattern.length() && pattern.startsWith("**", singleInd)) {
                res.append(".*");
                i = singleInd + 2;
                continue;
            }
            if (pattern.startsWith("**/", singleInd)) {
                res.append(".*");
                i = singleInd + 3;
                continue;
            }
            res.append("[^/]*");
            i = singleInd + 1;
        }
        JSHintIgnoreInfo.addQuotePattern(res, pattern, i, pattern.length());
        res.append("$");
        Pattern pattern2 = Pattern.compile(res.toString());
        if (pattern2 == null) {
            JSHintIgnoreInfo.$$$reportNull$$$0(3);
        }
        return pattern2;
    }

    private static void addQuotePattern(@NotNull StringBuilder buf, @NotNull String pattern, int fromInc, int toExc) {
        if (buf == null) {
            JSHintIgnoreInfo.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            JSHintIgnoreInfo.$$$reportNull$$$0(5);
        }
        if (fromInc < toExc) {
            buf.append(Pattern.quote(pattern.substring(fromInc, toExc)));
        }
    }

    @NotNull
    public static String findPrefix(@NotNull String refinedPattern) {
        if (refinedPattern == null) {
            JSHintIgnoreInfo.$$$reportNull$$$0(6);
        }
        for (Pattern pattern : TRUNCATING_PATTERNS) {
            refinedPattern = pattern.matcher(refinedPattern).replaceFirst("");
        }
        String string = refinedPattern;
        if (string == null) {
            JSHintIgnoreInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isIgnore(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSHintIgnoreInfo.$$$reportNull$$$0(8);
        }
        for (VirtualFile root : this.myIgnoreRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        if (this.myIgnoreDir != null && !this.myIgnorePatterns.isEmpty() && VfsUtilCore.isAncestor((VirtualFile)this.myIgnoreDir, (VirtualFile)file2, (boolean)true)) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)this.myIgnoreDir, (char)'/');
            if (relativePath == null) {
                return false;
            }
            for (Pattern pattern : this.myIgnorePatterns) {
                Matcher matcher = pattern.matcher(relativePath);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jshintIgnore";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refinedPattern";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintIgnoreInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPattern";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildPattern";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addQuotePattern";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIgnore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

