/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeSubstitutorType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import gnu.trove.TIntObjectHashMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSGenericTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    private static final Logger LOGGER = Logger.getInstance(JSGenericTypeImpl.class);
    @NotNull
    private final JSType myType;
    @NotNull
    private final List<JSType> myArguments;

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull JSType argument) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(1);
        }
        if (argument == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(2);
        }
        this(source, type, (List<JSType>)ContainerUtil.immutableList((Object[])new JSType[]{argument}));
    }

    JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(4);
        }
        this(source, JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream), JSTypeSerializer.TYPES_SERIALIZER.read(source, inputStream));
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull List<JSType> arguments) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(5);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(6);
        }
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(7);
        }
        super(source);
        this.myType = type;
        ImmutableList finalGenerics = JSGenericTypeImpl.computeActualArguments(type, arguments);
        this.myArguments = finalGenerics instanceof ImmutableList ? finalGenerics : ContainerUtil.immutableList(finalGenerics);
    }

    @NotNull
    private static List<JSType> computeActualArguments(@NotNull JSType type, @NotNull List<JSType> arguments) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(8);
        }
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(9);
        }
        List<JSType> list = JSGenericTypeImpl.fixArguments(arguments, type);
        if (list == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static List<JSType> fixArguments(@NotNull List<JSType> arguments, @NotNull JSType type) {
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(11);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(12);
        }
        if (arguments.stream().noneMatch(arg -> arg instanceof JSNamedTypeSubstitutorType || arg == null)) {
            List<JSType> list = arguments;
            if (list == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        ArrayList newArgs = ContainerUtil.newArrayListWithCapacity((int)arguments.size());
        PsiElement sourceElement = type.getSource().getSourceElement();
        List typeParameterNames = null;
        if (sourceElement instanceof TypeScriptTypeParameterListOwner) {
            typeParameterNames = ContainerUtil.map((Object[])((TypeScriptTypeParameterListOwner)sourceElement).getTypeParameters(), p -> p.getName());
        }
        TIntObjectHashMap toInsert = new TIntObjectHashMap();
        for (JSType arg2 : arguments) {
            if (arg2 instanceof JSNamedTypeSubstitutorType) {
                int index;
                if (typeParameterNames == null || (index = typeParameterNames.indexOf(((JSNamedTypeSubstitutorType)arg2).getGenericName())) == -1) continue;
                toInsert.put(index, (Object)((JSNamedTypeSubstitutorType)arg2).getRealType());
                continue;
            }
            if (arg2 == null) {
                LOGGER.error("Generic argument must be not null");
                arg2 = JSAnyType.getByTypeSource(type.getSource());
            }
            newArgs.add(arg2);
        }
        int[] keys = toInsert.keys();
        Arrays.sort(keys);
        for (int key : keys) {
            if (key < newArgs.size()) continue;
            newArgs.add(toInsert.get(key));
        }
        ArrayList arrayList = newArgs;
        if (arrayList == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(15);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myArguments, outputStream);
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSGenericType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myType.accept(visitor);
        for (JSType argument : this.getArguments()) {
            argument.accept(visitor);
        }
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        StringBuilder builder = new StringBuilder();
        if (!this.isTypeScript()) {
            boolean wrapInBraces = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
            if (wrapInBraces) {
                builder.append("(");
            }
            builder.append(this.myType.getTypeText(format));
            if (wrapInBraces) {
                builder.append(")");
            }
            if (this.getSource().getLanguage() == JSTypeSource.SourceLanguage.AS) {
                builder.append('.');
            }
            this.appendArgumentTypeText(format, builder);
        } else {
            boolean isNestedFunctionType = this.myType instanceof JSFunctionTypeImpl;
            if (isNestedFunctionType) {
                this.appendArgumentTypeText(format, builder);
                builder.append(this.myType.getTypeText(format));
            } else {
                builder.append(this.myType.getTypeText(format));
                this.appendArgumentTypeText(format, builder);
            }
        }
        String string = builder.toString();
        if (string == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        int arguments = JSTypeResolvedHashCodeUtil.getResolvedHashCode(this.getArguments());
        return Objects.hash(this.getClass(), this.getType().resolvedHashCode(), arguments);
    }

    private void appendArgumentTypeText(@NotNull JSType.TypeTextFormat format, @NotNull StringBuilder builder) {
        if (format == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(17);
        }
        if (builder == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(18);
        }
        builder.append("<");
        String prefix = "";
        for (JSType argument : this.myArguments) {
            builder.append(prefix);
            builder.append(argument.getTypeText(format));
            prefix = ", ";
        }
        builder.append(">");
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        return this.myType.resolveClass();
    }

    private static boolean isResolvedTypeScript(@NotNull JSType type) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(19);
        }
        if (type.isEcma()) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl) {
            JSType nested = ((JSGenericTypeImpl)type).getType();
            return JSGenericTypeImpl.isResolvedTypeScript(nested);
        }
        if (type instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
            Collection<? extends PsiElement> declarations = info.getDeclarations();
            return !declarations.isEmpty() && declarations.stream().allMatch(el -> DialectDetector.isTypeScript(el));
        }
        return false;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(20);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(21);
        }
        JSType expanded = TypeScriptTypeRelations.expandAliasesForGenericArguments(this);
        JSType expandedElementType = TypeScriptTypeRelations.expandAliasesForGenericArguments(elementType);
        if (expanded != this || expandedElementType != elementType) {
            return expanded.isDirectlyAssignableType(expandedElementType, processingContext);
        }
        if (this.myArguments.size() == 0) {
            return this.myType.isDirectlyAssignableType(elementType, processingContext);
        }
        if (this.isTypeScript() || JSGenericTypeImpl.isResolvedTypeScript(elementType)) {
            return this.isDirectAssignableTypeInTypeScript(elementType, processingContext);
        }
        if (elementType instanceof JSGenericTypeImpl) {
            if (!this.myType.isDirectlyAssignableType(((JSGenericTypeImpl)elementType).myType, processingContext)) {
                return false;
            }
            List<JSType> elementTypeArgs = ((JSGenericTypeImpl)elementType).getArguments();
            ListIterator<JSType> iterator = elementTypeArgs.listIterator();
            boolean allArgumentsEquivalent = true;
            for (JSType argument : this.getArguments()) {
                allArgumentsEquivalent &= iterator.hasNext() && this.jsOrASGenericsCompatible(argument, iterator.next(), processingContext);
            }
            return allArgumentsEquivalent && !iterator.hasNext();
        }
        if (JSGenericTypeImpl.isGenericActionScriptVectorType(this) && !(elementType instanceof JSNullType) && !(elementType instanceof JSAnyType)) {
            return false;
        }
        if (elementType instanceof JSArrayTypeImpl) {
            return this.isDirectlyAssignableType(((JSArrayTypeImpl)elementType).asGenericType(), processingContext);
        }
        if (elementType instanceof JSTypeofTypeImpl) {
            return this.isDirectlyAssignableType(((JSTypeofTypeImpl)elementType).evaluateType(), processingContext);
        }
        return this.myType.isDirectlyAssignableType(elementType, processingContext);
    }

    private boolean isDirectAssignableTypeInTypeScript(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult type;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(22);
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        if (elementType instanceof JSTupleType) {
            return this.isDirectlyAssignableType(((JSTupleType)elementType).toArrayType(true), processingContext);
        }
        if (elementType instanceof JSArrayType) {
            elementType = ((JSArrayType)elementType).asGenericType();
        } else {
            JSType resolved;
            if (elementType instanceof JSCompositeTypeImpl) {
                JSCompositeTypeImpl composite = (JSCompositeTypeImpl)elementType;
                boolean isAssignable = true;
                for (JSType type2 : composite.getTypes()) {
                    if (this.isDirectlyAssignableType(type2, processingContext)) continue;
                    isAssignable = false;
                    break;
                }
                return isAssignable;
            }
            if (elementType instanceof JSRecordType && this != (resolved = this.substitute())) {
                return resolved.isDirectlyAssignableType(elementType, processingContext);
            }
        }
        if ((elementType instanceof JSGenericTypeImpl || elementType instanceof JSNamedType) && (type = this.isDirectlyAssignableInClassHierarchy(elementType, processingContext)).isStrict()) {
            return type.isAssignable();
        }
        JSType elemType = elementType;
        JSType resolved = this.substitute();
        if (resolved != this) {
            JSResolvedTypeId rTypeNestedId = (elementType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)elementType).getType() : elementType).getResolvedTypeId();
            JSResolvedTypeId lTypeNestedId = this.getType().getResolvedTypeId();
            ProcessingContext finalProcessingContext = processingContext;
            return JSRecursiveTypeUtil.computeWithRecursiveTypes(lTypeNestedId, rTypeNestedId, JSRecursiveTypeUtil.GENERICS_SUBSTITUTION, processingContext, (Getter<Boolean>)((Getter)() -> resolved.isDirectlyAssignableType(elemType, finalProcessingContext)));
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(23);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(24);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(25);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.myType.isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(26);
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(27);
        }
        if (!this.myType.isEquivalentTo(((JSGenericTypeImpl)type).myType, processingContext, allowResolve)) {
            return false;
        }
        return JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)type, processingContext, true, allowResolve) == JSTypeCastUtil.AssignableResult.ASSIGNABLE;
    }

    private boolean jsOrASGenericsCompatible(@NotNull JSType type1, @NotNull JSType type2, @Nullable ProcessingContext processingContext) {
        if (type1 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(28);
        }
        if (type2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(29);
        }
        if (type1.isEquivalentTo(type2, processingContext)) {
            return true;
        }
        if (this.isEcma()) {
            return false;
        }
        if ("Array".equals(JSTypeUtils.getQualifiedNameMatchingType(this.myType, false))) {
            return type1.isDirectlyAssignableType(type2, processingContext);
        }
        return type1.isDirectlyAssignableType(type2, processingContext) || type2.isDirectlyAssignableType(type1, processingContext);
    }

    private boolean areExplicitAssignable(@NotNull JSType lMainType, @NotNull JSType rMainType) {
        if (lMainType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(30);
        }
        if (rMainType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(31);
        }
        if ((this.isJavaScript() || rMainType.isJavaScript()) && lMainType instanceof JSResolvableType && rMainType instanceof JSResolvableType) {
            String lText = lMainType.getResolvedTypeText();
            String rText = rMainType.getResolvedTypeText();
            if ("PromiseLike".equals(lText) && "Promise".equals(rText) || "ArrayLike".equals(lText) && JSCommonTypeNames.ARRAY_LIKE_CLASSES.contains(rText)) {
                return true;
            }
        }
        return false;
    }

    private JSTypeCastUtil.AssignableResult isDirectlyAssignableInClassHierarchy(@NotNull JSType rElementType, @NotNull ProcessingContext processingContext) {
        boolean isSameMainType;
        boolean isGenericType;
        JSType rMainType;
        if (rElementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(32);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(33);
        }
        if (rElementType instanceof JSNamedType) {
            rMainType = rElementType;
            isGenericType = false;
        } else if (rElementType instanceof JSGenericTypeImpl) {
            rMainType = ((JSGenericTypeImpl)rElementType).myType;
            isGenericType = true;
        } else {
            return JSTypeCastUtil.AssignableResult.NOT_SURE;
        }
        boolean bl = isSameMainType = isGenericType && (this.myType.isEquivalentTo(rMainType, processingContext) || this.areExplicitAssignable(this.myType, rMainType));
        if (isSameMainType) {
            JSTypeCastUtil.AssignableResult assignableResult = JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)rElementType, processingContext, false, true);
            if (assignableResult.isAssignable() || !assignableResult.isStrict()) {
                return JSTypeCastUtil.AssignableResult.ASSIGNABLE;
            }
            if (this.myType instanceof JSPrimitiveArrayType && rMainType instanceof JSPrimitiveArrayType) {
                return JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
            }
        } else if (rMainType instanceof JSNamedType && this.myType instanceof JSNamedType) {
            Collection<? extends PsiElement> lOpElements = TypeScriptTypeParser.resolveElementsByType(this.myType);
            Collection<? extends PsiElement> rOpElements = TypeScriptTypeParser.resolveElementsByType(rMainType);
            for (PsiElement psiElement : lOpElements) {
                for (PsiElement psiElement2 : rOpElements) {
                    JSClass lParent;
                    JSClass rChild;
                    if (!(psiElement instanceof JSClass) || !(psiElement2 instanceof JSClass) || !JSInheritanceUtil.isParentClass(rChild = (JSClass)psiElement2, lParent = (JSClass)psiElement, false)) continue;
                    TypeScriptTypeParameterList lParameters = lParent instanceof TypeScriptTypeParameterListOwner ? ((TypeScriptTypeParameterListOwner)lParent).getTypeParameterList() : null;
                    JSTypeCastUtil.AssignableResult result2 = JSTypeCastUtil.AssignableResult.NOT_SURE;
                    if (lParameters != null) {
                        JSGenericTypeImpl guessedType;
                        JSTypeSource source = rMainType.getSource();
                        ArrayList rawGenerics = ContainerUtil.newArrayList();
                        for (TypeScriptTypeParameter parameter : lParameters.getTypeParameters()) {
                            String name = parameter.getName();
                            TypeScriptGenericParameterImpl toCheck = new TypeScriptGenericParameterImpl(TypeScriptTypeParser.getTypeParameterId((TypeScriptGenericOrMappedTypeParameter)parameter), source, null);
                            if (name == null) continue;
                            rawGenerics.add(toCheck);
                        }
                        List<JSType> typeArgumentsList = isGenericType ? ((JSGenericTypeImpl)rElementType).getArguments() : ContainerUtil.emptyList();
                        JSType type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(rChild, typeArgumentsList, lParent, guessedType = new JSGenericTypeImpl(rMainType.getSource(), rMainType, rawGenerics));
                        if (type instanceof JSGenericTypeImpl) {
                            result2 = JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)type, processingContext, false, true);
                        }
                    }
                    return result2;
                }
            }
        }
        return JSTypeCastUtil.AssignableResult.NOT_SURE;
    }

    private static JSTypeCastUtil.AssignableResult areGenericArgumentsAssignable(@NotNull JSGenericTypeImpl lType, @NotNull JSGenericTypeImpl rType, @Nullable ProcessingContext processingContext, boolean checkEquivalent, boolean allowResolve) {
        if (lType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(34);
        }
        if (rType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(35);
        }
        Iterator<JSType> iterator = rType.getArguments().iterator();
        for (JSType lArgument : lType.getArguments()) {
            if (!iterator.hasNext()) {
                return JSTypeCastUtil.AssignableResult.NOT_SURE;
            }
            JSType rArgument = iterator.next();
            if (!(checkEquivalent ? !lArgument.isEquivalentTo(rArgument, processingContext, allowResolve) : !lArgument.isDirectlyAssignableType(rArgument, processingContext))) continue;
            return JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
        }
        return iterator.hasNext() ? JSTypeCastUtil.AssignableResult.NOT_SURE : JSTypeCastUtil.AssignableResult.ASSIGNABLE;
    }

    public static boolean isGenericActionScriptVectorType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl && type.getSource().isEcma()) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            String typeText = genericType.myType.getResolvedTypeText();
            return "Vector".equals(typeText) && genericType.getArguments().size() == 1;
        }
        return false;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(36);
        }
        return jSType;
    }

    @NotNull
    public List<JSType> getArguments() {
        List<JSType> list = this.myArguments;
        if (list == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(37);
        }
        return list;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(38);
        }
        JSType oldType = this.getType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        List<JSType> oldArgs = this.getArguments();
        List newArgs = ContainerUtil.map(oldArgs, type -> {
            if (childTransform == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(48);
            }
            return JSTypeUtils.transformTypeHierarchySafe(type, childTransform);
        });
        if (newType == oldType && ContainerUtil.equalsIdentity(oldArgs, (List)newArgs)) {
            JSGenericTypeImpl jSGenericTypeImpl = this;
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(39);
            }
            return jSGenericTypeImpl;
        }
        if (newType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl newGenericType = (JSGenericTypeImpl)newType;
            JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), newGenericType.getType(), newGenericType.getArguments());
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(40);
            }
            return jSGenericTypeImpl;
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), newType, newArgs);
        if (jSGenericTypeImpl == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(41);
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(42);
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, this.getType(), this.getArguments());
        if (jSGenericTypeImpl == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(43);
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType type = this.getType();
        if (this.myArguments.size() == 0) {
            JSType jSType = type;
            if (jSType == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(44);
            }
            return jSType;
        }
        if (type instanceof TypeScriptGenericThisTypeImpl) {
            JSType jSType = new JSGenericTypeImpl(this.getSource(), type.substitute(), this.getArguments()).substitute();
            if (jSType == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(45);
            }
            return jSType;
        }
        JSType expandedThis = TypeScriptTypeRelations.expandAliasesForGenericArguments(this);
        if (expandedThis != this) {
            JSType jSType = JSTypeImpl.expandTypeOrBuildRecordTypeWithCache((JSTypeBaseImpl)expandedThis);
            if (jSType == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(46);
            }
            return jSType;
        }
        JSType jSType = JSTypeImpl.expandTypeOrBuildRecordTypeWithCache(this);
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(47);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 25: 
            case 26: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 25: 
            case 26: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 25: 
            case 26: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 21: 
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lMainType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rMainType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rElementType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 38: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeActualArguments";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fixArguments";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeActualArguments";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 25: 
            case 26: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fixArguments";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentTypeText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedTypeScript";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableTypeInTypeScript";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "jsOrASGenericsCompatible";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "areExplicitAssignable";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableInClassHierarchy";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "areGenericArgumentsAssignable";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyTypeHierarchy$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 25: 
            case 26: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

