/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSResolvedTypeIdCache {
    @NotNull
    private final ConcurrentMap<JSResolvedTypeId, JSRecordType> myCachedRecordTypes = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    @NotNull
    private final ConcurrentMap<JSResolvedTypeId, Map<Key<?>, Object>> myCachedValues = ContainerUtil.createConcurrentWeakKeySoftValueMap();

    @Nullable
    public <T> T getLocalCachedValue(@NotNull JSResolvedTypeId id, @NotNull Key<T> key, @NotNull Supplier<? extends T> supplier) {
        Map oldMap;
        Map map;
        if (id == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(0);
        }
        if (key == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(1);
        }
        if (supplier == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(2);
        }
        if ((map = (Map)this.myCachedValues.get(id)) == null && (oldMap = this.myCachedValues.putIfAbsent(id, map = ContainerUtil.createConcurrentWeakKeySoftValueMap())) != null) {
            map = oldMap;
        }
        Object el = map.get(key);
        JSType owner = id.getOwnerType();
        if (el != null) {
            return (T)(el == JSTypeBaseImpl.getSelfNoTransformationType() ? owner : el);
        }
        T result2 = supplier.get();
        if (result2 == null) {
            return null;
        }
        JSType stored = map.putIfAbsent(key, result2 == owner ? JSTypeBaseImpl.getSelfNoTransformationType() : result2);
        if (stored == JSTypeBaseImpl.getSelfNoTransformationType()) {
            return (T)owner;
        }
        return (T)(stored == null ? result2 : stored);
    }

    @NotNull
    public JSRecordType buildRecordType(@NotNull JSType type, @NotNull PsiElement sourceElement) {
        JSResolvedTypeId id;
        JSRecordType recordType;
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(4);
        }
        if ((recordType = (JSRecordType)this.myCachedRecordTypes.get(id = type.getResolvedTypeId())) != null) {
            JSRecordType jSRecordType = JSResolvedTypeIdCache.copyWithStrict(type, recordType);
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(5);
            }
            return jSRecordType;
        }
        JSRecordType candidate = JSResolvedTypeIdCache.buildRecordTypeNoCache(type, sourceElement);
        if (candidate == null) {
            Object object = type.isJavaScript() ? JSTypeCastUtil.NO_RECORD_TYPE : new JSRecordTypeImpl(type.getSource(), ContainerUtil.emptyList());
            if (object == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(6);
            }
            return object;
        }
        JSRecordType oldResult = this.myCachedRecordTypes.putIfAbsent(id, candidate);
        JSRecordType jSRecordType = oldResult == null ? candidate : JSResolvedTypeIdCache.copyWithStrict(type, oldResult);
        if (jSRecordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(7);
        }
        return jSRecordType;
    }

    @NotNull
    private static JSRecordType copyWithStrict(@NotNull JSType original, @NotNull JSRecordType recordType) {
        if (original == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(8);
        }
        if (recordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(9);
        }
        if (recordType == JSTypeCastUtil.NO_RECORD_TYPE) {
            JSRecordType jSRecordType = recordType;
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(10);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = (JSRecordType)recordType.copyWithStrict(original.isSourceStrict());
        if (jSRecordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(11);
        }
        return jSRecordType;
    }

    @Nullable
    private static JSRecordType buildRecordTypeNoCache(@NotNull JSType type, @NotNull PsiElement element) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(12);
        }
        if (element == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(13);
        }
        Object id = JSResolvedTypeIdCache.getIdForPreventingRecursion(type);
        return (JSRecordType)RecursionManager.doPreventingRecursion((Object)id, (boolean)false, () -> {
            if (type == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(20);
            }
            if (element == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(21);
            }
            JSType substitute = JSTypeWithIncompleteSubstitution.substituteCompletely((JSType)type);
            ProgressManager.checkCanceled();
            if (substitute != type) {
                return substitute.asRecordType();
            }
            Collection<? extends PsiElement> resolvedElements = JSResolvedTypeIdCache.resolveElementsForRecordType(type, element);
            if (type.isJavaScript() && (resolvedElements.isEmpty() || type instanceof JSObjectType)) {
                return JSTypeCastUtil.NO_RECORD_TYPE;
            }
            return TypeScriptTypeParser.buildResolvedType(resolvedElements, type);
        });
    }

    @NotNull
    private static Object getIdForPreventingRecursion(@NotNull JSType type) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(14);
        }
        if (type instanceof JSGenericTypeImpl) {
            Pair pair = Pair.create((Object)((JSGenericTypeImpl)type).getType().getResolvedTypeId(), type.getClass());
            if (pair == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(15);
            }
            return pair;
        }
        JSResolvedTypeId jSResolvedTypeId = type.getResolvedTypeId();
        if (jSResolvedTypeId == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(16);
        }
        return jSResolvedTypeId;
    }

    @NotNull
    private static Collection<? extends PsiElement> resolveElementsForRecordType(@NotNull JSType type, @NotNull PsiElement sourceElement) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(17);
        }
        if (sourceElement == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(18);
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, sourceElement);
        if (collection == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(19);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 3: 
            case 12: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSResolvedTypeIdCache";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSResolvedTypeIdCache";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRecordType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdForPreventingRecursion";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsForRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalCachedValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyWithStrict";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeNoCache";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIdForPreventingRecursion";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsForRecordType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildRecordTypeNoCache$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

