/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.ui;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.psi.impl.ElementBase;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.ui.RowIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.Collection;
import javax.swing.Icon;

public class JSMemberSelectionTable
extends AbstractMemberSelectionTable<JSAttributeListOwner, JSMemberInfo> {
    private static final Icon OUR_EMPTY_OVERRIDE_ICON = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)Math.max(AllIcons.General.OverridingMethod.getIconWidth(), AllIcons.General.ImplementingMethod.getIconWidth())));

    public JSMemberSelectionTable(Collection<JSMemberInfo> memberInfos, MemberInfoModel<JSAttributeListOwner, JSMemberInfo> memberInfoModel, String abstractColumnHeader) {
        super(memberInfos, memberInfoModel, abstractColumnHeader);
    }

    protected Object getAbstractColumnValue(JSMemberInfo memberInfo) {
        if (!this.myMemberInfoModel.isAbstractEnabled((MemberInfoBase)memberInfo)) {
            return false;
        }
        return memberInfo.isToAbstract() ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean isAbstractColumnEditable(int rowIndex) {
        JSMemberInfo memberInfo = (JSMemberInfo)((Object)this.myMemberInfos.get(rowIndex));
        return this.myMemberInfoModel.isAbstractEnabled((MemberInfoBase)memberInfo);
    }

    protected void setVisibilityIcon(JSMemberInfo memberInfo, RowIcon icon) {
    }

    protected Icon getOverrideIcon(JSMemberInfo memberInfo) {
        JSElement member = (JSElement)memberInfo.getMember();
        Icon overrideIcon = OUR_EMPTY_OVERRIDE_ICON;
        if (member instanceof JSFunction) {
            if (Boolean.TRUE.equals(memberInfo.getOverrides())) {
                overrideIcon = AllIcons.General.OverridingMethod;
            } else if (Boolean.FALSE.equals(memberInfo.getOverrides())) {
                overrideIcon = AllIcons.General.ImplementingMethod;
            }
        }
        return overrideIcon;
    }

    protected Icon getMemberIcon(JSMemberInfo memberInfo, int flags) {
        JSFunction method;
        if (memberInfo.getMember() instanceof JSFunction && ((method = (JSFunction)memberInfo.getMember()).getKind() == JSFunction.FunctionKind.GETTER || method.getKind() == JSFunction.FunctionKind.SETTER)) {
            Icon propertyIcon = JSFormatUtil.getPropertyIcon(method);
            JSAttributeList attributeList = method.getAttributeList();
            if (attributeList != null) {
                return ElementBase.buildRowIcon((Icon)propertyIcon, (Icon)attributeList.getAccessType().getIcon());
            }
        }
        return super.getMemberIcon((MemberInfoBase)memberInfo, flags);
    }
}

