/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.ECMAL4LanguageDialect;
import com.intellij.lang.javascript.dialects.TypeScriptJSXLanguageDialect;
import com.intellij.lang.javascript.dialects.TypeScriptLanguageDialect;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSIndexedPropertyAccessExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSDefinitionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSDefinitionExpressionStubImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefinitionExpressionElementType
extends JSStubElementType<JSDefinitionExpressionStub, JSDefinitionExpression> {
    public JSDefinitionExpressionElementType() {
        super("DEFINITION_EXPRESSION");
    }

    @NotNull
    public JSDefinitionExpressionStub createStub(@NotNull JSDefinitionExpression psi, StubElement parentStub) {
        if (psi == null) {
            JSDefinitionExpressionElementType.$$$reportNull$$$0(0);
        }
        JSDefinitionExpressionStubImpl jSDefinitionExpressionStubImpl = new JSDefinitionExpressionStubImpl(psi, parentStub);
        if (jSDefinitionExpressionStubImpl == null) {
            JSDefinitionExpressionElementType.$$$reportNull$$$0(1);
        }
        return jSDefinitionExpressionStubImpl;
    }

    @Nullable
    public PsiElement construct(ASTNode node) {
        return new JSDefinitionExpressionImpl(node);
    }

    @NotNull
    public JSDefinitionExpressionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JSDefinitionExpressionElementType.$$$reportNull$$$0(2);
        }
        JSDefinitionExpressionStubImpl jSDefinitionExpressionStubImpl = new JSDefinitionExpressionStubImpl(dataStream, parentStub);
        if (jSDefinitionExpressionStubImpl == null) {
            JSDefinitionExpressionElementType.$$$reportNull$$$0(3);
        }
        return jSDefinitionExpressionStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        ASTNode expressionNode = JSDefinitionExpressionImpl.getExpressionNode(node);
        if (expressionNode == null) {
            return false;
        }
        if (expressionNode.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            Language language;
            ASTNode nameElement = JSReferenceExpressionImpl.getNameElement(expressionNode);
            ASTNode qualifierNode = JSReferenceExpressionImpl.getQualifierNode(expressionNode);
            if (qualifierNode == null && nameElement != null && ((language = JSTreeUtil.getLanguage(node)) instanceof ECMAL4LanguageDialect || JSTreeUtil.definedInScopeAndUp(nameElement.getText(), node))) {
                return false;
            }
            return qualifierNode == null || qualifierNode.getElementType() != JSElementTypes.THIS_EXPRESSION || !((language = JSTreeUtil.getLanguage(node)) instanceof TypeScriptLanguageDialect) && !(language instanceof TypeScriptJSXLanguageDialect);
        }
        if (expressionNode.getElementType() == JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION) {
            ASTNode index = JSIndexedPropertyAccessExpressionImpl.getIndexExpression(expressionNode);
            return index != null && (index.getElementType() == JSStubElementTypes.LITERAL_EXPRESSION && JSLiteralExpressionImpl.isQuotedLiteral(index) || index.getElementType() == JSElementTypes.REFERENCE_EXPRESSION);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/types/JSDefinitionExpressionElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/types/JSDefinitionExpressionElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

