/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceAnnotationResult
extends JSLanguageServiceAnnotationResult {
    private static final int CANNOT_FIND_NAME_CODE = 2304;
    private static final String SUGGESTION = "suggestion";
    private final int myErrorCode;
    @Nullable
    private final String mySource;

    @NotNull
    public static TypeScriptLanguageServiceAnnotationResult buildAnnotation(@Nullable String fileName, @NotNull TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic) {
        String category;
        if (diagnostic == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmpty((String)(category = diagnostic.category))) {
            category = "error";
        }
        TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo start = diagnostic.start;
        TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnosticsLineInfo end = diagnostic.end;
        String fullErrorText = StringUtil.notNullize((String)diagnostic.text, (String)"error").trim();
        int newLine = fullErrorText.indexOf("\n");
        String tooltip = newLine > 0 ? TypeScriptLanguageServiceAnnotationResult.getTooltipText(fullErrorText) : null;
        TypeScriptLanguageServiceAnnotationResult typeScriptLanguageServiceAnnotationResult = new TypeScriptLanguageServiceAnnotationResult(fullErrorText, fileName, category, diagnostic.source, tooltip, diagnostic.code, start == null ? 0 : start.line, start == null ? 0 : start.offset, end == null ? 0 : end.line, end == null ? 0 : end.offset);
        if (typeScriptLanguageServiceAnnotationResult == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(1);
        }
        return typeScriptLanguageServiceAnnotationResult;
    }

    @NotNull
    private static String getTooltipText(@NotNull String fullErrorText) {
        if (fullErrorText == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(2);
        }
        String string = UIUtil.convertSpace2Nbsp((String)StringUtil.replace((String)XmlStringUtil.escapeString((String)fullErrorText, (boolean)false), (String)"\n", (String)"<br>"));
        if (string == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(3);
        }
        return string;
    }

    public TypeScriptLanguageServiceAnnotationResult(@NotNull String infoText, @Nullable String fileAbsolutePath) {
        if (infoText == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(4);
        }
        this(infoText, fileAbsolutePath, "info", null, null, -1, 0, 0, 0, 0);
    }

    public TypeScriptLanguageServiceAnnotationResult(@NotNull String errorText, @Nullable String fileAbsolutePath, @Nullable String category, @Nullable String source, @Nullable String tooltipText, int errorCode, int line, int column, int lineEnd, int columnEnd) {
        if (errorText == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(5);
        }
        super(errorText, tooltipText, fileAbsolutePath, category, line, column, lineEnd, columnEnd);
        this.myErrorCode = errorCode == -1 ? TypeScriptLanguageServiceAnnotationResult.getErrorCodeImpl(errorText) : errorCode;
        this.mySource = source;
    }

    public int getErrorCode() {
        return this.myErrorCode;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.getTextWithSourcePrefix(super.getDescription());
        if (string == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public String getTooltipText() {
        String tooltipText = super.getTooltipText();
        if (tooltipText == null) {
            return null;
        }
        return this.getTextWithSourcePrefix(tooltipText);
    }

    @NotNull
    private String getTextWithSourcePrefix(@NotNull String text) {
        if (text == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(7);
        }
        if (this.mySource != null) {
            String string = this.mySource + ": " + text;
            if (string == null) {
                TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = text.startsWith("TS") || this.myErrorCode <= 0 ? text : "TS" + this.myErrorCode + ": " + text;
        if (string == null) {
            TypeScriptLanguageServiceAnnotationResult.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @Nullable
    public String getCategory() {
        String category = super.getCategory();
        return SUGGESTION.equals(category) ? "hide" : category;
    }

    private static int getErrorCodeImpl(String myErrorText) {
        String prefix = "TS";
        if (myErrorText.startsWith(prefix)) {
            int endCode = myErrorText.indexOf(":");
            if (endCode == -1) {
                return -1;
            }
            String code = myErrorText.substring(prefix.length(), endCode);
            try {
                return Integer.valueOf(code.trim());
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public ProblemHighlightType getHighlightType() {
        int code = this.getErrorCode();
        if (code != -1 && 2304 == code) {
            return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeScriptLanguageServiceAnnotationResult result2 = (TypeScriptLanguageServiceAnnotationResult)o;
        return this.myErrorCode == result2.myErrorCode && Objects.equals(this.mySource, result2.mySource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myErrorCode, this.mySource);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullErrorText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceAnnotationResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithSourcePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAnnotation";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithSourcePrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

