/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.naming.ConventionInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FunctionNamingConventionJSInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("function.naming.convention.display.name", new Object[0]);
        if (string == null) {
            FunctionNamingConventionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.NAMING_CONVENTIONS_GROUP_NAME;
        if (string == null) {
            FunctionNamingConventionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public String buildErrorString(Object ... args) {
        String functionName = ((PsiElement)args[0]).getText();
        assert (functionName != null);
        if (functionName.length() < this.getMinLength()) {
            return InspectionJSBundle.message("function.name.is.too.short.error.string", functionName);
        }
        if (functionName.length() > this.getMaxLength()) {
            return InspectionJSBundle.message("function.name.is.too.long.error.string", functionName);
        }
        return InspectionJSBundle.message("function.name.doesnt.match.regex.error.string", functionName, this.getRegex());
    }

    @Override
    @NonNls
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/naming/FunctionNamingConventionJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            JSDocComment docComment;
            if (function == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSFunctionDeclaration(function);
            if (FunctionNamingConventionJSInspection.this.isInvalidName((PsiNameIdentifierOwner)function) && ((docComment = JSDocumentationUtils.findOwnDocComment((PsiElement)function)) == null || !docComment.isClassExplicitly() && !function.isConstructor())) {
                this.registerFunctionError(function);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/naming/FunctionNamingConventionJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

