/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.rewriting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.apacheConfig.lexer.ApacheConfigTokenTypes;
import com.intellij.lang.apacheConfig.psi.ACArgument;
import com.intellij.lang.apacheConfig.psi.ACDirectiveBase;
import com.intellij.lang.apacheConfig.psi.ACPsiUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.List;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;

public class RegexLanguageInjector
implements LanguageInjector {
    public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        if (host == null) {
            RegexLanguageInjector.$$$reportNull$$$0(0);
        }
        if (injectionPlacesRegistrar == null) {
            RegexLanguageInjector.$$$reportNull$$$0(1);
        }
        if (!(host instanceof ACArgument)) {
            return;
        }
        ACDirectiveBase directiveBase = ACPsiUtils.getDirectiveBase((PsiElement)host);
        if (directiveBase == null) {
            return;
        }
        String name = directiveBase.getName();
        List<ACArgument> arguments = directiveBase.getArguments();
        if ("RewriteRule".equals(name)) {
            if (arguments.get(0) == host) {
                RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
            }
        } else if ("FilesMatch".equals(name)) {
            RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
        } else if ("Files".equals(name)) {
            if (arguments.size() == 2 && arguments.get(1) == host && arguments.get(0).getText().equals("~")) {
                RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
            }
        } else if ("BrowserMatch".equals(name) || "BrowserMatchNoCase".equals(name)) {
            if (arguments.get(0) == host) {
                RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
            }
        } else if ("RedirectMatch".equals(name)) {
            if (arguments.size() == 3 && arguments.get(1) == host || arguments.size() == 2 && arguments.get(0) == host) {
                RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
            }
        } else if (("SetEnvIf".equals(name) || "SetEnvIfNoCase".equals(name)) && arguments.size() >= 2 && arguments.get(1) == host) {
            RegexLanguageInjector.inject(host, injectionPlacesRegistrar);
        }
    }

    private static void inject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces injectionPlacesRegistrar) {
        if (host == null) {
            RegexLanguageInjector.$$$reportNull$$$0(2);
        }
        if (injectionPlacesRegistrar == null) {
            RegexLanguageInjector.$$$reportNull$$$0(3);
        }
        injectionPlacesRegistrar.addPlace((Language)RegExpLanguage.INSTANCE, RegexLanguageInjector.getInjectionTextRange(host), null, null);
    }

    @NotNull
    private static TextRange getInjectionTextRange(@NotNull PsiLanguageInjectionHost host) {
        ASTNode node;
        if (host == null) {
            RegexLanguageInjector.$$$reportNull$$$0(4);
        }
        if ((node = host.getNode()) != null) {
            ASTNode lexem = node.findChildByType(ApacheConfigTokenTypes.ARG_LEXEM);
            if (lexem != null) {
                TextRange lexemRange;
                TextRange parent = host.getTextRange();
                if (parent.contains(lexemRange = lexem.getTextRange())) {
                    int start = lexemRange.getStartOffset() - parent.getStartOffset();
                    TextRange textRange = new TextRange(start, start + lexemRange.getLength());
                    if (textRange == null) {
                        RegexLanguageInjector.$$$reportNull$$$0(5);
                    }
                    return textRange;
                }
            } else {
                ASTNode close;
                PsiElement sibling;
                ASTNode open = node.findChildByType(ApacheConfigTokenTypes.QUOTE);
                PsiElement psiElement = sibling = open == null ? null : open.getPsi().getNextSibling();
                if (sibling != null && sibling.getNode() != null && (close = node.findChildByType(ApacheConfigTokenTypes.QUOTE, sibling.getNode())) != null) {
                    TextRange parent = host.getTextRange();
                    int openEndOffset = open.getTextRange().getEndOffset();
                    int start = openEndOffset - parent.getStartOffset();
                    int end = start + (close.getStartOffset() - openEndOffset);
                    if (start >= 0 && end <= parent.getEndOffset()) {
                        TextRange textRange = new TextRange(start, end);
                        if (textRange == null) {
                            RegexLanguageInjector.$$$reportNull$$$0(6);
                        }
                        return textRange;
                    }
                }
            }
        }
        TextRange textRange = new TextRange(0, host.getTextLength());
        if (textRange == null) {
            RegexLanguageInjector.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPlacesRegistrar";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/apacheConfig/rewriting/RegexLanguageInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/apacheConfig/rewriting/RegexLanguageInjector";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionTextRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

