/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.profilers.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StopAsyncProfileCommand
extends AbstractCommand {
    public static final String PREFIX = "%stopAsyncProfile";
    private final Project myProject;

    public StopAsyncProfileCommand(String text, int line, Project project) {
        super(text, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper(this.myProject);
        List<String> parameters = Arrays.stream(this.getText().substring(PREFIX.length()).trim().split(",")).filter(parameter -> !StringUtil.isEmpty((String)parameter)).collect(Collectors.toList());
        try {
            String reportsPath = AsyncProfilerHandler.getInstance(this.myProject).stopProfiling(parameters);
            ProfilersController.getInstance().setReportsPath(reportsPath);
            ProfilersController.getInstance().setStoppedByScript(true);
            actionCallback.setDone();
            AsyncProfilerHandler.getInstance(this.myProject).showCompleteNotification();
        }
        catch (Exception exception) {
            actionCallback.reject(MessagesBundle.message("command.stop.notstarted", new Object[0]));
        }
        return Promises.toPromise((ActionCallback)actionCallback);
    }
}

